/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation;

import com.semarchy.xdi.designer.core.services.IGenerationService;
import com.semarchy.xdi.designer.core.utils.ParameterBuilder;
import java.io.PrintStream;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.eclipse.core.runtime.Assert;
import org.osgi.service.component.annotations.Component;

@Component(service={IGenerationService.LoggingConfigurationFactory.class})
public class DefaultLoggingConfigurationFactory
implements IGenerationService.LoggingConfigurationFactory<Project> {
    public IGenerationService.LoggingConfiguration<Project> create(ParameterBuilder<IGenerationService.LoggingConfigurationOption, Object> parameters) {
        Object stdPrintStream = parameters.get((Object)IGenerationService.LoggingConfigurationOption.STD_PRINT_STREAM);
        Object errPrintStream = parameters.get((Object)IGenerationService.LoggingConfigurationOption.ERR_PRINT_STREAM);
        Assert.isTrue((boolean)(stdPrintStream instanceof PrintStream), (String)String.format("%s is not a Printstream", String.valueOf(stdPrintStream)));
        Assert.isTrue((boolean)(errPrintStream instanceof PrintStream), (String)String.format("%s is not a Printstream", String.valueOf(errPrintStream)));
        return new DefaultLoggingConfiguration((PrintStream)stdPrintStream, (PrintStream)errPrintStream);
    }

    private class DefaultLoggingConfiguration
    implements IGenerationService.LoggingConfiguration<Project> {
        private PrintStream outputStream;
        private PrintStream errorStream;

        public DefaultLoggingConfiguration(PrintStream outputStream, PrintStream errorStream) {
            this.errorStream = errorStream;
            this.outputStream = outputStream;
        }

        public void apply(Project ant) {
            DefaultLogger log = new DefaultLogger(){

                public void buildFinished(BuildEvent event) {
                    if (event.getException() != null) {
                        this.handleExecutionError((Exception)event.getException(), this.getBuildFailedMessage());
                    } else {
                        super.buildFinished(event);
                    }
                }

                public void handleExecutionError(Exception ex, String failureMessage) {
                    StringBuilder message = new StringBuilder();
                    message.append(System.getProperty("line.separator"));
                    message.append(failureMessage);
                    message.append(System.getProperty("line.separator"));
                    this.printMessage(message.toString(), this.err, 0);
                    ex.printStackTrace(this.err);
                }
            };
            log.setErrorPrintStream(this.errorStream);
            log.setOutputPrintStream(this.outputStream);
            log.setMessageOutputLevel(2);
            ant.addBuildListener((BuildListener)log);
        }
    }
}

