/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation;

import com.indy.xsl.global.IWorkbenchMethod;
import com.indy.xsl.global.WorkbenchInvocation;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IGenerationService;
import com.semarchy.xdi.designer.core.services.IInternalResourceRegistry;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.services.registry.LevelCodeInfo;
import com.semarchy.xdi.designer.core.services.registry.ProcessToolDescriptor;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.EnvironmentVariableHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import com.semarchy.xdi.designer.generation.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;

class WorkbenchInvocationInitializer {
    WorkbenchInvocationInitializer() {
    }

    static void addMethods(final Map<String, String> sourceIdToLocalFilerMap, final IRegistryService registryService, final ICacheService cacheService) {
        WorkbenchInvocation.INSTANCE.addMethod("resolveEclipseVariable", new IWorkbenchMethod(){

            public Object run(Object ... params) throws Exception {
                if (params.length > 0) {
                    try {
                        return EnvironmentVariableHelper.resolveEnvironmentVariables((String)((String)params[0]), (EnvironmentVariableHelper.Mode)EnvironmentVariableHelper.Mode.ProcModel);
                    }
                    catch (Exception ex) {
                        throw new Exception(Messages.bind((String)Messages.ExecuteAnt_2, (Object)params[0], (Object)ex.getMessage()), ex);
                    }
                }
                return null;
            }
        });
        WorkbenchInvocation.INSTANCE.addMethod("buildLevelCodeImage", new IWorkbenchMethod(){
            Map<String, Object> cachedResult = new HashMap<String, Object>();
            IGenerationService.IGenerationImageService service = (IGenerationService.IGenerationImageService)E4InjectorHelper.getService(IGenerationService.IGenerationImageService.class);

            public Object run(Object ... params) throws Exception {
                if (params.length == 2) {
                    IRegistryService.IRegistry registry;
                    List result;
                    String levelCode = (String)params[0];
                    if (levelCode == null || levelCode.equals("")) {
                        return null;
                    }
                    String outputPath = (String)params[1];
                    Object res = this.cachedResult.get(levelCode);
                    if (res == null && (result = (registry = registryService.getRegistry(LevelCodeInfo.class)).find((IRegistryService.IRegistryMatcher)new LevelCodeInfo.LevelCodeMatcher((String)params[0]))) != null && !result.isEmpty()) {
                        Object candidate = null;
                        for (LevelCodeInfo i : result) {
                            if (i.getImageURI() == null) continue;
                            if (candidate == null) {
                                candidate = i.getImageURI();
                                continue;
                            }
                            if (!candidate.toString().endsWith("icons/full/obj16/default_icon.gif") || i.getImageURI().toString().endsWith("icons/full/obj16/default_icon.gif")) continue;
                            candidate = i.getImageURI();
                            break;
                        }
                        if (candidate != null) {
                            File outputFile = new File(String.valueOf(outputPath) + "/___internal___/metadata/images/" + levelCode + ".png");
                            this.service.saveImageAsPNG(outputFile, (URI)candidate);
                            res = candidate;
                            this.cachedResult.put(levelCode, res);
                        } else {
                            this.cachedResult.put(levelCode, new Object());
                        }
                    }
                }
                return null;
            }
        });
        WorkbenchInvocation.INSTANCE.addMethod("isTemplate", new IWorkbenchMethod(){
            Collection<String> internalResourcesId = null;
            IInternalResourceRegistry registry = (IInternalResourceRegistry)E4InjectorHelper.getService(IInternalResourceRegistry.class);
            ICacheService indexService = (ICacheService)E4InjectorHelper.getService(ICacheService.class);

            public Object run(Object ... params) throws Exception {
                if (params.length == 1) {
                    if (this.internalResourcesId == null) {
                        this.internalResourcesId = new HashSet<String>();
                        for (URI u : this.registry.getInternalResourceURI()) {
                            String fileID = this.indexService.getSourceId(u);
                            this.internalResourcesId.add(fileID);
                        }
                    }
                    return String.valueOf(this.internalResourcesId.contains(params[0]));
                }
                return "false";
            }
        });
        WorkbenchInvocation.INSTANCE.addMethod("buildImageMethodIds", new IWorkbenchMethod(){
            IGenerationService.IGenerationImageService service = (IGenerationService.IGenerationImageService)E4InjectorHelper.getService(IGenerationService.IGenerationImageService.class);

            public Object run(Object ... params) throws Exception {
                if (params.length == 2) {
                    try {
                        this.service.generateById((List)params[0], (String)params[1]);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                return null;
            }
        });
        WorkbenchInvocation.INSTANCE.addMethod("clearImages", new IWorkbenchMethod(){
            IGenerationService.IGenerationImageService service = (IGenerationService.IGenerationImageService)E4InjectorHelper.getService(IGenerationService.IGenerationImageService.class);

            public Object run(Object ... params) throws Exception {
                this.service.clearImages();
                return null;
            }
        });
        WorkbenchInvocation.INSTANCE.addMethod("buildActionCodeImage", new IWorkbenchMethod(){
            Map<String, ProcessToolDescriptor.ActionDefinition> actionDefPerClassName = null;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Object run(Object ... params) throws Exception {
                ProcessToolDescriptor.ActionDefinition def;
                if (params.length != 4) return null;
                if (this.actionDefPerClassName == null) {
                    this.actionDefPerClassName = new HashMap<String, ProcessToolDescriptor.ActionDefinition>();
                    IRegistryService.IRegistry reg = registryService.getRegistry(ProcessToolDescriptor.class);
                    for (ProcessToolDescriptor d : reg.getAll()) {
                        if (!(d instanceof ProcessToolDescriptor.ActionDefinition)) continue;
                        this.actionDefPerClassName.put(((ProcessToolDescriptor.ActionDefinition)d).getClassName(), (ProcessToolDescriptor.ActionDefinition)d);
                    }
                }
                if ((def = this.actionDefPerClassName.get(params[0])) == null) return null;
                URL url = null;
                if (((String)params[3]).equals("false")) {
                    url = new URL(def.getSmallIcon().getKey());
                    url = new URL(def.getSmallIcon().getKey());
                } else {
                    url = new URL(def.getLargeIcon().getKey());
                }
                Object object = null;
                Object var5_6 = null;
                try {
                    ReadableByteChannel readableByteChannel = Channels.newChannel(url.openStream());
                    try {
                        try (FileOutputStream fileOutputStream = new FileOutputStream((String)params[2]);){
                            fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                        }
                        if (readableByteChannel == null) return null;
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        if (readableByteChannel == null) throw object;
                        readableByteChannel.close();
                        throw object;
                    }
                    readableByteChannel.close();
                    return null;
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                        throw object;
                    } else {
                        if (object == throwable) throw object;
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
            }
        });
        WorkbenchInvocation.INSTANCE.addMethod("getRawLocationURI", new IWorkbenchMethod(){
            private XDIModelURIResolver resolver = (XDIModelURIResolver)E4InjectorHelper.getService(XDIModelURIResolver.class);

            private File getWorkspaceFileFromModelId(String resourceID) {
                URI uri = cacheService.findResourceURIByFileId(resourceID);
                return this.resolver.resolve(uri);
            }

            public Object run(Object ... params) throws Exception {
                if (params.length == 1) {
                    File file = this.getWorkspaceFileFromModelId((String)params[0]);
                    if (file != null && file.exists() && file.isFile()) {
                        java.net.URI uri = file.toURI();
                        return uri.toString();
                    }
                    String s = (String)sourceIdToLocalFilerMap.get(params[0]);
                    if (s != null) {
                        return s;
                    }
                }
                return null;
            }
        });
        WorkbenchInvocation.INSTANCE.addMethod("getLocalLocationURI", new IWorkbenchMethod(){
            private XDIModelURIResolver resolver = (XDIModelURIResolver)E4InjectorHelper.getService(XDIModelURIResolver.class);

            public Object run(Object ... params) throws Exception {
                if (params.length == 1) {
                    IPath path;
                    URI uri = cacheService.findResourceURIByFileId((String)params[0]);
                    if (this.resolver.exists(uri) && (path = URIUtils.toPath((URI)uri)) != null) {
                        return path.toString();
                    }
                    String s = (String)sourceIdToLocalFilerMap.get(params[0]);
                    if (s != null) {
                        return s;
                    }
                }
                return null;
            }
        });
        WorkbenchInvocation.INSTANCE.addMethod("datastorePhysicalName", new IWorkbenchMethod(){

            public Object run(Object ... params) throws Exception {
                if (params.length == 3) {
                    String name;
                    String mappingID = (String)params[2];
                    String datastoreID = (String)params[1];
                    String datastoreAlias = (String)params[0];
                    List l = cacheService.getDependencyHelper().getReferenceEltID(datastoreID, mappingID);
                    if (l.size() == 1 && (name = cacheService.getEltName((String)l.get(0), mappingID)) != null && !name.isEmpty()) {
                        if (datastoreAlias.equals(name)) {
                            return "";
                        }
                        return " ( " + name + ")";
                    }
                }
                return "";
            }
        });
    }
}

