/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.cli;

import com.indy.shell.parser.CommandAnalyzer;
import com.indy.shell.parser.ShellCommand;
import com.indy.shell.parser.ShellCommandParameter;
import com.semarchy.xdi.designer.core.services.IEvaluationConfigurationService;
import com.semarchy.xdi.designer.core.services.IGenerationService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.generation.ExecuteAnt;
import com.semarchy.xdi.designer.generation.cli.Messages;
import com.semarchy.xdi.designer.generation.cli.PathResolver;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.apache.felix.shell.Command;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@ShellCommand
@Deprecated
@Component(property={"osgi.command.scope=stb", "osgi.command.function=build"}, service={Command.class}, enabled=true)
public class BuildShellCommand
implements Command {
    private String antActionType;
    @ShellCommandParameter(position=1)
    private String sourcePath;
    @ShellCommandParameter(commutator="target")
    private String outputFolder;
    @ShellCommandParameter(commutator="targetName")
    private String outputName;
    @ShellCommandParameter(position=0)
    private String buildType;
    @ShellCommandParameter(commutator="conf")
    private String confName;
    @ShellCommandParameter(commutator="sources")
    private Boolean includeSources = null;

    public void execute(String line, PrintStream out, PrintStream err) {
        this.antActionType = null;
        this.buildType = null;
        this.confName = null;
        this.includeSources = null;
        this.outputFolder = null;
        this.outputName = null;
        this.sourcePath = null;
        PrintWriter writer = new PrintWriter(out);
        try {
            this.parseLine(line.trim().substring(this.getName().length() + 1));
        }
        catch (Exception ex) {
            ex.printStackTrace(err);
            writer.println(String.valueOf(Messages.BuildShellCommand_0) + ex.getMessage());
            return;
        }
        try {
            try {
                IStatus res = this.perform();
                if (res.isOK()) {
                    writer.println(String.valueOf(Messages.BuildShellCommand_1) + this.buildType);
                } else {
                    writer.println(String.valueOf(Messages.BuildShellCommand_2) + res.getMessage());
                    if (res.getException() != null) {
                        res.getException().printStackTrace(err);
                    }
                }
            }
            catch (Exception ex) {
                writer.println(String.valueOf(Messages.BuildShellCommand_3) + ex.getMessage());
                writer.flush();
                ex.printStackTrace(err);
                err.flush();
                if (writer != null) {
                    writer.flush();
                }
            }
        }
        finally {
            if (writer != null) {
                writer.flush();
            }
        }
    }

    private IStatus perform() throws Exception {
        if (this.sourcePath == null) {
            throw new Exception(Messages.BuildShellCommand_4);
        }
        StringBuilder pathList = new StringBuilder();
        HashSet<String> fileNames = new HashSet<String>();
        String defaultDelivName = null;
        int count = 0;
        String[] stringArray = this.sourcePath.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            PathResolver.WkspPathLocation srcLocation = PathResolver.resolveWorkspaceRelativePath(s);
            pathList.append(srcLocation.getSourceFile().toURL().getFile());
            pathList.append("|");
            pathList.append(srcLocation.getPath());
            pathList.append(";");
            if (!fileNames.add(srcLocation.getURI().lastSegment())) {
                throw new CoreException((IStatus)new Status(4, "com.indy.ui.build.launchers", "Multiple processes with the name " + srcLocation.getURI().lastSegment() + ". A Package does not support having multiples process with the same name."));
            }
            if (defaultDelivName == null) {
                defaultDelivName = srcLocation.getURI().trimFileExtension().lastSegment();
            }
            ++count;
            ++n2;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        if (this.includeSources == Boolean.TRUE) {
            options.put("package.includeSources", "true");
        } else {
            options.put("package.includeSources", "false");
        }
        if (count > 1) {
            options.put("package.multiProc.paths", pathList.toString());
            if (this.outputFolder != null) {
                options.put("com.indy.launchers.configurations.packageOutputFolder", this.outputFolder);
            }
            options.put("com.indy.launchers.configurations.packageOutputName", this.outputName == null ? String.valueOf(defaultDelivName) + ".pck" : this.outputName);
            options.put("com.indy.launchers.configurations.packageOutputConfName", this.confName);
            options.put("package.multiProc.paths", pathList.toString());
            options.put("package.multiProc.packageId", UUID.randomUUID().toString());
            if (this.includeSources == Boolean.TRUE) {
                options.put("package.includeSources", "true");
            } else {
                options.put("package.includeSources", "false");
            }
            this.antActionType = "package.multiProc";
            if (!this.buildType.equals("package")) {
                if (this.buildType.equals("delivery")) {
                    this.antActionType = "delivery.procToDeliv";
                } else if (this.buildType.equals("packageWithDocumentation")) {
                    options.put("package.multiProc.generateDocumentation", "true");
                } else {
                    if (this.buildType == null) {
                        throw new Exception("Missing buidType argument");
                    }
                    throw new Exception(Messages.bind((String)Messages.BuildShellCommand_23, (Object)"buildType ", (Object)this.buildType));
                }
            }
            IEvaluationConfigurationService evalService = (IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class);
            String previousConfName = evalService.getCurrentConfigurationName();
            try {
                IStatus res;
                if (this.confName != null && !this.confName.isEmpty()) {
                    evalService.setCurrentConfigurationName(this.confName, false);
                }
                ExecuteAnt ant = new ExecuteAnt(null);
                IStatus iStatus = res = ant.run(this.antActionType, IGenerationService.EnvironmentInitializer.of(options, null), null);
                return iStatus;
            }
            finally {
                evalService.setCurrentConfigurationName(previousConfName, false);
            }
        }
        URI sourceURI = URI.createPlatformResourceURI((String)this.sourcePath, (boolean)true);
        if (this.buildType.equals("package")) {
            this.antActionType = "package.full.create";
        } else if (this.buildType.equals("delivery")) {
            this.antActionType = "delivery.procToDeliv";
        } else if (this.buildType.equals("packageWithDocumentation")) {
            this.antActionType = "package.full.create.doc";
        } else {
            if (this.buildType == null) {
                throw new Exception("Missing buidType argument");
            }
            throw new Exception("buildType " + this.buildType + " invalid value");
        }
        if (this.outputFolder != null) {
            options.put("com.indy.launchers.configurations.packageOutputFolder", this.outputFolder);
            if (this.outputName != null) {
                options.put("com.indy.launchers.configurations.packageOutputName", this.outputName);
            }
        }
        IEvaluationConfigurationService evalService = (IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class);
        String previousConfName = evalService.getCurrentConfigurationName();
        try {
            IStatus res;
            if (this.confName != null && !this.confName.isEmpty()) {
                evalService.setCurrentConfigurationName(this.confName, false);
            }
            ExecuteAnt ant = new ExecuteAnt(sourceURI);
            IStatus iStatus = res = ant.run(this.antActionType, IGenerationService.EnvironmentInitializer.of(options, null), null);
            return iStatus;
        }
        finally {
            evalService.setCurrentConfigurationName(previousConfName, false);
        }
    }

    public String getName() {
        return "build";
    }

    public String getShortDescription() {
        return Messages.BuildShellCommand_25;
    }

    public String getUsage() {
        return "build [delivery|package|packageWithDocumentation] <sourceFilePathInWksp1;...> [-target <folderInFileSystem>] [-conf <confName>] [-sources <includeSources>]";
    }

    public void build(String ... params) {
        StringBuilder b = new StringBuilder();
        b.append(String.valueOf(this.getName()) + " ");
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("-")) {
                b.append(String.valueOf(s) + " ");
            } else {
                b.append("\"" + s + "\" ");
            }
            ++n2;
        }
        this.execute(b.toString(), System.out, System.err);
    }

    private void parseLine(String line) throws Exception {
        CommandAnalyzer helper = new CommandAnalyzer();
        helper.prepare((Object)this, line);
    }
}

