/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.cli;

import com.indy.ant.ManifestMarshallingHelper;
import com.indy.ant.PackageManifest;
import com.indy.engine.common.delivery.DeliveryBuilder;
import com.indy.engine.core.module.impl.ModuleServiceImpl;
import com.indy.shell.parser.CommandAnalyzer;
import com.indy.shell.parser.ShellCommand;
import com.indy.shell.parser.ShellCommandParameter;
import com.semarchy.xdi.designer.core.services.IGenerationService;
import com.semarchy.xdi.designer.core.utils.RuntimeLocationHelper;
import com.semarchy.xdi.designer.generation.ExecuteAnt;
import com.semarchy.xdi.designer.generation.cli.LoggingConfigurationHelper;
import com.semarchy.xdi.designer.generation.cli.Messages;
import com.semarchy.xdi.designer.generation.cli.PathResolver;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.felix.shell.Command;
import org.apache.tools.ant.Project;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@ShellCommand
@Component(property={"osgi.command.scope=stb", "osgi.command.function=buildDelivery"}, service={Command.class}, enabled=true)
public class DeliveryShellCommand
implements Command {
    private static final String DEFAULT_RUNTIME_MODULE_FOLDER = "||runtimeFolder||";
    @ShellCommandParameter(commutator="package")
    private String packageFilePath;
    @ShellCommandParameter(commutator="buildmode")
    private Mode buildMode;
    @ShellCommandParameter(commutator="confFile")
    private String configurationFilePath;
    @ShellCommandParameter(commutator="outputFolder")
    private String deliveryFolder;
    @ShellCommandParameter(commutator="processName")
    private String processName;
    @ShellCommandParameter(commutator="verbose")
    private boolean debug;
    @ShellCommandParameter(commutator="verifyModules", defaultValue="||runtimeFolder||")
    private String moduleFolderPath;
    private File moduleFolder;
    @Reference
    private IGenerationService.LoggingConfigurationFactory<Project> loggingConfigurationFactory;

    private void parseLine(String line) throws Exception {
        CommandAnalyzer helper = new CommandAnalyzer();
        helper.prepare((Object)this, line);
    }

    public void execute(String line, PrintStream out, PrintStream err) {
        this.buildMode = null;
        this.configurationFilePath = null;
        this.debug = false;
        this.deliveryFolder = null;
        this.packageFilePath = null;
        this.processName = null;
        this.moduleFolderPath = null;
        this.moduleFolder = null;
        PrintWriter writer = new PrintWriter(out);
        try {
            this.parseLine(line.trim().substring(this.getName().length() + 1));
        }
        catch (Exception ex) {
            ex.printStackTrace(err);
            writer.println("ERROR - Command Parsing - " + ex.getMessage());
            return;
        }
        this.packageFilePath = PathResolver.resolveFileSystemPath(this.packageFilePath);
        this.deliveryFolder = PathResolver.resolveFileSystemPath(this.deliveryFolder);
        try {
            try {
                IStatus res = this.perform(out, err);
                if (res.isOK()) {
                    writer.println("SUCCESS - Built Deliveries in " + this.deliveryFolder);
                } else {
                    writer.println("ERROR - Generation - " + res.getMessage());
                    if (res.getException() != null) {
                        res.getException().printStackTrace(err);
                    }
                }
            }
            catch (Exception ex) {
                writer.println("ERROR - Initialization - " + ex.getMessage());
                writer.flush();
                ex.printStackTrace(err);
                err.flush();
                writer.flush();
            }
        }
        finally {
            writer.flush();
        }
    }

    public String getName() {
        return "buildDelivery";
    }

    public String getShortDescription() {
        return "Build a delivery from a package file.";
    }

    public String getUsage() {
        return "buildDelivery -package <packageFilePath> -buildmode [substitution|generation] [-confFile <configurationFilePath>] [-outputFolder <outputFolder>]  [-processName <processName>] [-verbose <verbose>]";
    }

    private IStatus perform(PrintStream out, PrintStream err) throws Exception {
        File packageFile;
        if (this.buildMode == null) {
            this.buildMode = Mode.substitution;
        }
        if (this.moduleFolderPath != null) {
            this.moduleFolder = this.moduleFolderPath.equals(DEFAULT_RUNTIME_MODULE_FOLDER) ? new File(RuntimeLocationHelper.getRuntimeLocation(), "modules") : new File(this.moduleFolderPath);
            if (!this.moduleFolder.exists() || this.moduleFolder.isFile()) {
                throw new Exception(String.format(Messages.DeliveryShellCommand_3, this.moduleFolder.getAbsolutePath()));
            }
        }
        if (!(packageFile = new File(this.packageFilePath)).exists()) {
            throw new Exception("The package file " + packageFile + " does not exist.");
        }
        if (!packageFile.isFile()) {
            throw new Exception(packageFile + " is not a file.");
        }
        File confFile = null;
        if (this.configurationFilePath != null) {
            confFile = new File(this.configurationFilePath);
            if (!confFile.exists()) {
                throw new Exception("The conf file " + confFile + " does not exist.");
            }
            if (!packageFile.isFile()) {
                throw new Exception(confFile + " is not a file.");
            }
        }
        File delivFolder = null;
        delivFolder = this.deliveryFolder == null ? new File(RuntimeLocationHelper.getRuntimeLocation(), "build/deliveries") : new File(this.deliveryFolder);
        switch (this.buildMode) {
            case generation: {
                return this.generateDelivery(packageFile, confFile, delivFolder, out, err);
            }
            case substitution: {
                return this.substituteDelivery(packageFile, confFile, delivFolder);
            }
        }
        throw new Exception("BuildMode " + (Object)((Object)this.buildMode) + " not supported");
    }

    private IStatus substituteDelivery(File packageFile, File confFile, File deliveryFolder) throws Exception {
        if (confFile == null) {
            throw new Exception("The substitution mode needs a configuration file. Use the -confFile parameter.");
        }
        Properties props = new Properties();
        try {
            props = DeliveryBuilder.readDeliveryConf((InputStream)new BufferedInputStream(new FileInputStream(confFile)), (String)"UTF-8");
        }
        catch (Exception ex) {
            throw new Exception("Failed to load configuration file " + confFile);
        }
        HashMap<String, String> confProperties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            confProperties.put(((String)entry.getKey()).replace("/", "/@"), (String)entry.getValue());
        }
        Logger.getLogger(DeliveryShellCommand.class.getName()).fine(() -> "Substitution for package " + packageFile + " with configuration values " + confFile);
        PakageInfo packageInfo = this.analyzePackage(packageFile);
        if (this.processName != null && packageInfo.propertiesPerDeliv.get(this.processName) == null) {
            throw new Exception("The package " + packageFile + " does not contain delivery named " + this.processName);
        }
        if (this.moduleFolder != null) {
            this.checkModules(packageInfo, this.processName);
        }
        deliveryFolder.mkdirs();
        for (String s : packageInfo.propertiesPerDeliv.keySet()) {
            if (this.processName != null && !s.equals(this.processName)) continue;
            String delivConf = packageInfo.propertiesPerDeliv.get(s).getProperty("conf");
            HashMap<String, HashMap<String, String>> map = new HashMap<String, HashMap<String, String>>();
            map.put(delivConf, confProperties);
            Logger.getLogger(DeliveryShellCommand.class.getName()).fine("delivery " + s);
            DeliveryBuilder db = new DeliveryBuilder(UUID.randomUUID().toString(), System.getProperty("user.name"), null, null, map, Collections.singletonList(delivConf));
            OutputStream fos = null;
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            File deliv = null;
            boolean delete = false;
            try {
                try {
                    deliv = new File(deliveryFolder, String.valueOf(s) + ".deliv");
                    fos = new BufferedOutputStream(new FileOutputStream(deliv));
                    db.build(packageFile, fos, s);
                }
                catch (Exception ex) {
                    delete = true;
                    throw ex;
                }
                catch (Throwable ex) {
                    delete = true;
                    throw new Exception(ex.getMessage(), ex);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(ccl);
                if (fos != null) {
                    fos.close();
                }
                if (delete) {
                    deliv.delete();
                }
            }
        }
        return Status.OK_STATUS;
    }

    private PakageInfo analyzePackage(File packageFile) throws Exception {
        PakageInfo info = new PakageInfo();
        try (ZipFile zip = null;){
            zip = new ZipFile(packageFile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                if (ze.isDirectory()) continue;
                if (!ze.getName().contains("/") && ze.getName().endsWith(".properties")) {
                    String name = ze.getName().substring(0, ze.getName().length() - 11);
                    try {
                        Throwable throwable = null;
                        Object var8_11 = null;
                        try (InputStream is = zip.getInputStream(ze);){
                            Properties p = new Properties();
                            p.load(is);
                            info.propertiesPerDeliv.put(name, p);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception ex) {
                        throw new Exception("Failed to read entry " + ze.getName() + " from package", ex);
                    }
                }
                if (!ze.getName().endsWith("___internal___/manifest.xml")) continue;
                InputStream zis = zip.getInputStream(ze);
                try {
                    info.manifest = ManifestMarshallingHelper.unmarshal((InputStream)zis);
                }
                catch (Exception ex) {
                    throw new Exception(Messages.DeliveryShellCommand_6, ex);
                }
            }
        }
        return info;
    }

    private IStatus generateDelivery(File packageFile, File confFile, File delivFolder, PrintStream out, PrintStream err) throws Exception {
        PakageInfo packageInfo = this.analyzePackage(packageFile);
        HashMap options = new HashMap();
        if (this.processName != null) {
            if (this.moduleFolder != null) {
                this.checkModules(packageInfo, this.processName);
            }
            ExecuteAnt ant = new ExecuteAnt(null);
            if (confFile != null) {
                ant.addProperty("conf.file", this.configurationFilePath);
            }
            ant.addProperty("package.name", packageFile.getName());
            ant.addProperty("package.dir", packageFile.getParentFile().getAbsolutePath());
            if (delivFolder != null) {
                delivFolder.mkdirs();
                ant.addProperty("deliv.dir", delivFolder.getAbsolutePath());
            }
            ant.addProperty("in.name", this.processName);
            ant.addProperty("deliv.name", String.valueOf(this.processName) + ".deliv");
            Properties p = packageInfo.propertiesPerDeliv.get(this.processName);
            for (Object o : p.keySet()) {
                ant.addProperty((String)o, p.getProperty((String)o));
            }
            return ant.run("package.delivery", IGenerationService.EnvironmentInitializer.of(options, null), this.debug ? LoggingConfigurationHelper.createLoggingConfiguration(this.loggingConfigurationFactory, out, err) : null);
        }
        MultiStatus ms = new MultiStatus("com.indy.ui.build", 0, "", null);
        if (this.moduleFolder != null) {
            for (String processName : packageInfo.propertiesPerDeliv.keySet()) {
                this.checkModules(packageInfo, processName);
            }
        }
        for (String processName : packageInfo.propertiesPerDeliv.keySet()) {
            ExecuteAnt ant = new ExecuteAnt(null);
            if (confFile != null) {
                ant.addProperty("conf.file", this.configurationFilePath);
            }
            ant.addProperty("package.name", packageFile.getName());
            ant.addProperty("package.dir", packageFile.getParentFile().getAbsolutePath());
            if (delivFolder != null) {
                delivFolder.mkdirs();
                ant.addProperty("deliv.dir", delivFolder.getAbsolutePath());
            }
            Properties p = packageInfo.propertiesPerDeliv.get(processName);
            ant.addProperty("in.name", processName);
            ant.addProperty("deliv.name", String.valueOf(processName) + ".deliv");
            for (Object o : p.keySet()) {
                ant.addProperty((String)o, p.getProperty((String)o));
            }
            IStatus res = ant.run("package.delivery", IGenerationService.EnvironmentInitializer.of(options, null), this.debug ? LoggingConfigurationHelper.createLoggingConfiguration(this.loggingConfigurationFactory, out, err) : null);
            ms.add(res);
        }
        return ms;
    }

    private void checkModules(PakageInfo packageInfo, String processName) throws Exception {
        if (!this.moduleFolder.exists() || this.moduleFolder.isFile()) {
            throw new Exception(String.format(Messages.DeliveryShellCommand_7, this.moduleFolder.getAbsolutePath()));
        }
        if (packageInfo.manifest != null) {
            for (PackageManifest.MainProcess p : packageInfo.manifest.getDeliveriesProcesses()) {
                if (processName != null && !p.getName().equals(processName)) continue;
                for (PackageManifest.ModuleRequirment req : p.getRequiredModules()) {
                    ModuleServiceImpl.ModuleDescriptor desc;
                    File f = new File(this.moduleFolder, req.getModuleName());
                    if (!f.exists() || !f.isDirectory()) {
                        throw new Exception(String.format(Messages.DeliveryShellCommand_8, req.getModuleName(), this.moduleFolder.getAbsolutePath()));
                    }
                    if (req.getBaseModuleId() == null || (desc = new ModuleServiceImpl.ModuleDescriptor(req.getModuleName(), new File(f, "module_descriptor.properties"))).getBaseModuleInfo().getId().equals(req.getBaseModuleId())) continue;
                    throw new Exception(String.format(Messages.DeliveryShellCommand_9, req.getModuleName(), desc.getBaseModuleInfo().getId(), req.getBaseModuleId()));
                }
            }
        }
    }

    public void buildDelivery(String ... params) {
        this.buildMode = null;
        this.configurationFilePath = null;
        this.debug = false;
        this.deliveryFolder = null;
        StringBuilder b = new StringBuilder();
        b.append(String.valueOf(this.getName()) + " ");
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("-")) {
                b.append(String.valueOf(s) + " ");
            } else {
                b.append("\"" + s + "\" ");
            }
            ++n2;
        }
        this.execute(b.toString(), System.out, System.err);
    }

    public static enum Mode {
        generation,
        substitution;

    }

    private class PakageInfo {
        HashMap<String, Properties> propertiesPerDeliv = new HashMap();
        PackageManifest manifest;

        private PakageInfo() {
        }
    }
}

