/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.cli;

import com.indy.shell.parser.CommandAnalyzer;
import com.indy.shell.parser.ShellCommand;
import com.indy.shell.parser.ShellCommandParameter;
import com.semarchy.xdi.designer.core.services.IGenerationService;
import com.semarchy.xdi.designer.generation.AntLaunchHelper;
import com.semarchy.xdi.designer.generation.ExecuteAnt;
import com.semarchy.xdi.designer.generation.cli.Messages;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.felix.shell.Command;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.osgi.service.component.annotations.Component;

@ShellCommand
@Component(property={"osgi.command.scope=stambia", "osgi.command.function=launch"}, service={Command.class}, enabled=true)
public class LaunchShellCommand
implements Command {
    @ShellCommandParameter(position=0)
    private String launchConfigurationName;

    public void execute(String line, PrintStream out, PrintStream err) {
        this.launchConfigurationName = null;
        PrintWriter writer = new PrintWriter(out);
        try {
            this.parseLine(line.trim().substring(this.getName().length() + 1));
        }
        catch (Exception ex) {
            ex.printStackTrace(err);
            writer.println(String.valueOf(Messages.LaunchShellCommand_0) + ex.getMessage());
            return;
        }
        try {
            try {
                IStatus res = this.perform();
                if (res.isOK()) {
                    writer.println(String.valueOf(Messages.LaunchShellCommand_1) + this.launchConfigurationName);
                } else {
                    writer.println(String.valueOf(Messages.LaunchShellCommand_2) + res.getMessage());
                    if (res.getException() != null) {
                        res.getException().printStackTrace(err);
                    }
                }
            }
            catch (Exception ex) {
                writer.println(String.valueOf(Messages.LaunchShellCommand_3) + ex.getMessage());
                writer.flush();
                ex.printStackTrace(err);
                err.flush();
                writer.flush();
            }
        }
        finally {
            writer.flush();
        }
    }

    private void parseLine(String line) throws Exception {
        CommandAnalyzer helper = new CommandAnalyzer();
        helper.prepare((Object)this, line);
    }

    public String getName() {
        return "launch";
    }

    public String getShortDescription() {
        return Messages.LaunchShellCommand_5;
    }

    public String getUsage() {
        return "launch <launchConfigurationName>";
    }

    private IStatus perform() throws Exception {
        if (this.launchConfigurationName == null) {
            throw new Exception(Messages.LaunchShellCommand_7);
        }
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.indy.ui.build.launchers.launchConfigurationType.package");
        ILaunchConfiguration[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
        if (launches == null) {
            throw new Exception(Messages.LaunchShellCommand_9);
        }
        ILaunchConfiguration launch = null;
        ILaunchConfiguration[] iLaunchConfigurationArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration l = iLaunchConfigurationArray[n2];
            if (l.getName().equals(this.launchConfigurationName)) {
                launch = l;
                break;
            }
            ++n2;
        }
        if (launch == null) {
            throw new Exception(String.valueOf(Messages.LaunchShellCommand_10) + this.launchConfigurationName);
        }
        ExecuteAnt ant = new ExecuteAnt(null);
        Map<String, String> antOptions = AntLaunchHelper.createAntTaskOptions(launch);
        return ant.run("package.multiProc", IGenerationService.EnvironmentInitializer.of(antOptions, null), null);
    }

    public void launch(String ... params) {
        StringBuilder b = new StringBuilder();
        b.append(String.valueOf(this.getName()) + " ");
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("-")) {
                b.append(String.valueOf(s) + " ");
            } else {
                b.append("\"" + s + "\" ");
            }
            ++n2;
        }
        this.execute(b.toString(), System.out, System.err);
    }
}

