/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.cli;

import com.indy.shell.parser.CommandAnalyzer;
import com.indy.shell.parser.ShellCommand;
import com.indy.shell.parser.ShellCommandParameter;
import com.semarchy.xdi.designer.generation.cli.PathResolver;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.felix.shell.Command;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;

@ShellCommand
@Component(property={"osgi.command.scope=stb", "osgi.command.function=validateConfFile"}, service={Command.class}, enabled=true)
public class PackageConfigurationValidationShellCommand
implements Command {
    @ShellCommandParameter(commutator="package")
    private String packagePath;
    @ShellCommandParameter(commutator="confFile")
    private String configurationFilePath;
    @ShellCommandParameter(commutator="missingConfFile")
    private String missingConfigurationFilePath;
    @ShellCommandParameter(commutator="missingConfBehaviour")
    private Mode mode;

    private void parseLine(String line) throws Exception {
        CommandAnalyzer helper = new CommandAnalyzer();
        helper.prepare((Object)this, line);
    }

    public void execute(String line, PrintStream out, PrintStream err) {
        this.packagePath = null;
        this.configurationFilePath = null;
        this.missingConfigurationFilePath = null;
        this.mode = Mode.OVERWRITE;
        PrintWriter writer = new PrintWriter(out);
        try {
            this.parseLine(line.trim().substring(this.getName().length() + 1));
        }
        catch (Exception ex) {
            ex.printStackTrace(err);
            writer.println("ERROR - Command Parsing - " + ex.getMessage());
            return;
        }
        this.packagePath = PathResolver.resolveFileSystemPath(this.packagePath);
        this.configurationFilePath = PathResolver.resolveFileSystemPath(this.configurationFilePath);
        this.missingConfigurationFilePath = PathResolver.resolveFileSystemPath(this.missingConfigurationFilePath);
        try {
            try {
                IStatus res = this.perform();
                if (res.isOK()) {
                    writer.println("SUCCESS - validateConfFile on " + this.packagePath);
                } else {
                    writer.println("ERROR - validateConfFile on " + this.packagePath + " :" + res.getMessage());
                    if (res.getException() != null) {
                        res.getException().printStackTrace(err);
                    }
                }
            }
            catch (Exception ex) {
                writer.println("ERROR - Initialization - " + ex.getMessage());
                writer.flush();
                ex.printStackTrace(err);
                err.flush();
                if (writer != null) {
                    writer.flush();
                }
            }
        }
        finally {
            if (writer != null) {
                writer.flush();
            }
        }
    }

    private IStatus perform() throws Exception {
        if (this.packagePath == null) {
            throw new Exception("Missing argument -package");
        }
        File packageFile = new File(this.packagePath);
        if (!packageFile.exists() || packageFile.isDirectory()) {
            throw new Exception("The package file " + this.packagePath + " does not exist");
        }
        if (this.configurationFilePath == null) {
            throw new Exception("Missing argument -confFile");
        }
        File confFile = new File(this.configurationFilePath);
        if (!confFile.exists() || confFile.isDirectory()) {
            throw new Exception("The configuration file " + confFile + " does not exist");
        }
        File missingConfigurationFile = null;
        if (this.missingConfigurationFilePath != null) {
            missingConfigurationFile = new File(this.missingConfigurationFilePath);
        }
        Map<String, String> packageConfiguration = null;
        try {
            ZipInputStream zis = null;
            try {
                zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(packageFile)));
                ZipEntry ze = null;
                while ((ze = zis.getNextEntry()) != null) {
                    try {
                        String fileName;
                        if (ze.isDirectory() || !(fileName = ze.getName()).endsWith(".conf")) continue;
                        packageConfiguration = this.parseConfiguration(zis, true);
                        break;
                    }
                    finally {
                        if (packageConfiguration == null) {
                            zis.closeEntry();
                        }
                    }
                }
            }
            finally {
                if (zis != null) {
                    try {
                        zis.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("Unable to read package", ex);
        }
        Map<String, String> providedConf = this.parseConfiguration(new BufferedInputStream(new FileInputStream(confFile)), false);
        HashMap<String, String> missingKeys = new HashMap<String, String>(packageConfiguration);
        missingKeys.keySet().removeAll(providedConf.keySet());
        if (missingKeys.size() > 0) {
            if (missingConfigurationFile != null) {
                missingConfigurationFile.getParentFile().mkdirs();
                Map<String, String> toSave = null;
                switch (this.mode) {
                    case MERGE: {
                        if (missingConfigurationFile != null && missingConfigurationFile.exists()) {
                            toSave = this.parseConfiguration(new BufferedInputStream(new FileInputStream(missingConfigurationFile)), false);
                            missingKeys.keySet().removeAll(toSave.keySet());
                        }
                        toSave = missingKeys;
                        break;
                    }
                    case OVERWRITE: {
                        toSave = missingKeys;
                    }
                }
                this.saveProperties(toSave, missingConfigurationFile);
                return new Status(4, "com.indy.ui.build", "The configuration file " + this.configurationFilePath + " does not contain the keys generated in " + this.missingConfigurationFilePath);
            }
            StringBuffer b = new StringBuffer();
            for (String s : missingKeys.keySet()) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(s);
            }
            return new Status(4, "com.indy.ui.build", "The configuration file " + this.configurationFilePath + " does not contain the following keys :" + b.toString());
        }
        return Status.OK_STATUS;
    }

    private void saveProperties(Map<String, String> toSave, File missingConfigurationFile) throws Exception {
        BufferedWriter pw = null;
        try {
            try {
                pw = new BufferedWriter(new PrintWriter(new FileWriter(missingConfigurationFile, this.mode == Mode.MERGE)));
                if (this.mode == Mode.MERGE && missingConfigurationFile.getTotalSpace() > 0L) {
                    pw.newLine();
                }
                for (String s : toSave.keySet()) {
                    pw.write(String.valueOf(s) + "=" + toSave.get(s) + System.getProperty("line.separator"));
                }
            }
            catch (Exception ex) {
                throw new Exception("Failed to write missing properties file " + missingConfigurationFile, ex);
            }
        }
        finally {
            try {
                pw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Map<String, String> parseConfiguration(InputStream is, boolean uncomment) throws Exception {
        HashMap<String, String> cc = new HashMap<String, String>();
        try (BufferedReader reder = null;){
            reder = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reder.readLine()) != null) {
                if (!line.contains("=")) continue;
                if (uncomment) {
                    while (line.startsWith("#")) {
                        line = line.substring(1);
                    }
                }
                if (line.startsWith("#")) continue;
                String[] p = line.split("=");
                cc.put(p[0], p.length < 2 ? "" : p[1]);
            }
        }
        return cc;
    }

    public String getName() {
        return "validateConfFile";
    }

    public String getShortDescription() {
        return "validate the given configuration against a package(ie. check all externalized values in the package are provided)";
    }

    public String getUsage() {
        return "validateConfFile -package <packageFilePath> -confFile <configurationFilePath> [-missingConfFile <missingCnfigurationFilePath>]";
    }

    public void validateConfFile(String ... params) {
        StringBuilder b = new StringBuilder();
        b.append(String.valueOf(this.getName()) + " ");
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("-")) {
                b.append(String.valueOf(s) + " ");
            } else {
                b.append("\"" + s + "\" ");
            }
            ++n2;
        }
        this.execute(b.toString(), System.out, System.err);
    }

    public static enum Mode {
        MERGE,
        OVERWRITE;

    }
}

