/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.cli;

import com.indy.ant.ManifestMarshallingHelper;
import com.indy.ant.PackageManifest;
import com.indy.shell.parser.CommandAnalyzer;
import com.indy.shell.parser.ShellCommand;
import com.indy.shell.parser.ShellCommandParameter;
import com.semarchy.xdi.designer.generation.cli.PathResolver;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.felix.shell.Command;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;

@ShellCommand
@Component(property={"osgi.command.scope=stb", "osgi.command.function=extractPackageInfo"}, service={Command.class}, enabled=true)
public class PackageInfoShellCommand
implements Command {
    @ShellCommandParameter(commutator="extract")
    private String typeExtraction;
    @ShellCommandParameter(commutator="package")
    private String packageFilePath;
    @ShellCommandParameter(commutator="outputFile")
    private String reportFile;
    @ShellCommandParameter(commutator="append")
    private Boolean append;

    public void execute(String line, PrintStream out, PrintStream err) {
        block21: {
            this.typeExtraction = null;
            this.packageFilePath = null;
            this.reportFile = null;
            this.append = false;
            PrintWriter writer = new PrintWriter(out);
            try {
                this.parseLine(line.trim().substring(this.getName().length() + 1));
            }
            catch (Exception ex) {
                ex.printStackTrace(err);
                writer.println("ERROR - Command Parsing - " + ex.getMessage());
                return;
            }
            this.packageFilePath = PathResolver.resolveFileSystemPath(this.packageFilePath);
            this.reportFile = PathResolver.resolveFileSystemPath(this.reportFile);
            FilterOutputStream os = null;
            try {
                try {
                    os = this.reportFile != null && !Type.documentation.name().equals(this.typeExtraction) ? new BufferedOutputStream(new FileOutputStream(this.reportFile, (boolean)this.append)) : out;
                    IStatus res = this.perform(os);
                    ((OutputStream)os).flush();
                    writer.println();
                    if (res.isOK()) {
                        if (this.reportFile != null) {
                            writer.println("SUCCESS - Information generated in" + this.reportFile);
                        } else {
                            writer.println("SUCCESS - " + res.getMessage());
                        }
                    } else {
                        writer.println("ERROR - Checksum - " + res.getMessage());
                        if (res.getException() != null) {
                            res.getException().printStackTrace(err);
                        }
                    }
                }
                catch (Exception ex) {
                    writer.println("ERROR - Initialization - " + ex.getMessage());
                    writer.flush();
                    ex.printStackTrace(err);
                    err.flush();
                    if (writer != null) {
                        writer.flush();
                    }
                    if (this.reportFile == null || Type.documentation.name().equals(this.typeExtraction)) break block21;
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (writer != null) {
                    writer.flush();
                }
                if (this.reportFile != null && !Type.documentation.name().equals(this.typeExtraction)) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public String getName() {
        return "extractPackageInfo";
    }

    public String getShortDescription() {
        return "Generate a checksum for all the sources included in a package";
    }

    public String getUsage() {
        return "extractPackageInfo -package <packageFilePath>  -extract [sourceList|mainProcessList|manifest|date|user|packageId|processNames|conf|documentation] [-outputFile <reportFile>]";
    }

    private void parseLine(String line) throws Exception {
        CommandAnalyzer helper = new CommandAnalyzer();
        helper.prepare((Object)this, line);
    }

    private IStatus perform(OutputStream out) throws Exception {
        ClassLoader ccl;
        if (this.typeExtraction == null) {
            throw new Exception("Missing argument -extract");
        }
        Type type = Type.valueOf(this.typeExtraction);
        if (type == null) {
            throw new Exception(String.valueOf(this.typeExtraction) + "not a valid type. Allowed values " + Type.values());
        }
        if (type == Type.documentation && this.reportFile == null) {
            throw new Exception("The parameter outputFile must be specified to extract documentation");
        }
        File packageFile = new File(this.packageFilePath);
        if (!packageFile.exists()) {
            throw new Exception("The package " + this.packageFilePath + " does not exists.");
        }
        if (!packageFile.isFile()) {
            throw new Exception(String.valueOf(this.packageFilePath) + " is not a file.");
        }
        Path srcPath = new Path("___internal___/__src/");
        class TmpInfo {
            IPath srcPath;
            String checkSum;
            String modelId;

            TmpInfo(IPath srcPath, byte[] digest) {
                this.srcPath = srcPath.makeAbsolute();
                this.checkSum = this.formatChecksum(digest);
            }

            TmpInfo(IPath srcPath, String checkSum) {
                this.srcPath = srcPath;
                this.checkSum = checkSum;
            }

            private String formatChecksum(byte[] digest) {
                String result = "";
                int i = 0;
                while (i < digest.length) {
                    result = String.valueOf(result) + Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1);
                    ++i;
                }
                return result;
            }
        }
        ArrayList<TmpInfo> tmpRes = new ArrayList<TmpInfo>();
        PackageManifest mf = null;
        File tmpManifestFile = File.createTempFile("stambiaDesigner", "manifest");
        boolean containSrc = false;
        boolean docFound = false;
        try {
            byte[] buffer = new byte[1024];
            ZipInputStream zis = null;
            try {
                zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.packageFilePath)));
                MessageDigest digest = MessageDigest.getInstance("MD5");
                ZipEntry ze = null;
                while ((ze = zis.getNextEntry()) != null) {
                    try {
                        String fName22;
                        int len;
                        if (ze.isDirectory()) continue;
                        String fileName = ze.getName();
                        if (type == Type.sourceList && fileName.startsWith("___internal___/__src/")) {
                            containSrc = true;
                            digest.reset();
                            while ((len = zis.read(buffer)) > 0) {
                                digest.update(buffer, 0, len);
                            }
                            tmpRes.add(new TmpInfo(new Path(fileName).makeRelativeTo((IPath)srcPath), digest.digest()));
                        }
                        if (type == Type.documentation && fileName.startsWith("___internal___/doc")) {
                            docFound = true;
                            File folder = new File(this.reportFile);
                            if (folder.exists() && !folder.isDirectory()) {
                                throw new Exception("The outputFile " + folder.getAbsolutePath() + " is a file.");
                            }
                            fName22 = fileName.substring("___internal___/doc/html".length());
                            File f = new File(folder, fName22);
                            f.getParentFile().mkdirs();
                            try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(f));){
                                try {
                                    int len2;
                                    while ((len2 = zis.read(buffer)) > 0) {
                                        ((OutputStream)fos).write(buffer, 0, len2);
                                    }
                                }
                                catch (Exception ex) {
                                    throw new Exception("Failed do unzip documentation file " + fileName + " into " + f.getAbsolutePath());
                                }
                            }
                        }
                        if (type == Type.conf && fileName.endsWith(".conf")) {
                            while ((len = zis.read(buffer)) > 0) {
                                out.write(buffer, 0, len);
                            }
                            Status status = new Status(0, "com.indy.ui.build", "configuration file extracted");
                            return status;
                        }
                        if (!fileName.equals("___internal___/manifest.xml")) continue;
                        Throwable len3 = null;
                        fName22 = null;
                        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(tmpManifestFile));){
                            int len4;
                            while ((len4 = zis.read(buffer)) > 0) {
                                ((OutputStream)fos).write(buffer, 0, len4);
                            }
                        }
                        catch (Throwable fName22) {
                            if (len3 == null) {
                                len3 = fName22;
                            } else if (len3 != fName22) {
                                len3.addSuppressed(fName22);
                            }
                            throw len3;
                        }
                    }
                    finally {
                        zis.closeEntry();
                    }
                }
            }
            finally {
                if (zis != null) {
                    try {
                        zis.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            ccl = Thread.currentThread().getContextClassLoader();
            Object fis = null;
            try {
                fis = new FileInputStream(tmpManifestFile);
                mf = ManifestMarshallingHelper.unmarshal((InputStream)new BufferedInputStream((InputStream)fis));
            }
            finally {
                if (fis != null) {
                    try {
                        ((InputStream)fis).close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                Thread.currentThread().setContextClassLoader(ccl);
            }
            if (type == Type.documentation && !mf.isContainsDocumentation()) {
                throw new Exception("The package " + packageFile.getAbsolutePath() + " does not contains documentation.");
            }
            if (!containSrc) {
                for (PackageManifest.SourceEntry e : mf.getSources()) {
                    TmpInfo i = new TmpInfo((IPath)new Path(e.getPath()), e.getSourceChecksum());
                    i.modelId = e.getSourceId();
                    tmpRes.add(i);
                }
            } else {
                for (TmpInfo i : tmpRes) {
                    PackageManifest.SourceEntry e = mf.findSource(i.srcPath.toString());
                    if (e == null) {
                        throw new Exception("The source " + i.srcPath + " does not belong to the manifest. Something is wrong in the package.");
                    }
                    i.modelId = e.getSourceId();
                    if (e.getSourceChecksum().equals(i.checkSum)) continue;
                    throw new Exception("The checksum for source.id=" + i.modelId + " does not match the computed one. [" + i.checkSum + "]");
                }
            }
        }
        finally {
            tmpManifestFile.delete();
        }
        Object sw = null;
        BufferedWriter bos = null;
        if (out != null) {
            bos = new BufferedWriter(new OutputStreamWriter(out));
        }
        try {
            switch (type) {
                case sourceList: {
                    Collections.sort(tmpRes, new Comparator<TmpInfo>(){

                        @Override
                        public int compare(TmpInfo o1, TmpInfo o2) {
                            return o1.modelId.compareTo(o2.modelId);
                        }
                    });
                    bos.write("ModelId;Checksum;ModelPath;\n");
                    for (TmpInfo i : tmpRes) {
                        bos.write(i.modelId);
                        bos.write(";");
                        bos.write(i.checkSum);
                        bos.write(";");
                        bos.write(i.srcPath.toString());
                        bos.write(";\n");
                    }
                    break;
                }
                case date: {
                    bos.write(mf.getGenerationDate().toString());
                    break;
                }
                case manifest: {
                    ccl = Thread.currentThread().getContextClassLoader();
                    try {
                        ManifestMarshallingHelper.marshal((PackageManifest)mf, (Writer)bos);
                        break;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(ccl);
                    }
                }
                case packageId: {
                    bos.write(mf.getPackageId());
                    break;
                }
                case user: {
                    bos.write(mf.getUser());
                    break;
                }
                case conf: {
                    break;
                }
                case mainProcessList: {
                    List l = mf.getDeliveriesProcesses();
                    Collections.sort(l, new Comparator<PackageManifest.MainProcess>(){

                        @Override
                        public int compare(PackageManifest.MainProcess o1, PackageManifest.MainProcess o2) {
                            return o1.getProcessId().compareTo(o2.getProcessId());
                        }
                    });
                    for (PackageManifest.MainProcess m : l) {
                        bos.write(m.getName());
                        bos.write(";");
                    }
                    break;
                }
            }
        }
        finally {
            if (bos != null) {
                bos.flush();
                if (this.reportFile != null) {
                    bos.close();
                }
            }
        }
        return new Status(0, "com.indy.ui.build", "informations extracted");
    }

    public void extractPackageInfo(String ... params) {
        StringBuilder b = new StringBuilder();
        b.append(String.valueOf(this.getName()) + " ");
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("-")) {
                b.append(String.valueOf(s) + " ");
            } else {
                b.append("\"" + s + "\" ");
            }
            ++n2;
        }
        this.execute(b.toString(), System.out, System.err);
    }

    private static enum Type {
        sourceList,
        mainProcessList,
        manifest,
        date,
        user,
        packageId,
        conf,
        documentation;

    }
}

