/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.cli;

import com.indy.shell.parser.CommandAnalyzer;
import com.indy.shell.parser.ShellCommand;
import com.indy.shell.parser.ShellCommandParameter;
import com.semarchy.xdi.designer.core.services.IEvaluationConfigurationService;
import com.semarchy.xdi.designer.core.services.IGenerationService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.generation.ExecuteAnt;
import com.semarchy.xdi.designer.generation.cli.PathResolver;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.apache.felix.shell.Command;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;

@ShellCommand
@Component(property={"osgi.command.scope=stb", "osgi.command.function=buildPackage"}, service={Command.class}, enabled=true)
public class PackageShellCommand
implements Command {
    private String antActionType;
    @ShellCommandParameter(commutator="package")
    private String packageOutputPath;
    @ShellCommandParameter(commutator="mainProcessWorkspacePath")
    private String mainProcessWorkspacePath;
    @ShellCommandParameter(commutator="conf")
    private String confName;
    @ShellCommandParameter(commutator="includeSources")
    private Boolean includeSources = null;
    @ShellCommandParameter(commutator="includeDocumentation")
    private Boolean includeDocumentation = null;

    public void execute(String line, PrintStream out, PrintStream err) {
        this.antActionType = null;
        this.packageOutputPath = null;
        this.confName = "default";
        this.includeSources = null;
        this.mainProcessWorkspacePath = null;
        this.includeDocumentation = null;
        PrintWriter writer = new PrintWriter(out);
        try {
            this.parseLine(line.trim().substring(this.getName().length() + 1));
        }
        catch (Exception ex) {
            ex.printStackTrace(err);
            writer.println("\nERROR - Command Parsing - " + ex.getMessage());
            writer.flush();
            return;
        }
        this.packageOutputPath = PathResolver.resolveFileSystemPath(this.packageOutputPath);
        try {
            try {
                IStatus res = this.perform();
                if (res.isOK()) {
                    writer.println("SUCCESS - BuildPackage " + this.packageOutputPath);
                } else {
                    writer.println("ERROR - Generation - " + res.getMessage());
                    if (res.getException() != null) {
                        res.getException().printStackTrace(err);
                    }
                }
            }
            catch (Exception ex) {
                writer.println("ERROR - Initialization - " + ex.getMessage());
                writer.flush();
                ex.printStackTrace(err);
                err.flush();
                writer.flush();
            }
        }
        finally {
            writer.flush();
        }
    }

    private IStatus perform() throws Exception {
        if (this.mainProcessWorkspacePath == null) {
            throw new Exception("Missing mainProcessWorkspacePath argument");
        }
        StringBuilder pathList = new StringBuilder();
        HashSet<String> fileNames = new HashSet<String>();
        String defaultDelivName = null;
        String[] stringArray = this.mainProcessWorkspacePath.split("\\|");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            PathResolver.WkspPathLocation srcLocation = PathResolver.resolveWorkspaceRelativePath(s);
            pathList.append(srcLocation.getSourceFile().toURL().getFile());
            pathList.append("|");
            pathList.append(srcLocation.getPath().toString());
            pathList.append(";");
            String fileName = srcLocation.getSourceFile().getName();
            if (fileName.contains(".")) {
                fileName = fileName.substring(0, fileName.lastIndexOf("."));
            }
            if (!fileNames.add(fileName)) {
                throw new CoreException((IStatus)new Status(4, "com.indy.ui.build.launchers", "Multiple processes with the name " + fileName + ". A Package does not support having multiples process with the same name."));
            }
            if (defaultDelivName == null) {
                defaultDelivName = fileName;
            }
            ++n2;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("package.multiProc.paths", pathList.toString());
        if (this.packageOutputPath != null) {
            if (!this.packageOutputPath.endsWith("pck")) {
                this.packageOutputPath = String.valueOf(this.packageOutputPath) + ".pck";
            }
            File outputFile = new File(this.packageOutputPath);
            outputFile.getParentFile().mkdirs();
            options.put("com.indy.launchers.configurations.packageOutputFolder", outputFile.getParentFile().getAbsolutePath());
            options.put("com.indy.launchers.configurations.packageOutputName", outputFile.getName());
            String c = outputFile.getName();
            if (c.endsWith(".pck")) {
                c = c.substring(0, c.lastIndexOf("."));
            }
            options.put("com.indy.launchers.configurations.packageOutputConfName", c);
        } else {
            options.put("com.indy.launchers.configurations.packageOutputName", String.valueOf(defaultDelivName) + ".pck");
            options.put("com.indy.launchers.configurations.packageOutputConfName", defaultDelivName);
        }
        options.put("package.multiProc.paths", pathList.toString());
        options.put("package.multiProc.packageId", UUID.randomUUID().toString());
        if (this.includeSources == Boolean.TRUE) {
            options.put("package.includeSources", "true");
        } else {
            options.put("package.includeSources", "false");
        }
        this.antActionType = "package.multiProc";
        if (this.includeDocumentation == Boolean.TRUE) {
            options.put("package.multiProc.generateDocumentation", "true");
        }
        IEvaluationConfigurationService evalService = (IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class);
        String previousConfName = evalService.getCurrentConfigurationName();
        try {
            if (this.confName != null && !this.confName.isEmpty()) {
                evalService.setCurrentConfigurationName(this.confName, false);
            }
            ExecuteAnt ant = new ExecuteAnt(null);
            IStatus iStatus = ant.run(this.antActionType, IGenerationService.EnvironmentInitializer.of(options, null), null);
            return iStatus;
        }
        finally {
            evalService.setCurrentConfigurationName(previousConfName, false);
        }
    }

    public String getName() {
        return "buildPackage";
    }

    public String getShortDescription() {
        return "build a Package from one or multiple processes";
    }

    public String getUsage() {
        return "buildPackage -mainProcessWorkspacePath <sourceFilePathInWksp1|...> [-package <outputPackageFilePath>] [-conf <confName>] [-includeSources <true|false>] [-includeDocumentation <true|false>]";
    }

    public void buildPackage(String ... params) {
        StringBuilder b = new StringBuilder();
        b.append(String.valueOf(this.getName()) + " ");
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("-")) {
                b.append(String.valueOf(s) + " ");
            } else {
                b.append("\"" + s + "\" ");
            }
            ++n2;
        }
        this.execute(b.toString(), System.out, System.err);
    }

    private void parseLine(String line) throws Exception {
        CommandAnalyzer helper = new CommandAnalyzer();
        helper.prepare((Object)this, line);
    }
}

