/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.cli;

import com.indy.ant.ManifestMarshallingHelper;
import com.indy.ant.PackageManifest;
import com.indy.shell.parser.CommandAnalyzer;
import com.indy.shell.parser.ShellCommand;
import com.indy.shell.parser.ShellCommandParameter;
import com.semarchy.xdi.designer.generation.cli.PathResolver;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.felix.shell.Command;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;

@ShellCommand
@Component(property={"osgi.command.scope=stb", "osgi.command.function=validatePackageSource"}, service={Command.class}, enabled=true)
public class PackageValidationShellCommand
implements Command {
    @ShellCommandParameter(commutator="package")
    private String packagePath;
    @ShellCommandParameter(commutator="md5Rule")
    private String md5Rule;

    private void parseLine(String line) throws Exception {
        CommandAnalyzer helper = new CommandAnalyzer();
        helper.prepare((Object)this, line);
    }

    public void execute(String line, PrintStream out, PrintStream err) {
        this.packagePath = null;
        this.md5Rule = null;
        PrintWriter writer = new PrintWriter(out);
        try {
            this.parseLine(line.trim().substring(this.getName().length() + 1));
        }
        catch (Exception ex) {
            ex.printStackTrace(err);
            writer.println("ERROR - Command Parsing - " + ex.getMessage());
            return;
        }
        this.packagePath = PathResolver.resolveFileSystemPath(this.packagePath);
        try {
            try {
                IStatus res = this.perform();
                if (res.isOK()) {
                    writer.println("SUCCESS - validatePackageSource on " + this.packagePath);
                } else {
                    StringBuffer b = new StringBuffer();
                    IStatus[] iStatusArray = ((MultiStatus)res).getChildren();
                    int n = iStatusArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStatus s = iStatusArray[n2];
                        b.append(s.getMessage());
                        b.append(",");
                        ++n2;
                    }
                    writer.println("ERROR - validatePackageSource on " + this.packagePath + " failed for models :" + b.toString());
                    if (res.getException() != null) {
                        res.getException().printStackTrace(err);
                    }
                }
            }
            catch (Exception ex) {
                writer.println("ERROR - Initialization - " + ex.getMessage());
                writer.flush();
                ex.printStackTrace(err);
                err.flush();
                if (writer != null) {
                    writer.flush();
                }
            }
        }
        finally {
            if (writer != null) {
                writer.flush();
            }
        }
    }

    private IStatus perform() throws Exception {
        PackageManifest mf;
        String[] rules;
        if (this.packagePath == null) {
            throw new Exception("Missing argument -package");
        }
        File packageFile = new File(this.packagePath);
        if (!packageFile.exists() || packageFile.isDirectory()) {
            throw new Exception("The package file " + this.packagePath + " does not exist");
        }
        if (this.packagePath == null) {
            throw new Exception("Missing argument -md5Rule");
        }
        HashMap<String, String> md5Rules = new HashMap<String, String>();
        HashSet<String> mandatoryFiles = new HashSet<String>();
        String[] stringArray = rules = this.md5Rule.split(";");
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            String r = stringArray[n2];
            String[] stringArray2 = r.split(":");
            if (stringArray2.length < 2 || stringArray2.length > 3) {
                throw new Exception("Invalid md5Rule " + r);
            }
            String old = md5Rules.put(stringArray2[0], stringArray2[1]);
            if (old != null) {
                throw new Exception("The md5Rule cannot define multiple values for the same modelId (" + stringArray2[0] + ")");
            }
            if (stringArray2.length > 2) {
                String mandatory = stringArray2[2];
                if (!mandatory.equals("true") || mandatory.equals("false")) {
                    throw new Exception("Wrong rule syntax on " + r + ". The mandatory value must be true or false.");
                }
                if (Boolean.valueOf(mandatory).booleanValue()) {
                    mandatoryFiles.add(stringArray2[0]);
                }
            }
            ++n2;
        }
        File tmpManifestFile = File.createTempFile("stambiaDesigner", "manifest");
        try {
            byte[] buffer = new byte[1024];
            ZipInputStream zis = null;
            try {
                ZipEntry zipEntry;
                zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(packageFile)));
                Object var9_13 = null;
                while ((zipEntry = zis.getNextEntry()) != null) {
                    try {
                        String fileName;
                        if (zipEntry.isDirectory() || !(fileName = zipEntry.getName()).equals("___internal___/manifest.xml")) continue;
                        try (OutputStream fos = null;){
                            int len;
                            fos = new BufferedOutputStream(new FileOutputStream(tmpManifestFile));
                            while ((len = zis.read(buffer)) > 0) {
                                fos.write(buffer, 0, len);
                            }
                        }
                    }
                    finally {
                        zis.closeEntry();
                    }
                }
            }
            finally {
                if (zis != null) {
                    try {
                        zis.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            InputStream fis = null;
            try {
                fis = new BufferedInputStream(new FileInputStream(tmpManifestFile));
                mf = ManifestMarshallingHelper.unmarshal((InputStream)fis);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                tmpManifestFile.delete();
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        catch (Exception ex) {
            throw new Exception("Unable to read package manifest", ex);
        }
        MultiStatus ms = new MultiStatus("com.indy.ui.build", 0, "", null);
        HashSet<String> entriesIds = new HashSet<String>();
        for (PackageManifest.SourceEntry sourceEntry : mf.getSources()) {
            entriesIds.add(sourceEntry.getSourceId());
            String md5 = (String)md5Rules.get(sourceEntry.getSourceId());
            if (md5 == null || md5.equals(sourceEntry.getSourceChecksum())) continue;
            ms.add((IStatus)new Status(4, "com.indy.ui.build", "Wrong MD5 checksum for " + sourceEntry.getSourceId()));
        }
        for (String string : mandatoryFiles) {
            if (entriesIds.contains(string)) continue;
            ms.add((IStatus)new Status(4, "com.indy.ui.build", "The mandatory source " + string + " does not belong to the package"));
        }
        return ms;
    }

    public String getName() {
        return "validatePackageSource";
    }

    public String getShortDescription() {
        return "validate the sources in the package";
    }

    public String getUsage() {
        return "validatePackageSource -package <packageFilePath> -md5Rule modelId:md5Checksum[:<mandatory>][;...]";
    }

    public void validatePackageSource(String ... params) {
        StringBuilder b = new StringBuilder();
        b.append(String.valueOf(this.getName()) + " ");
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("-")) {
                b.append(String.valueOf(s) + " ");
            } else {
                b.append("\"" + s + "\" ");
            }
            ++n2;
        }
        this.execute(b.toString(), System.out, System.err);
    }
}

