/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.cli;

import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.service.datalocation.Location;

public class PathResolver {
    private static String workspacePath;

    public static String getWorkspacePath() {
        if (workspacePath == null) {
            try {
                File f = new File(((Location)E4InjectorHelper.getService(Location.class, (String)Location.INSTANCE_FILTER)).getURL().toURI());
                workspacePath = f.getAbsolutePath();
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to find Workspace Path", ex);
            }
        }
        return workspacePath;
    }

    public static WkspPathLocation resolveWorkspaceRelativePath(String path) throws Exception {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        XDIModelURIResolver modelURIResolver = (XDIModelURIResolver)E4InjectorHelper.getService(XDIModelURIResolver.class);
        URI sourceURI = URI.createPlatformResourceURI((String)path, (boolean)true);
        File sourceFile = modelURIResolver.resolve(sourceURI);
        if ("map".equals(sourceURI.fileExtension())) {
            sourceURI = URIUtils.getMappingBuiltProcFile((URI)sourceURI);
            sourceFile = modelURIResolver.resolve(sourceURI);
            path = URIUtils.toPath((URI)sourceURI).toString();
        }
        if (sourceFile == null) {
            throw new Exception(String.format("Unable to find %s in the workspace from path %s", sourceURI, path));
        }
        if (!sourceFile.isFile()) {
            throw new Exception(String.format("The source %s is not a file", sourceFile.getAbsolutePath()));
        }
        return new WkspPathLocation(path, sourceURI, sourceFile);
    }

    public static String resolveFileSystemPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("WKS:/")) {
            Path p = new Path(path.substring(4));
            return String.valueOf(PathResolver.getWorkspacePath()) + "/" + p.toOSString();
        }
        return path;
    }

    public static class WkspPathLocation {
        private URI uri;
        private File sourceFile;
        private IPath path;

        private WkspPathLocation(String path, URI uri, File file) {
            this.path = new Path(path);
            this.sourceFile = file;
            this.uri = uri;
        }

        public File getSourceFile() {
            return this.sourceFile;
        }

        public URI getURI() {
            return this.uri;
        }

        public IPath getPath() {
            return this.path;
        }
    }
}

