/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.cli;

import com.indy.engine.uberbuilder.UberJarBuilder;
import com.indy.engine.uberbuilder.UberJarConfiguration;
import com.indy.shell.parser.CommandAnalyzer;
import com.indy.shell.parser.ShellCommand;
import com.indy.shell.parser.ShellCommandParameter;
import com.semarchy.xdi.designer.core.utils.RuntimeLocationHelper;
import com.semarchy.xdi.designer.generation.cli.Messages;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.felix.shell.Command;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;

@ShellCommand
@Component(property={"osgi.command.scope=stb", "osgi.command.function=buildUberRuntime"}, service={Command.class}, enabled=true)
public class UberRuntimeShellCommand
implements Command {
    @ShellCommandParameter(commutator="runtimeFolder")
    private String runtimeFolder;
    @ShellCommandParameter(commutator="deliveryList")
    private String deliveryList;
    @ShellCommandParameter(commutator="outputFilePath")
    private String outputFilePath;
    @ShellCommandParameter(commutator="moduleFolder")
    private String moduleFolder;
    @ShellCommandParameter(commutator="log4jConfiguration")
    private String log4jConfiguration;
    @ShellCommandParameter(commutator="runtimeConfiguration")
    private String runtimeConfiguration;
    @ShellCommandParameter(commutator="additionalFolder")
    private String additionalFolder;

    public void execute(String line, PrintStream out, PrintStream err) {
        this.runtimeFolder = null;
        this.deliveryList = null;
        this.moduleFolder = null;
        this.log4jConfiguration = null;
        this.runtimeConfiguration = null;
        this.additionalFolder = null;
        PrintWriter writer = new PrintWriter(out);
        try {
            this.parseLine(line.trim().substring(this.getName().length() + 1));
        }
        catch (Exception ex) {
            ex.printStackTrace(err);
            writer.println("ERROR - Command Parsing - " + ex.getMessage());
            return;
        }
        try {
            try {
                IStatus res = this.perform();
                if (res.isOK()) {
                    writer.println("SUCCESS - betaBuildExecutable at " + this.outputFilePath);
                } else {
                    writer.println("ERROR - betaBuildExecutable - " + res.getMessage());
                    if (res.getException() != null) {
                        res.getException().printStackTrace(err);
                    }
                }
            }
            catch (Exception ex) {
                writer.println("ERROR - betaBuildExecutable - " + ex.getMessage());
                writer.flush();
                ex.printStackTrace(err);
                err.flush();
                if (writer != null) {
                    writer.flush();
                }
            }
        }
        finally {
            if (writer != null) {
                writer.flush();
            }
        }
    }

    private IStatus perform() throws Exception {
        File f;
        File runtimeFolder = null;
        if (this.runtimeFolder != null) {
            if (this.runtimeFolder.trim().isEmpty()) {
                throw new Exception(String.format(Messages.UberRuntimeShellCommand_1, new Object[0]));
            }
            runtimeFolder = new File(this.runtimeFolder);
        } else {
            runtimeFolder = RuntimeLocationHelper.getRuntimeLocation();
        }
        if (!runtimeFolder.exists()) {
            throw new Exception(String.format(Messages.UberRuntimeShellCommand_2, runtimeFolder));
        }
        if (!runtimeFolder.isDirectory()) {
            throw new Exception(String.format(Messages.UberRuntimeShellCommand_3, runtimeFolder));
        }
        if (this.deliveryList == null || this.deliveryList.isEmpty()) {
            throw new Exception(String.format(Messages.UberRuntimeShellCommand_4, new Object[0]));
        }
        if (this.outputFilePath == null || this.outputFilePath.isEmpty()) {
            throw new Exception(String.format(Messages.UberRuntimeShellCommand_5, new Object[0]));
        }
        File confFile = null;
        if (this.runtimeConfiguration != null) {
            confFile = new File(this.runtimeConfiguration);
            if (!confFile.exists() || !confFile.isFile()) {
                throw new Exception(String.format(Messages.UberRuntimeShellCommand_6, this.runtimeConfiguration));
            }
        } else {
            throw new Exception(String.format(Messages.UberRuntimeShellCommand_7, new Object[0]));
        }
        UberJarConfiguration conf = new UberJarConfiguration(runtimeFolder, confFile);
        if (this.moduleFolder != null) {
            File moduleFolder = new File(this.moduleFolder);
            if (!moduleFolder.exists() || !moduleFolder.isDirectory()) {
                throw new Exception(String.format(Messages.UberRuntimeShellCommand_8, this.moduleFolder));
            }
            conf.setModuleFolder(moduleFolder);
        }
        if (this.log4jConfiguration != null) {
            f = new File(this.log4jConfiguration);
            if (!f.exists() || !f.isFile()) {
                throw new Exception(String.format(Messages.UberRuntimeShellCommand_9, this.log4jConfiguration));
            }
            conf.setLog4jConfigurationFile(f);
        }
        if (this.additionalFolder != null) {
            f = new File(this.additionalFolder);
            if (!f.exists() || !f.isDirectory()) {
                throw new Exception(String.format(Messages.UberRuntimeShellCommand_10, this.additionalFolder));
            }
            conf.setAdditionalConfigurationFolder(f);
        }
        String[] stringArray = this.deliveryList.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String d = stringArray[n2];
            conf.addDelivery(new File(d));
            ++n2;
        }
        UberJarBuilder builder = new UberJarBuilder(conf);
        builder.buildUberJAR(new File(this.outputFilePath));
        return Status.OK_STATUS;
    }

    public String getName() {
        return "buildUberRuntime";
    }

    public String getShortDescription() {
        return "build a self-executable JAR containing a runtime and the deliveries which can be executed";
    }

    public String getUsage() {
        return "buildUberRuntime -outputFilePath <outputFilePath> [-runtimeFolder <runtimeFolder to include the JAR, if not specified, the current runtime will be used>] -deliveryList [delivPath1;...;delivPathN] [-moduleFolder <moduleFolder>] [-runtimeConfiguration <engineParameter.xml>] [-log4jConfiguration <runtime log4j.xml> [-additionalFolder <folder containing additional files>]]";
    }

    public void buildUberRuntime(String ... params) {
        StringBuilder b = new StringBuilder();
        b.append(String.valueOf(this.getName()) + " ");
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("-")) {
                b.append(String.valueOf(s) + " ");
            } else {
                b.append("\"" + s + "\" ");
            }
            ++n2;
        }
        this.execute(b.toString(), System.out, System.err);
    }

    public void betaBuildUberRuntime(String ... params) {
        this.buildUberRuntime(params);
    }

    private void parseLine(String line) throws Exception {
        CommandAnalyzer helper = new CommandAnalyzer();
        helper.prepare((Object)this, line);
    }
}

