/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.shared.configuration.repository;

import com.indy.engine.shared.configuration.VariableHandler;
import com.indy.engine.shared.configuration.repository.LegacyXmlBean;
import com.indy.engine.shared.configuration.repository.Messages;
import com.indy.engine.shared.configuration.repository.RepositoryXmlBean;
import com.indy.engine.shared.plugin.IPluginFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@XmlRootElement(name="repositories")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RepositoryConfigurationProvider {
    @XmlElement(name="httpRepository")
    List<LegacyXmlBean> compatibilityHttpConfs = new ArrayList<LegacyXmlBean>();
    @XmlElement(name="fileRepository")
    List<LegacyXmlBean> compatibilityFileConfs = new ArrayList<LegacyXmlBean>();
    @XmlElement(name="deliveryRepository")
    List<RepositoryXmlBean> repositoriesConfigurations = new ArrayList<RepositoryXmlBean>();
    @XmlTransient
    List<IPluginFactory.IPluginConfiguration> configurations = new ArrayList<IPluginFactory.IPluginConfiguration>();

    public List<IPluginFactory.IPluginConfiguration> getConfigurations() {
        return this.configurations;
    }

    public static RepositoryConfigurationProvider load(InputStream runtimeEngineParameters) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(runtimeEngineParameters);
        NodeList nl = doc.getChildNodes().item(0).getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node child = nl.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals("repositories")) {
                Node n = child.getAttributes().getNamedItem("file");
                if (n != null) {
                    File f = new File(VariableHandler.updateString(n.getNodeValue()));
                    if (!f.exists() || f.isDirectory()) {
                        throw new Exception(String.format(Messages.getString("RepositoryConfigurationProvider.0"), f.getAbsoluteFile()));
                    }
                    Throwable throwable = null;
                    Object var10_11 = null;
                    try (FileInputStream fis = new FileInputStream(f);){
                        doc = docBuilder.parse(fis);
                        nl = doc.getChildNodes();
                        Node _child = null;
                        int j = 0;
                        while (j < nl.getLength()) {
                            Node c = nl.item(j);
                            if (c.getNodeType() == 1 && child.getNodeName().equals("repositories")) {
                                _child = c;
                                break;
                            }
                            ++j;
                        }
                        if (_child == null) {
                            throw new Exception(String.format(Messages.getString("RepositoryConfigurationProvider.1"), f.getAbsoluteFile()));
                        }
                        child = _child;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{RepositoryConfigurationProvider.class});
                RepositoryConfigurationProvider conf = (RepositoryConfigurationProvider)context.createUnmarshaller().unmarshal(child);
                conf.init();
                return conf;
            }
            ++i;
        }
        return null;
    }

    private void init() {
        for (LegacyXmlBean cfg : this.compatibilityHttpConfs) {
            String environment = cfg.getProperty("environment");
            if (environment != null && !environment.isEmpty()) {
                cfg.setPluginFactoryClassName("com.stambia.repository.delivery.HttpDeliveryRepositoryV2Plugin");
                continue;
            }
            cfg.setPluginFactoryClassName("com.stambia.repository.delivery.HttpDeliveryRepositoryV1Plugin");
        }
        for (LegacyXmlBean cfg : this.compatibilityFileConfs) {
            cfg.setPluginFactoryClassName("com.stambia.repository.delivery.FileDeliveryRepositoryPlugin");
        }
        this.configurations.addAll(this.compatibilityFileConfs);
        this.configurations.addAll(this.compatibilityHttpConfs);
        this.configurations.addAll(this.repositoriesConfigurations);
    }
}

