/*
 * Decompiled with CFR 0.152.
 */
package com.indy.cross.mapping;

import com.indy.cross.ContainerLevel;
import com.indy.cross.CrossFactory;
import com.indy.cross.CrossItem;
import com.indy.cross.CrossObjectType;
import com.indy.map.Clause;
import com.indy.map.DataSet;
import com.indy.map.Datastore;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.Map;
import com.indy.map.Query;
import com.indy.map.QueryField;
import com.indy.map.UDFRef;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RTargetSet;
import com.indy.map.ref.RUDFRef;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.services.registry.UDF;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;

public class LineageHelper {
    private HashMap<Datastore, Set<Datastore>> inputDatastores = new HashMap();
    private HashMap<String, CrossItem> lineageByID = new HashMap();
    private IRegistryService registryService = (IRegistryService)E4InjectorHelper.getService(IRegistryService.class);

    private CrossItem createLineageObject(EObject mdRef, ContainerLevel objectLevel) {
        if (mdRef != null) {
            String dsRefFileID = CacheHelper.extractFileID((EObject)mdRef);
            String dsRefEltID = CacheHelper.extractEltID((EObject)mdRef);
            String dsRefID = String.valueOf(dsRefEltID) + "/" + dsRefFileID;
            CrossItem res = this.lineageByID.get(dsRefID);
            if (res == null) {
                res = CrossFactory.eINSTANCE.createCrossItem(dsRefFileID, dsRefEltID);
                res.setType(CrossObjectType.METADATA);
                res.getProperty().put((Object)"containerLevel", (Object)objectLevel.getLiteral());
                this.lineageByID.put(dsRefID, res);
                if (mdRef instanceof MdNode && !mdRef.eIsProxy()) {
                    String name = ((MdNode)mdRef).getName();
                    if (name != null) {
                        res.getProperty().put((Object)"name", (Object)name);
                    }
                    try {
                        res.getProperty().put((Object)"level", (Object)((MdNode)mdRef).getLevel().getCode());
                    }
                    catch (Exception exception) {}
                    res.getProperty().put((Object)"fullPath", (Object)((MdNode)mdRef).getFullPath(false));
                    CrossItem lastContainer = res;
                    int i = objectLevel.getValue() + 1;
                    while (i < ContainerLevel.values().length) {
                        try {
                            Configuration c = ((MdNode)mdRef).evaluateXpathExpressionMdNode("INTERNAL_MD_CONTAINER_NODE_" + ContainerLevel.values()[i].name());
                            if (c instanceof MdNode) {
                                CrossItem container = this.createLineageObject((EObject)c, ContainerLevel.values()[i]);
                                lastContainer.setContainer(container);
                                lastContainer = container;
                            }
                        }
                        catch (Exception exception) {}
                        ++i;
                    }
                    try {
                        res.getProperty().put((Object)"productCode", (Object)((MdNode)mdRef).evaluateXpathExpressionCached("INTERN_PRODUCT_CODE_GUI", null));
                    }
                    catch (Exception exception) {}
                } else {
                    String name = CacheHelper.extractEltName((String)((InternalEObject)mdRef).eProxyURI().fragment());
                    if (name != null) {
                        res.getProperty().put((Object)"name", (Object)name);
                    }
                }
            } else {
                String s = (String)res.getProperty().get((Object)"containerLevel");
                boolean lvlFound = false;
                if (s != null) {
                    String[] stringArray = s.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String l = stringArray[n2];
                        if (l.equals(objectLevel.getLiteral())) {
                            lvlFound = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (!lvlFound) {
                    if (s == null) {
                        res.getProperty().put((Object)"containerLevel", (Object)objectLevel.getLiteral());
                    } else {
                        res.getProperty().put((Object)"containerLevel", (Object)(String.valueOf(s) + "," + objectLevel.getLiteral()));
                    }
                }
            }
            return res;
        }
        return null;
    }

    public Collection<CrossItem> extractLineage(Map mapModel) {
        RMap refMap = (RMap)mapModel.getMapReference();
        for (Datastore store : mapModel.getDatastore()) {
            Set<Datastore> r = this.extractInputs(refMap, (IContainer)store);
            if (r.isEmpty()) continue;
            this.inputDatastores.put(store, r);
        }
        for (Datastore ds : this.inputDatastores.keySet()) {
            CrossItem target;
            if (ds.getRef() == null || (target = this.createLineageObject(ds.getRef(), ContainerLevel.DATASTORE)) == null) continue;
            for (Datastore in : this.inputDatastores.get(ds)) {
                CrossItem source = this.createLineageObject(in.getRef(), ContainerLevel.DATASTORE);
                if (source == null) continue;
                source.getTarget().add((Object)target);
            }
            for (Field f : ds.getField()) {
                CrossItem targetField;
                if (!f.isMapped() || (targetField = this.createLineageObject(f.getRef(), ContainerLevel.FIELD)) == null) continue;
                for (Expression ex : f.getExpression()) {
                    for (RSourceItem it : ((RExpression)ex.getMapReference()).getRealSourceRef()) {
                        List udf;
                        CrossItem source = null;
                        if (it.getDataModel() instanceof Field) {
                            source = this.createLineageObject(((Field)it.getDataModel()).getRef(), ContainerLevel.FIELD);
                        } else if (it.getDataModel() instanceof QueryField) {
                            for (Field ff : this.extractAllSources((QueryField)it.getDataModel())) {
                                source = this.createLineageObject(ff.getRef(), ContainerLevel.FIELD);
                            }
                        } else if (it.getDataModel() instanceof UDFRef && (udf = this.registryService.getRegistry(UDF.class).find((IRegistryService.IRegistryMatcher)((RUDFRef)it).getIdentifier())) != null && !udf.isEmpty()) {
                            CrossItem res = this.lineageByID.get(((UDF)udf.get(0)).getURI().fragment());
                            if (res == null) {
                                res = CrossFactory.eINSTANCE.createCrossItem();
                                res.setId(((UDF)udf.get(0)).getURI().fragment());
                                this.lineageByID.put(((UDF)udf.get(0)).getURI().fragment(), res);
                                res.setType(CrossObjectType.METADATA);
                                try {
                                    res.getProperty().put((Object)"name", (Object)((UDF)udf.get(0)).getFunctionFullName());
                                }
                                catch (NullPointerException nullPointerException) {
                                    res.getProperty().put((Object)"name", (Object)"?");
                                }
                                res.getProperty().put((Object)"level", (Object)"com.stambia.function.function");
                            }
                            source = res;
                        }
                        if (source == null) continue;
                        source.getTarget().add((Object)targetField);
                    }
                }
            }
            HashSet<Field> clauseSrcFields = new HashSet<Field>();
            for (DataSet dataset : refMap.getTargetSetRef((IContainer)ds).getSourceSet().getDataSet()) {
                ArrayList clauses = new ArrayList();
                clauses.addAll(dataset.getFilter());
                clauses.addAll(dataset.getJoin());
                for (Clause c : clauses) {
                    for (RSourceItem i : ((RClause)c.getMapReference()).getRealSourceRef()) {
                        if (i.getDataModel() instanceof Field) {
                            clauseSrcFields.add((Field)i.getDataModel());
                            continue;
                        }
                        if (!(i.getDataModel() instanceof QueryField)) continue;
                        clauseSrcFields.addAll(this.extractAllSources((QueryField)i.getDataModel()));
                    }
                }
            }
            for (Field targetField : ds.getField()) {
                CrossItem targetFieldCrossItem;
                if (!targetField.isMapped() || (targetFieldCrossItem = this.createLineageObject(targetField.getRef(), ContainerLevel.FIELD)) == null) continue;
                for (Field clauseSrcField : clauseSrcFields) {
                    CrossItem sourceCross = this.createLineageObject(clauseSrcField.getRef(), ContainerLevel.FIELD);
                    if (sourceCross == null) continue;
                    sourceCross.getTarget().add((Object)targetFieldCrossItem);
                }
            }
        }
        return this.lineageByID.values();
    }

    private Collection<Field> extractAllSources(QueryField dataModel) {
        HashSet<Field> res = new HashSet<Field>();
        for (Expression expr : dataModel.getExpression()) {
            for (RSourceItem i : ((RExpression)expr.getMapReference()).getRealSourceRef()) {
                if (i.getDataModel() instanceof Field) {
                    res.add((Field)i.getDataModel());
                    continue;
                }
                if (!(i.getDataModel() instanceof QueryField)) continue;
                res.addAll(this.extractAllSources((QueryField)i.getDataModel()));
            }
        }
        return res;
    }

    private Set<Datastore> extractInputs(RMap refMap, IContainer container) {
        boolean cfr_ignored_0 = container instanceof Query;
        HashSet<Datastore> inputs = new HashSet<Datastore>();
        RTargetSet target = refMap.getTargetSetRef(container);
        if (target != null) {
            for (DataSet ds : target.getSourceSet().getDataSet()) {
                for (IContainer c : ds.getContainer()) {
                    if (c instanceof Datastore) {
                        inputs.add((Datastore)c);
                        continue;
                    }
                    if (!(c instanceof Query)) continue;
                    inputs.addAll(this.extractInputs(refMap, c));
                }
            }
        }
        return inputs;
    }
}

