/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.azure.table.storage.runtime;

import com.indy.engine.core.json.annotation.JsonElement;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class AzureTableMetadata {
    @JsonElement(name="tableName")
    private String tableName;
    @JsonElement(name="connectionString")
    private String connectionString;
    @JsonElement(name="operation")
    private Operation operation;
    @JsonElement(name="batchSize")
    private String batchSize;
    @JsonElement(name="types")
    private Map<String, ODataType> types = new HashMap<String, ODataType>();

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Integer getBatchSize() {
        try {
            return Integer.valueOf(this.batchSize);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public Map<String, ODataType> getTypes() {
        return this.types;
    }

    public ODataType getType(String propertyName) {
        return this.types.get(propertyName);
    }

    public static enum ODataType {
        String,
        DateTime,
        Boolean,
        Int64,
        Int32,
        Guid,
        Binary,
        Double;


        public static ODataType fromObject(Object obj) {
            if (obj instanceof String) {
                return String;
            }
            if (obj instanceof Boolean) {
                return Boolean;
            }
            if (obj instanceof Integer) {
                return Int32;
            }
            if (obj instanceof Long) {
                return Int64;
            }
            if (obj instanceof byte[]) {
                return Binary;
            }
            if (obj instanceof OffsetDateTime) {
                return DateTime;
            }
            if (obj instanceof UUID) {
                return Guid;
            }
            if (obj instanceof Double) {
                return Double;
            }
            return null;
        }

        public String toODataName() {
            return "Edm." + this.name();
        }
    }

    public static enum Operation {
        create,
        upsert,
        delete,
        update,
        get;

    }
}

