/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.util.logging.ClientLogger;
import java.util.HashMap;
import java.util.Map;

final class ConnectionSettings
implements Cloneable {
    private final Map<String, String> settings;

    public boolean hasSetting(String name) {
        return this.settings.containsKey(name);
    }

    public void removeSetting(String name) {
        this.settings.remove(name);
    }

    public String getSettingValue(String name) {
        return this.settings.get(name);
    }

    public boolean isEmpty() {
        return this.settings.isEmpty();
    }

    public void setSetting(String name, String value) {
        this.settings.put(name, value);
    }

    public static ConnectionSettings fromConnectionString(String connectionString, ClientLogger logger) {
        String[] settings;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : settings = connectionString.split(";")) {
            String setting = s.trim();
            if (setting.length() <= 0) continue;
            int idx = setting.indexOf("=");
            if (idx == -1 || idx == 0 || idx == s.length() - 1) {
                throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Invalid connection string."));
            }
            map.put(setting.substring(0, idx), setting.substring(idx + 1));
        }
        return new ConnectionSettings(map);
    }

    public ConnectionSettings clone() {
        return new ConnectionSettings(new HashMap<String, String>(this.settings));
    }

    private ConnectionSettings(Map<String, String> settings) {
        this.settings = settings;
    }
}

