/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.help.internal;

import com.indy.ui.custom.out.Activator;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.help.IContext;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.AbstractHelpUI;

public class ExternalHelpUI
extends AbstractHelpUI {
    private static final String PROP_BASE_HELP_URL = "xdi.designer.help.baseUrl";
    private static final String HELP_INDEX = "/index.html";
    private String baseURL = Activator.getDefault().readProperty("xdi.designer.help.baseUrl");

    public ExternalHelpUI() {
        if (this.baseURL != null && !this.baseURL.endsWith("/")) {
            this.baseURL = String.valueOf(this.baseURL) + "/";
        }
    }

    private URL getURL(String href) throws MalformedURLException {
        String s = this.baseURL;
        if (href != null) {
            if (href.startsWith("com.indy.ui.help.")) {
                href = href.replace("com.indy.ui.help.", "");
            }
            if (href.startsWith("/")) {
                href = href.substring(1);
            }
            if (href.contains("#")) {
                int i = href.indexOf("#");
                href = String.valueOf(href.substring(0, i)) + ".html" + href.substring(i);
            } else if (!href.endsWith(".html")) {
                href = String.valueOf(href) + ".html";
            }
            s = String.valueOf(s) + href;
        }
        return new URL(s);
    }

    private void openURL(String href) {
        try {
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(this.getURL(href));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void displayHelp() {
        this.openURL(HELP_INDEX);
    }

    public void displayContext(IContext context, int x, int y) {
        if (context.getRelatedTopics() != null && context.getRelatedTopics().length > 0) {
            this.openURL(context.getRelatedTopics()[0].getHref());
        }
    }

    public void displayHelpResource(String href) {
        this.openURL(href);
    }

    public boolean isContextHelpDisplayed() {
        return false;
    }
}

