/*
 * Decompiled with CFR 0.152.
 */
package com.indy.cross.process;

import com.indy.cross.ContainerLevel;
import com.indy.cross.CrossFactory;
import com.indy.cross.CrossItem;
import com.indy.cross.CrossObjectType;
import com.indy.gmf.proc.Action;
import com.indy.gmf.proc.ActionProcess;
import com.indy.gmf.proc.DocumentRoot;
import com.indy.gmf.proc.MetaDataLink;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;

public class LineageHelper {
    private HashMap<String, CrossItem> lineageByID = new HashMap();

    private CrossItem createLineageObject(EObject mdRef, ContainerLevel objectLevel) {
        if (mdRef != null) {
            String dsRefFileID = CacheHelper.extractFileID((EObject)mdRef);
            String dsRefEltID = CacheHelper.extractEltID((EObject)mdRef);
            String dsRefID = String.valueOf(dsRefEltID) + "/" + dsRefFileID;
            CrossItem res = this.lineageByID.get(dsRefID);
            if (res == null) {
                res = CrossFactory.eINSTANCE.createCrossItem(dsRefFileID, dsRefEltID);
                res.setType(CrossObjectType.METADATA);
                if (objectLevel != null) {
                    res.getProperty().put((Object)"containerLevel", (Object)objectLevel.getLiteral());
                }
                this.lineageByID.put(dsRefID, res);
                if (mdRef instanceof MdNode && !mdRef.eIsProxy()) {
                    String name = ((MdNode)mdRef).getName();
                    if (name != null) {
                        res.getProperty().put((Object)"name", (Object)name);
                    }
                    try {
                        res.getProperty().put((Object)"level", (Object)((MdNode)mdRef).getLevel().getCode());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    res.getProperty().put((Object)"fullPath", (Object)((MdNode)mdRef).getFullPath(false));
                    CrossItem lastContainer = res;
                    if (objectLevel == null) {
                        ContainerLevel[] containerLevelArray = ContainerLevel.values();
                        int n = containerLevelArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ContainerLevel l = containerLevelArray[n2];
                            try {
                                Configuration c = ((MdNode)mdRef).evaluateXpathExpressionMdNode("INTERNAL_MD_CONTAINER_NODE_" + l.name());
                                if (c instanceof MdNode) {
                                    CrossItem container = this.createLineageObject((EObject)c, l);
                                    lastContainer.setContainer(container);
                                    lastContainer = container;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++n2;
                        }
                    } else {
                        int i = objectLevel.getValue() + 1;
                        while (i < ContainerLevel.values().length) {
                            try {
                                Configuration c = ((MdNode)mdRef).evaluateXpathExpressionMdNode("INTERNAL_MD_CONTAINER_NODE_" + ContainerLevel.values()[i].name());
                                if (c instanceof MdNode) {
                                    CrossItem container = this.createLineageObject((EObject)c, ContainerLevel.values()[i]);
                                    lastContainer.setContainer(container);
                                    lastContainer = container;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++i;
                        }
                    }
                    try {
                        res.getProperty().put((Object)"productCode", (Object)((MdNode)mdRef).evaluateXpathExpressionCached("INTERN_PRODUCT_CODE_GUI", null));
                    }
                    catch (Exception exception) {}
                } else {
                    String name = CacheHelper.extractEltName((String)((InternalEObject)mdRef).eProxyURI().fragment());
                    if (name != null) {
                        res.getProperty().put((Object)"name", (Object)name);
                    }
                }
            } else if (objectLevel != null && ContainerLevel.get((String)((String)res.getProperty().get((Object)"containerLevel"))).ordinal() > objectLevel.ordinal()) {
                res.getProperty().put((Object)"containerLevel", (Object)objectLevel.getLiteral());
            }
            return res;
        }
        return null;
    }

    public Collection<CrossItem> extractLineage(ActionProcess proc) {
        this.extractMdLinks((Action)proc);
        return this.lineageByID.values();
    }

    private void extractMdLinks(Action action) {
        for (MetaDataLink mdl : action.getMetaDataLink()) {
            EObject obj = mdl.getTarget();
            if (!(obj instanceof MdNode)) continue;
            CrossItem mdlItem = this.createLineageObject(mdl, (MdNode)obj);
            CrossItem item = this.createLineageObject((EObject)((MdNode)obj), null);
            if (item == null) continue;
            item.getTarget().add((Object)mdlItem);
        }
        if (action instanceof ActionProcess) {
            for (Action a : ((ActionProcess)action).getAction()) {
                this.extractMdLinks(a);
            }
        }
    }

    private CrossItem createLineageObject(MetaDataLink mdl, MdNode mdRef) {
        String mdlEltID = CacheHelper.extractEltID((EObject)mdl.eContainer());
        String mdlFileID = null;
        mdlFileID = CacheHelper.extractEltID((EObject)((DocumentRoot)mdl.eResource().getContents().get(0)).getProcess());
        CrossItem res = CrossFactory.eINSTANCE.createCrossItem(mdlFileID, mdlEltID);
        this.lineageByID.put(String.valueOf(mdlFileID) + "/" + mdlEltID, res);
        res.setType(CrossObjectType.METADATALINK);
        res.getProperty().put((Object)"name", (Object)mdl.getName().toString());
        try {
            res.getProperty().put((Object)"level", (Object)mdRef.getLevel().getCode());
        }
        catch (Exception exception) {
            // empty catch block
        }
        res.getProperty().put((Object)"fullPath", (Object)mdl.getFullPath());
        return res;
    }
}

