/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ftp;

import com.stambia.ftp.Messages;
import com.stambia.ftp.SSLSessionReuseFTPSClient;
import com.stambia.ftp.commands.FtpCommand;
import com.stambia.ftp.commands.FtpCommand_APPEND;
import com.stambia.ftp.commands.FtpCommand_ASCII;
import com.stambia.ftp.commands.FtpCommand_BINARY;
import com.stambia.ftp.commands.FtpCommand_CDUP;
import com.stambia.ftp.commands.FtpCommand_CONNECT;
import com.stambia.ftp.commands.FtpCommand_CWD;
import com.stambia.ftp.commands.FtpCommand_DELE;
import com.stambia.ftp.commands.FtpCommand_DELE_MULTIPLEFILES;
import com.stambia.ftp.commands.FtpCommand_HELP;
import com.stambia.ftp.commands.FtpCommand_LIST;
import com.stambia.ftp.commands.FtpCommand_LISTNAMES;
import com.stambia.ftp.commands.FtpCommand_LOGIN;
import com.stambia.ftp.commands.FtpCommand_MDTM;
import com.stambia.ftp.commands.FtpCommand_MKD;
import com.stambia.ftp.commands.FtpCommand_PASS;
import com.stambia.ftp.commands.FtpCommand_PWD;
import com.stambia.ftp.commands.FtpCommand_QUIT;
import com.stambia.ftp.commands.FtpCommand_RENAME;
import com.stambia.ftp.commands.FtpCommand_RETR;
import com.stambia.ftp.commands.FtpCommand_RETR_MULTIPLEFILES;
import com.stambia.ftp.commands.FtpCommand_RETR_NEWER;
import com.stambia.ftp.commands.FtpCommand_RMD;
import com.stambia.ftp.commands.FtpCommand_RNFR;
import com.stambia.ftp.commands.FtpCommand_RNTO;
import com.stambia.ftp.commands.FtpCommand_SITE;
import com.stambia.ftp.commands.FtpCommand_SIZE;
import com.stambia.ftp.commands.FtpCommand_STAT;
import com.stambia.ftp.commands.FtpCommand_STOR;
import com.stambia.ftp.commands.FtpCommand_STOR_MULTIPLEFILES;
import com.stambia.ftp.commands.FtpCommand_STOU;
import com.stambia.ftp.commands.FtpCommand_SYST;
import com.stambia.ftp.commands.FtpCommand_TYPE;
import com.stambia.ftp.commands.FtpCommand_UNKNOWN;
import com.stambia.ftp.commands.FtpCommand_USER;
import com.stambia.ftp.commands.FtpCommand_XMKD;
import com.stambia.ftp.commands.FtpCommands;
import com.stambia.ftp.exceptions.BadSyntaxException;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.exceptions.WrongPathException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpCommandParser;
import com.stambia.ftp.utils.FtpCommandResponses;
import com.stambia.ftp.utils.FtpStatisticListener;
import com.stambia.ftp.utils.FtpUtils;
import com.stambia.ftp.utils.IFtpSession;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;

public class FtpSession
implements IFtpSession {
    public static int FTP_PORT = 21;
    public static int FTPS_PORT = 990;
    public static boolean isImplicitDefault = false;
    public static String defaultLocalPath = "./";
    private FTPClient ftpCli;
    private FtpCommand<FTPClient> ftpCmd;
    private String localPath = defaultLocalPath;
    private boolean isImplicit = false;
    private String protocol;
    private boolean verbose = true;
    private boolean raiseException = false;
    private boolean quitBoolean = true;
    private OutputStream os;
    private PrintStream ps;
    private FtpCommands enumCommand;
    List<FtpStatisticListener> statisticListeners = new ArrayList<FtpStatisticListener>();
    private StringBuilder commandLog = new StringBuilder();
    FtpCommandHandler commandHandler = new FtpCommandHandler(){

        @Override
        public void handleResponse(String response) {
            String formattedResponse = FtpUtils.convertLineReturns(response);
            if (FtpSession.this.ps != null) {
                FtpSession.this.ps.println(formattedResponse);
            }
            FtpSession.this.commandLog.append(formattedResponse);
        }

        @Override
        public void handleError(String response, FtpCommandException e) throws FtpCommandException {
            if (response != null) {
                if (FtpSession.this.ps != null) {
                    FtpSession.this.ps.println(e.getMessage());
                }
                FtpSession.this.commandLog.append(e.getMessage());
            }
            if (FtpSession.this.raiseException) {
                throw e;
            }
        }

        @Override
        public void handleError(String response, IOException e) throws IOException {
            if (response != null) {
                if (FtpSession.this.ps != null) {
                    FtpSession.this.ps.println(e.getMessage());
                }
                FtpSession.this.commandLog.append(e.getMessage());
            }
            if (FtpSession.this.raiseException) {
                throw e;
            }
        }
    };

    @Override
    public void addListener(FtpStatisticListener statisticListener) {
        this.statisticListeners.add(statisticListener);
    }

    public FtpSession(FTPClient ftpClient) {
        this.ftpCli = ftpClient;
    }

    public FtpSession() throws NoSuchAlgorithmException {
        this("NONE");
    }

    public FtpSession(String protocol) throws NoSuchAlgorithmException {
        this(protocol, isImplicitDefault);
    }

    public FtpSession(String protocol, Boolean isImplicit) throws NoSuchAlgorithmException {
        if (protocol == null || protocol.contentEquals("NONE") || protocol.contentEquals("")) {
            this.ftpCli = new FTPClient();
        } else {
            this.ftpCli = new SSLSessionReuseFTPSClient(protocol, isImplicit);
            this.ftpCli.setBufferSize(0);
        }
        this.setProtocol(protocol);
        this.isImplicit = isImplicit;
    }

    @Override
    public String executeCommand(String commandString) throws IOException, FtpCommandException {
        String command = FtpCommandParser.retrieveCommand(commandString);
        String[] parameters = FtpCommandParser.retrieveParameters(commandString);
        this.commandLog.setLength(0);
        if (command != null && !command.equals("")) {
            if (command.equals("quote")) {
                if (parameters[0] != null) {
                    command = parameters[0];
                    parameters = FtpUtils.removeFirstParameter(parameters);
                } else {
                    this.commandHandler.handleResponse(FtpCommandResponses.MISSING_PARAMETER);
                    return FtpCommandResponses.MISSING_PARAMETER;
                }
            }
            try {
                this.enumCommand = FtpCommands.valueOf(command);
            }
            catch (IllegalArgumentException e) {
                this.enumCommand = FtpCommands.unknown;
            }
            try {
                switch (this.enumCommand) {
                    case ascii: {
                        this.ftpCmd = new FtpCommand_ASCII(command, parameters);
                        break;
                    }
                    case binary: {
                        this.ftpCmd = new FtpCommand_BINARY(command, parameters);
                        break;
                    }
                    case open: {
                        this.ftpCmd = new FtpCommand_CONNECT(command, parameters);
                        ((FtpCommand_CONNECT)this.ftpCmd).connect(this.ftpCli, this.isImplicit, this.verbose, this.commandHandler);
                        return this.getLog();
                    }
                    case connect: {
                        this.ftpCmd = new FtpCommand_CONNECT(command, parameters);
                        ((FtpCommand_CONNECT)this.ftpCmd).connect(this.ftpCli, this.isImplicit, this.verbose, this.commandHandler);
                        return this.getLog();
                    }
                    case user: {
                        this.ftpCmd = new FtpCommand_USER(command, parameters);
                        break;
                    }
                    case pass: {
                        this.ftpCmd = new FtpCommand_PASS(command, parameters);
                        break;
                    }
                    case password: {
                        this.ftpCmd = new FtpCommand_PASS(command, parameters);
                        break;
                    }
                    case login: {
                        this.ftpCmd = new FtpCommand_LOGIN(command, parameters);
                        break;
                    }
                    case ls: {
                        this.ftpCmd = new FtpCommand_LIST(command, parameters);
                        break;
                    }
                    case list: {
                        this.ftpCmd = new FtpCommand_LIST(command, parameters);
                        break;
                    }
                    case mlsd: {
                        this.ftpCmd = new FtpCommand_LIST(command, parameters);
                        break;
                    }
                    case mlst: {
                        this.ftpCmd = new FtpCommand_LIST(command, parameters);
                        break;
                    }
                    case nlst: {
                        this.ftpCmd = new FtpCommand_LISTNAMES(command, parameters);
                        break;
                    }
                    case dir: {
                        this.ftpCmd = new FtpCommand_LIST(command, parameters);
                        break;
                    }
                    case cwd: {
                        this.ftpCmd = new FtpCommand_CWD(command, parameters);
                        break;
                    }
                    case cd: {
                        this.ftpCmd = new FtpCommand_CWD(command, parameters);
                        break;
                    }
                    case cdup: {
                        this.ftpCmd = new FtpCommand_CDUP(command, parameters);
                        break;
                    }
                    case lcd: {
                        this.ftpCommand_LCD(this.ftpCli, parameters[0], this.commandHandler);
                        return this.getLog();
                    }
                    case put: {
                        this.ftpCmd = new FtpCommand_STOR(command, parameters);
                        break;
                    }
                    case send: {
                        this.ftpCmd = new FtpCommand_STOR(command, parameters);
                        break;
                    }
                    case stor: {
                        this.ftpCmd = new FtpCommand_STOR(command, parameters);
                        break;
                    }
                    case mput: {
                        this.ftpCmd = new FtpCommand_STOR_MULTIPLEFILES(command, parameters);
                        break;
                    }
                    case stou: {
                        this.ftpCmd = new FtpCommand_STOU(command, parameters);
                        break;
                    }
                    case appe: {
                        this.ftpCmd = new FtpCommand_APPEND(command, parameters);
                        break;
                    }
                    case append: {
                        this.ftpCmd = new FtpCommand_APPEND(command, parameters);
                        break;
                    }
                    case get: {
                        this.ftpCmd = new FtpCommand_RETR(command, parameters);
                        break;
                    }
                    case recv: {
                        this.ftpCmd = new FtpCommand_RETR(command, parameters);
                        break;
                    }
                    case retr: {
                        this.ftpCmd = new FtpCommand_RETR(command, parameters);
                        break;
                    }
                    case newer: {
                        this.ftpCmd = new FtpCommand_RETR_NEWER(command, parameters);
                        break;
                    }
                    case mget: {
                        this.ftpCmd = new FtpCommand_RETR_MULTIPLEFILES(command, parameters);
                        break;
                    }
                    case dele: {
                        this.ftpCmd = new FtpCommand_DELE(command, parameters);
                        break;
                    }
                    case delete: {
                        this.ftpCmd = new FtpCommand_DELE(command, parameters);
                        break;
                    }
                    case mdelete: {
                        this.ftpCmd = new FtpCommand_DELE_MULTIPLEFILES(command, parameters);
                        break;
                    }
                    case rmd: {
                        this.ftpCmd = new FtpCommand_RMD(command, parameters);
                        break;
                    }
                    case rmdir: {
                        this.ftpCmd = new FtpCommand_RMD(command, parameters);
                        break;
                    }
                    case rnfr: {
                        this.ftpCmd = new FtpCommand_RNFR(command, parameters);
                        break;
                    }
                    case rnto: {
                        this.ftpCmd = new FtpCommand_RNTO(command, parameters);
                        break;
                    }
                    case rename: {
                        this.ftpCmd = new FtpCommand_RENAME(command, parameters);
                        break;
                    }
                    case pwd: {
                        this.ftpCmd = new FtpCommand_PWD(command, parameters);
                        break;
                    }
                    case mkd: {
                        this.ftpCmd = new FtpCommand_MKD(command, parameters);
                        break;
                    }
                    case mkdir: {
                        this.ftpCmd = new FtpCommand_MKD(command, parameters);
                        break;
                    }
                    case xmkd: {
                        this.ftpCmd = new FtpCommand_XMKD(command, parameters);
                        break;
                    }
                    case size: {
                        this.ftpCmd = new FtpCommand_SIZE(command, parameters);
                        break;
                    }
                    case type: {
                        if (parameters.length != 0) {
                            if (parameters[0] != null) {
                                if (parameters[0].toLowerCase().equals("ascii") || parameters[0].toLowerCase().equals("a")) {
                                    this.ftpCmd = new FtpCommand_ASCII(command, parameters);
                                    break;
                                }
                                if (parameters[0].toLowerCase().equals("image") || parameters[0].toLowerCase().equals("i") || parameters[0].toLowerCase().equals("binary")) {
                                    this.ftpCmd = new FtpCommand_BINARY(command, parameters);
                                    break;
                                }
                                this.ftpCmd = new FtpCommand_TYPE(command, parameters);
                                break;
                            }
                        } else {
                            this.commandHandler.handleResponse(FtpCommandResponses.MISSING_PARAMETER);
                            return this.getLog();
                        }
                    }
                    case mdtm: {
                        this.ftpCmd = new FtpCommand_MDTM(command, parameters);
                        break;
                    }
                    case modtime: {
                        this.ftpCmd = new FtpCommand_MDTM(command, parameters);
                        break;
                    }
                    case help: 
                    case rhelp: {
                        String lineReturn = System.lineSeparator();
                        this.ftpCmd = new FtpCommand_HELP(command, parameters);
                        if (parameters.length == 0 || parameters[0] == null) {
                            this.commandHandler.handleResponse(FtpUtils.getStambiaCommandsHelp());
                            this.commandHandler.handleResponse(String.valueOf(lineReturn) + lineReturn + Messages.getString("FtpSession.0") + lineReturn + " ");
                            this.ftpCmd.executeCommand(this.ftpCli, this.localPath, this.verbose, this.commandHandler, this.statisticListeners);
                        } else {
                            this.commandHandler.handleResponse(String.valueOf(Messages.getString("FtpSession.1")) + lineReturn + " ");
                            this.ftpCmd.executeCommand(this.ftpCli, this.localPath, this.verbose, this.commandHandler, this.statisticListeners);
                        }
                        return this.getLog();
                    }
                    case syst: {
                        this.ftpCmd = new FtpCommand_SYST(command, parameters);
                        break;
                    }
                    case system: {
                        this.ftpCmd = new FtpCommand_SYST(command, parameters);
                        break;
                    }
                    case stat: {
                        this.ftpCmd = new FtpCommand_STAT(command, parameters);
                        break;
                    }
                    case status: {
                        this.ftpCmd = new FtpCommand_STAT(command, parameters);
                        break;
                    }
                    case site: {
                        this.ftpCmd = new FtpCommand_SITE(command, parameters);
                        break;
                    }
                    case pasv: {
                        this.ftpCli.enterLocalPassiveMode();
                        this.commandHandler.handleResponse(FtpCommandResponses.PASSIVE_MODE);
                        return FtpCommandResponses.PASSIVE_MODE;
                    }
                    case passive: {
                        this.ftpCli.enterLocalPassiveMode();
                        this.commandHandler.handleResponse(FtpCommandResponses.PASSIVE_MODE);
                        return FtpCommandResponses.PASSIVE_MODE;
                    }
                    case active: {
                        this.ftpCli.enterLocalPassiveMode();
                        this.commandHandler.handleResponse(FtpCommandResponses.ACTIVE_MODE);
                        return FtpCommandResponses.ACTIVE_MODE;
                    }
                    case quit: {
                        this.quitBoolean = false;
                        this.ftpCmd = new FtpCommand_QUIT(command, parameters);
                        break;
                    }
                    case close: {
                        this.quitBoolean = false;
                        this.ftpCmd = new FtpCommand_QUIT(command, parameters);
                        break;
                    }
                    case exit: {
                        this.quitBoolean = false;
                        this.ftpCmd = new FtpCommand_QUIT(command, parameters);
                        break;
                    }
                    case disconnect: {
                        this.quitBoolean = false;
                        this.ftpCmd = new FtpCommand_QUIT(command, parameters);
                        break;
                    }
                    case bye: {
                        this.quitBoolean = false;
                        this.ftpCmd = new FtpCommand_QUIT(command, parameters);
                        break;
                    }
                    case unknown: {
                        this.ftpCmd = new FtpCommand_UNKNOWN(command, parameters);
                        break;
                    }
                    case verbose: {
                        this.verbose = FtpUtils.isVerbose(parameters[0], this.verbose);
                        if (this.verbose) {
                            this.commandHandler.handleResponse(FtpCommandResponses.VERBOSE_YES);
                            return FtpCommandResponses.VERBOSE_YES;
                        }
                        this.commandHandler.handleResponse(FtpCommandResponses.VERBOSE_NO);
                        return FtpCommandResponses.VERBOSE_NO;
                    }
                    default: {
                        this.ftpCmd = new FtpCommand_UNKNOWN(command, parameters);
                    }
                }
                this.ftpCmd.executeCommand(this.ftpCli, this.localPath, this.verbose, this.commandHandler, this.statisticListeners);
                return this.getLog();
            }
            catch (IOException e) {
                this.commandHandler.handleError("", e);
                return this.getLog();
            }
        }
        BadSyntaxException exception = new BadSyntaxException(FtpCommandResponses.MISSING_PARAMETER);
        this.commandHandler.handleError("", exception);
        return this.getLog();
    }

    public void executeCommandList(String commandList) throws IOException, FtpCommandException {
        this.quitBoolean = true;
        if ((commandList.contains("\n") || commandList.contains("\\n")) && commandList != null) {
            String[] commands;
            String[] stringArray = commands = commandList.split("\\n");
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                String command = stringArray[n2];
                this.executeCommand(command);
                ++n2;
            }
            if (this.quitBoolean) {
                this.ftpCli.sendCommand("QUIT");
                this.commandLog.append(String.valueOf(this.ftpCli.getReplyString()) + '\n');
            }
        } else {
            this.executeCommand(commandList);
        }
    }

    public void ftpCommand_LCD(FTPClient ftpCli, String path, FtpCommandHandler handler) throws IOException, FtpCommandException {
        File f;
        if (path == null) {
            path = this.localPath;
        }
        if ((f = new File(path = path.replaceAll("^\"|\"$", ""))).isDirectory()) {
            if (f.exists()) {
                handler.handleResponse(String.valueOf(FtpCommandResponses.LCD_RESPONSE_OK) + FtpUtils.addLastSlash(FtpUtils.removeFirstAndLastQuotes(path)));
                this.localPath = FtpUtils.addLastSlash(FtpUtils.removeFirstAndLastQuotes(path));
            } else {
                WrongPathException e = new WrongPathException(path);
                handler.handleError("", e);
            }
        } else {
            WrongPathException e = new WrongPathException(path);
            handler.handleError("", e);
        }
    }

    @Override
    public void dispose() throws IOException {
        if (this.ftpCli != null) {
            this.ftpCli.disconnect();
        }
        if (this.ps != null) {
            this.ps.close();
        }
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String path) {
        this.localPath = path;
    }

    public FTPClient getFtpCli() {
        return this.ftpCli;
    }

    public void setFtpCli(FTPClient ftpCli) {
        this.ftpCli = ftpCli;
    }

    public String getLog() {
        return this.commandLog.toString();
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    @Override
    public void setOutputStream(OutputStream os) {
        this.os = os;
        this.ps = new PrintStream(os);
    }

    @Override
    public void setRaiseException(boolean raiseException) {
        this.raiseException = raiseException;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

