/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ftp.commands;

import com.stambia.ftp.FtpSession;
import com.stambia.ftp.SSLSessionReuseFTPSClient;
import com.stambia.ftp.commands.FtpCommand;
import com.stambia.ftp.commands.Messages;
import com.stambia.ftp.exceptions.ConnectionFailedException;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.exceptions.UseConnectException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpStatisticListener;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.List;
import javax.net.ssl.SSLException;
import org.apache.commons.net.ftp.FTPClient;

public class FtpCommand_CONNECT
extends FtpCommand<FTPClient> {
    public FtpCommand_CONNECT(String command, String[] parameters) {
        super(command, parameters);
    }

    public FtpCommand_CONNECT(FtpCommand<FTPClient> ftpCmd) {
        super(ftpCmd);
    }

    @Override
    public void executeCommand(FTPClient ftpCli, String localPath, boolean verbose, FtpCommandHandler commandHandler, List<FtpStatisticListener> statisticsListeners) throws FtpCommandException {
        throw new UseConnectException();
    }

    public void connect(FTPClient ftpCli, boolean isImplicit, boolean verbose, FtpCommandHandler handler) throws NumberFormatException, SocketException, IOException, FtpCommandException {
        int port = this.getParameters()[1] != null && !this.getParameters()[1].equals(Messages.getString("FtpCommand_CONNECT.0")) && !this.getParameters()[1].equals(Messages.getString("FtpCommand_CONNECT.1")) ? Integer.parseInt(this.getParameters()[1]) : (ftpCli instanceof SSLSessionReuseFTPSClient ? (isImplicit ? FtpSession.FTPS_PORT : FtpSession.FTP_PORT) : FtpSession.FTP_PORT);
        try {
            ftpCli.connect(this.getParameters()[0], port);
            if (verbose) {
                if (this.isResponseFine(ftpCli)) {
                    handler.handleResponse(String.valueOf(ftpCli.getReplyString()) + this.secureConnection(ftpCli));
                } else {
                    ConnectionFailedException exception = new ConnectionFailedException(ftpCli.getReplyString());
                    handler.handleError(ftpCli.getReplyString(), exception);
                }
            } else if (this.isResponseFine(ftpCli)) {
                this.secureConnection(ftpCli);
            } else {
                ConnectionFailedException exception = new ConnectionFailedException(ftpCli.getReplyString());
                handler.handleError(ftpCli.getReplyString(), exception);
            }
        }
        catch (UnknownHostException ue) {
            com.stambia.ftp.exceptions.UnknownHostException e = new com.stambia.ftp.exceptions.UnknownHostException(ue.getMessage());
            handler.handleError(Messages.getString("FtpCommand_CONNECT.2"), e);
        }
        catch (ConnectException ce) {
            ConnectionFailedException e = new ConnectionFailedException(ce.getMessage());
            handler.handleError(Messages.getString("FtpCommand_CONNECT.3"), e);
        }
    }

    public String secureConnection(FTPClient ftpCli) throws SSLException, IOException {
        StringBuilder response = new StringBuilder();
        if (ftpCli instanceof SSLSessionReuseFTPSClient) {
            ((SSLSessionReuseFTPSClient)ftpCli).execPBSZ(0L);
            response.append(ftpCli.getReplyString());
            ((SSLSessionReuseFTPSClient)ftpCli).execPROT(Messages.getString("FtpCommand_CONNECT.4"));
            response.append(ftpCli.getReplyString());
            return response.toString();
        }
        return Messages.getString("FtpCommand_CONNECT.5");
    }
}

