/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.sftp.commands;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import com.stambia.ftp.commands.FtpCommand;
import com.stambia.ftp.exceptions.BadSyntaxException;
import com.stambia.ftp.exceptions.FileNotFoundException;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpCommandResponses;
import com.stambia.ftp.utils.FtpStatisticListener;
import com.stambia.ftp.utils.FtpUtils;
import com.stambia.sftp.commands.Messages;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class SFtpCommand_PUT
extends FtpCommand<ChannelSftp> {
    public SFtpCommand_PUT(String command, String[] parameters) {
        super(command, parameters);
    }

    public SFtpCommand_PUT(FtpCommand<ChannelSftp> ftpCmd) {
        super(ftpCmd);
    }

    @Override
    public void executeCommand(ChannelSftp ftpCli, String localPath, boolean verbose, FtpCommandHandler commandHandler, List<FtpStatisticListener> statisticsListeners) throws IOException, FtpCommandException {
        String replyString = Messages.getString("SFtpCommand_PUT.0");
        String localSource = FtpUtils.removeFirstAndLastQuotes(this.getParameters()[0]);
        String remoteDest = FtpUtils.removeFirstAndLastQuotes(this.getParameters()[1]);
        int mode = -1;
        if (this.getParameters()[2] != null) {
            mode = Integer.valueOf(this.getParameters()[2]);
        }
        if (localSource != null) {
            File localFile = new File(localSource);
            this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.STORED_FILES_SIZE, new File(String.valueOf(ftpCli.lpwd()) + "/" + localSource).length());
            if (localFile.isFile() || new File(String.valueOf(ftpCli.lpwd()) + "/" + localSource).isFile() || localSource.contains("*")) {
                FtpCommandException ftpCommandException;
                if (remoteDest == null) {
                    mode = -1;
                    try {
                        remoteDest = ftpCli.pwd();
                    }
                    catch (SftpException e) {
                        ftpCommandException = new FtpCommandException(e.getMessage());
                        commandHandler.handleError("", ftpCommandException);
                    }
                }
                try {
                    if (mode == 2 || mode == 0 || mode == 1) {
                        ftpCli.put(localSource, remoteDest, mode);
                    } else {
                        ftpCli.put(localSource, remoteDest);
                    }
                    if (verbose) {
                        commandHandler.handleResponse(replyString);
                    }
                }
                catch (SftpException e) {
                    ftpCommandException = new FtpCommandException(e.getMessage());
                    commandHandler.handleError("", ftpCommandException);
                }
            } else {
                FileNotFoundException e = new FileNotFoundException(localFile.getAbsolutePath());
                commandHandler.handleError("", e);
            }
        } else {
            BadSyntaxException exception = new BadSyntaxException(FtpCommandResponses.MISSING_PARAMETER);
            commandHandler.handleError("", exception);
        }
    }
}

