/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.sftp.commands;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import com.stambia.ftp.commands.FtpCommand;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpStatisticListener;
import com.stambia.ftp.utils.FtpUtils;
import com.stambia.sftp.commands.Messages;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class SFtpCommand_RMDIR
extends FtpCommand<ChannelSftp> {
    public SFtpCommand_RMDIR(String command, String[] parameters) {
        super(command, parameters);
    }

    public SFtpCommand_RMDIR(FtpCommand<ChannelSftp> ftpCmd) {
        super(ftpCmd);
    }

    private void recursiveFolderDelete(String path, ChannelSftp ftpCli) {
        try {
            Vector fileList = ftpCli.ls(path);
            for (ChannelSftp.LsEntry file : fileList) {
                if (!file.getAttrs().isDir()) {
                    ftpCli.rm(String.valueOf(path) + "/" + file.getFilename());
                    continue;
                }
                if (".".equals(file.getFilename()) || "..".equals(file.getFilename())) continue;
                try {
                    ftpCli.rmdir(String.valueOf(path) + "/" + file.getFilename());
                }
                catch (Exception e) {
                    this.recursiveFolderDelete(String.valueOf(path) + "/" + file.getFilename(), ftpCli);
                }
            }
            ftpCli.rmdir(path);
        }
        catch (SftpException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void executeCommand(ChannelSftp ftpCli, String localPath, boolean verbose, FtpCommandHandler commandHandler, List<FtpStatisticListener> statisticsListeners) throws IOException, FtpCommandException {
        String remoteSource = FtpUtils.removeFirstAndLastQuotes(this.getParameters()[0]);
        String replyString = Messages.getString("SFtpCommand_RMDIR.0");
        String filePath = remoteSource;
        try {
            Vector fileList = ftpCli.ls(filePath);
            for (ChannelSftp.LsEntry file : fileList) {
                if (!file.getAttrs().isDir()) {
                    ftpCli.rm(String.valueOf(filePath) + "/" + file.getFilename());
                    continue;
                }
                if (".".equals(file.getFilename()) || "..".equals(file.getFilename())) continue;
                try {
                    ftpCli.rmdir(String.valueOf(filePath) + "/" + file.getFilename());
                }
                catch (Exception e) {
                    this.recursiveFolderDelete(String.valueOf(filePath) + "/" + file.getFilename(), ftpCli);
                }
            }
            ftpCli.rmdir(remoteSource);
            if (verbose) {
                commandHandler.handleResponse(replyString);
            }
        }
        catch (SftpException e) {
            FtpCommandException ftpCommandException = new FtpCommandException(e.getMessage());
            commandHandler.handleError("", ftpCommandException);
        }
    }
}

