/*
 * Decompiled with CFR 0.152.
 */
package com.indy.a;

import com.indy.a.Messages;
import com.indy.a.encryptors.AsymetricEncryptor;
import com.indy.a.encryptors.FileEncryptor;
import com.indy.a.encryptors.SymetricEncryptor;
import com.indy.engine.core.objects.data.baseobjects.StringOperations;
import com.indy.engine.shared.passwordmanagement.IPasswordManagerDelegate;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.semarchy.xdi.engine.common.exceptions.OtherExceptionI;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import javax.crypto.SecretKey;

public class PasswordManagerI
implements IPasswordManagerDelegate {
    FileEncryptor encryptor = null;
    InputStream inputKeyStream = null;
    public static PasswordManagerI a = new PasswordManagerI("612E6F6C64");
    public static PasswordManagerI b = new PasswordManagerI("622E6F6C64");
    public static PasswordManagerI c = a;

    public PasswordManagerI(String keyFileName) {
        this.inputKeyStream = this.getClass().getResourceAsStream(new String(StringOperations.hexStringToArrayByte((String)keyFileName)));
        try {
            this.encryptor = new SymetricEncryptor(this.inputKeyStream);
        }
        catch (OtherExceptionI e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        KeyStore ks = KeyStore.getInstance("JCEKS");
        FileInputStream fis = new FileInputStream("C:\\Apps\\java\\1.8.0_144_jdk_64\\jre\\lib\\security\\myKeyStore.jks");
        ks.load(fis, "mystorepass".toCharArray());
        ((InputStream)fis).close();
        PasswordManagerI pm = new PasswordManagerI(ks, "128bitkey (t)", "mystorepass", "PCBC/PKCS5Padding");
        String totot = pm.decryptPassword("A69F0D6731F7E3DE38C780AE6D260E73A3AE9E07ADDB3C7F15D3F87A892423FF");
        System.out.println(totot);
    }

    public PasswordManagerI(KeyStore ks, String alias, String password, String blockCipherModeOperation) throws OtherExceptionI, EngineExceptionI {
        if (alias == null) {
            throw new EngineExceptionI(Messages.getString("PasswordManagerI.0"));
        }
        if (password == null) {
            throw new EngineExceptionI(Messages.getString("PasswordManagerI.1"));
        }
        try {
            Key key = ks.getKey(alias, password.toCharArray());
            if (key instanceof PrivateKey) {
                Certificate certificate = ks.getCertificate(alias);
                this.encryptor = new AsymetricEncryptor(certificate, (PrivateKey)key);
            } else {
                if (key == null) {
                    throw new EngineExceptionI(Messages.getString("PasswordManagerI.2"));
                }
                if (!(key instanceof SecretKey)) {
                    throw new EngineExceptionI(Messages.getString("PasswordManagerI.3"));
                }
                this.encryptor = new SymetricEncryptor((SecretKey)key);
            }
            if (blockCipherModeOperation != null) {
                this.encryptor.setBlockCipherModeOperation(blockCipherModeOperation);
            }
        }
        catch (Exception e) {
            throw new EngineExceptionI(e.getMessage());
        }
    }

    public byte[] encryptInputArrayByte(byte[] in) throws OtherExceptionI {
        return this.encryptor.encryptBytes(in);
    }

    public byte[] decryptInputArrayByte(byte[] in) throws OtherExceptionI {
        return this.encryptor.decryptBytes(in);
    }

    public void encryptInputStream(InputStream in, OutputStream out) throws OtherExceptionI {
        this.encryptor.encryptStreamNC(in, out);
    }

    public void decryptInputStream(InputStream in, OutputStream out) throws OtherExceptionI {
        this.encryptor.decryptStreamNC(in, out);
    }

    public String encryptPassword(String pass, Charset charset) throws OtherExceptionI {
        String ret = null;
        byte[] b1 = this.encryptor.encryptBytes(pass.getBytes(charset));
        ret = this.encryptor.arrayByteToHexString(b1);
        return ret;
    }

    public String encryptPassword(String pass) throws OtherExceptionI {
        return this.encryptPassword(pass, Charset.forName("UTF-8"));
    }

    public String encryptPassword(String pass, String charset) throws OtherExceptionI {
        Charset cset = Charset.forName(charset);
        return this.encryptPassword(pass, cset);
    }

    public String decryptPassword(String pass, Charset charset) throws OtherExceptionI {
        String ret = null;
        byte[] b2 = this.encryptor.decryptBytes(this.encryptor.hexStringToArrayByte(pass));
        ret = new String(b2, charset);
        return ret;
    }

    public String decryptPassword(String pass) throws OtherExceptionI {
        return this.decryptPassword(pass, Charset.forName("UTF-8"));
    }

    public String decryptPassword(String pass, String charset) throws OtherExceptionI {
        Charset cset = Charset.forName(charset);
        return this.decryptPassword(pass, cset);
    }

    public static String getMD5EncodedPassword(String key) throws OtherExceptionI {
        byte[] uniqueKey = key.getBytes();
        byte[] hash = null;
        try {
            hash = MessageDigest.getInstance("MD5").digest(uniqueKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OtherExceptionI(Messages.getString("PasswordManagerI.4"));
        }
        StringBuffer hashString = new StringBuffer();
        int i = 0;
        while (i < hash.length) {
            String hex = Integer.toHexString(hash[i]);
            if (hex.length() == 1) {
                hashString.append('0');
                hashString.append(hex.charAt(hex.length() - 1));
            } else {
                hashString.append(hex.substring(hex.length() - 2));
            }
            ++i;
        }
        return hashString.toString();
    }

    public static boolean testMD5Password(String clearTextTestPassword, String encodedActualPassword) throws OtherExceptionI {
        String encodedTestPassword = PasswordManagerI.getMD5EncodedPassword(clearTextTestPassword);
        return encodedTestPassword.equals(encodedActualPassword);
    }
}

