/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.client.rest;

import com.indy.engine.common.client.rest.JsonDecoder;
import com.indy.engine.core.rest.dto.schedule.PurgeRulesDto;
import com.indy.engine.core.rest.dto.schedule.ScheduleDto;
import com.indy.engine.core.rest.dto.schedule.TriggerDto;
import com.indy.engine.core.security.PrivilegeAnnotation;
import com.indy.engine.core.security.Role;
import feign.Feign;
import feign.Param;
import feign.RequestInterceptor;
import feign.RequestLine;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import java.util.List;

public interface IScheduleApi {
    @RequestLine(value="GET /schedule/trigger")
    @PrivilegeAnnotation(role=Role.View)
    public List<String> getLstTriggers() throws Exception;

    @RequestLine(value="GET /schedule/trigger/{triggerName}")
    @PrivilegeAnnotation(role=Role.View)
    public ScheduleDto getTriggerDetail(@Param(value="triggerName") String var1) throws Exception;

    @RequestLine(value="GET /schedule?deliveryName={deliveryName}", decodeSlash=false)
    @PrivilegeAnnotation(role=Role.View)
    public List<ScheduleDto> getLstSchedules(@Param(value="deliveryName") String var1) throws Exception;

    @RequestLine(value="DELETE /schedule/trigger/{triggerName}")
    @PrivilegeAnnotation(role=Role.Admin)
    public int removeJobTrigger(@Param(value="triggerName") String var1) throws Exception;

    @RequestLine(value="PUT /schedule/trigger")
    @PrivilegeAnnotation(role=Role.Admin)
    public void updateTrigger(TriggerDto var1) throws Exception;

    @RequestLine(value="POST /schedule")
    @PrivilegeAnnotation(role=Role.Admin)
    public ScheduleDto scheduleLogsPurge(String var1, List<ScheduleDto> var2, PurgeRulesDto var3) throws Exception;

    @RequestLine(value="POST /schedule")
    @PrivilegeAnnotation(role=Role.Admin)
    public ScheduleDto scheduleDelivery(ScheduleDto var1) throws Exception;

    public static IScheduleApi call(String url) {
        return (IScheduleApi)Feign.builder().decoder((Decoder)new JsonDecoder()).target(IScheduleApi.class, url);
    }

    public static IScheduleApi call(String url, String username, String password) {
        return (IScheduleApi)Feign.builder().decoder((Decoder)new JsonDecoder()).requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor(username, password)).target(IScheduleApi.class, url);
    }
}

