/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.delivery;

import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import com.indy.a.PasswordManagerI;
import com.indy.engine.common.delivery.DeliveryBuilderUtil;
import com.indy.engine.common.delivery.Messages;
import com.indy.engine.shared.certification.IDeliveryChecksumCertifier;
import com.semarchy.xdi.engine.common.DeliveryChecksumCertifier;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class DeliveryBuilder {
    Map<String, Integer> indexes = new HashMap<String, Integer>();
    Map<Integer, String> propNames = new HashMap<Integer, String>();
    Map<Integer, String> indexesValues = new HashMap<Integer, String>();
    String regex;
    private BUILD_MODE mode;
    private List<String> confs;
    Map<String, Map<String, String>> values;
    private String id;
    private String author;
    private String version;
    private String description;
    private Date buildDate;
    private Throwable exception;
    boolean build = false;
    private String checksum;
    String currentData;
    String currentDataTransform;

    public static Properties readDeliveryConf(InputStream inputStream, String encoding) throws Exception {
        Properties p = new Properties();
        try (BufferedReader br = null;){
            br = new BufferedReader(new InputStreamReader(inputStream, encoding));
            String line = null;
            while ((line = br.readLine()) != null) {
                int index;
                if (line.startsWith("#") || (index = line.indexOf("=")) == -1) continue;
                String propName = line.substring(0, index);
                String propValue = index + 1 < line.length() ? line.substring(index + 1) : "";
                p.setProperty(propName, propValue);
            }
        }
        return p;
    }

    public DeliveryBuilder(String conf) {
        this.mode = BUILD_MODE.AUTO;
        this.confs = new ArrayList<String>();
        this.confs.add(conf);
    }

    public DeliveryBuilder(String id, String author, String version, String description, Map<String, Map<String, String>> values, List<String> confs) {
        this(id, author, version, description, values, confs, new Date());
    }

    public DeliveryBuilder(String id, String author, String version, String description, Map<String, Map<String, String>> values, List<String> confs, Date buildDate) {
        this.values = values;
        this.confs = confs;
        this.mode = confs.size() > 1 ? BUILD_MODE.MULTI : BUILD_MODE.MONO;
        this.id = id;
        this.author = author;
        this.version = version;
        this.description = description;
        this.buildDate = buildDate;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void build(File packageFile, OutputStream os, String deliveryName) throws FactoryConfigurationError, Exception {
        ZipFile zf = null;
        InputStream is = null;
        try {
            try {
                String entryName = String.valueOf(deliveryName) + ".deliv";
                zf = new ZipFile(packageFile);
                ZipEntry entry = null;
                Enumeration<? extends ZipEntry> enu = zf.entries();
                while (enu.hasMoreElements()) {
                    ZipEntry _entry = enu.nextElement();
                    String name = _entry.getName();
                    if (name.contains("/") || !name.equals(entryName)) continue;
                    entry = _entry;
                    break;
                }
                if (entry == null) {
                    throw new Exception(String.valueOf(Messages.getString("DeliveryBuilder.0")) + deliveryName + Messages.getString("DeliveryBuilder.1") + packageFile.getAbsolutePath());
                }
                is = zf.getInputStream(entry);
                this.build(is, os);
            }
            catch (ZipException e) {
                e.printStackTrace();
                if (zf != null) {
                    zf.close();
                }
                if (is != null) {
                    is.close();
                }
            }
        }
        finally {
            if (zf != null) {
                zf.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    public InputStream pipedBuild(final InputStream is) throws IOException {
        PipedInputStream in = new PipedInputStream(){

            @Override
            public synchronized int available() throws IOException {
                if (DeliveryBuilder.this.exception != null) {
                    throw new IOException(DeliveryBuilder.this.exception);
                }
                return super.available();
            }

            @Override
            protected synchronized void receive(int b) throws IOException {
                if (DeliveryBuilder.this.exception != null) {
                    throw new IOException(DeliveryBuilder.this.exception);
                }
                super.receive(b);
            }

            @Override
            public synchronized int read() throws IOException {
                if (DeliveryBuilder.this.exception != null) {
                    throw new IOException(DeliveryBuilder.this.exception);
                }
                return super.read();
            }

            @Override
            public synchronized int read(byte[] b, int off, int len) throws IOException {
                if (DeliveryBuilder.this.exception != null) {
                    throw new IOException(DeliveryBuilder.this.exception);
                }
                return super.read(b, off, len);
            }
        };
        final PipedOutputStream out = new PipedOutputStream(in);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        DeliveryBuilder.this.build(is, out);
                    }
                    catch (Throwable t) {
                        DeliveryBuilder.this.exception = t;
                        try {
                            is.close();
                            out.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                finally {
                    try {
                        is.close();
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        t.setName("DeliveryBuilder piped thread");
        t.start();
        return in;
    }

    public String getChecksum() {
        return this.checksum;
    }

    private void writeAll(XMLEventReader reader, XMLEventWriter writer) throws XMLStreamException {
        while (reader.hasNext()) {
            writer.add((XMLEvent)reader.next());
        }
    }

    public void build(InputStream is, OutputStream _os) throws FactoryConfigurationError, Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XMLEventWriter writer = null;
        try (XMLEventReader reader = null;){
            WstxInputFactory xif = new WstxInputFactory();
            reader = xif.createXMLEventReader(is, "UTF-8");
            writer = new WstxOutputFactory().createXMLEventWriter((OutputStream)os, "UTF-8");
            String path = "";
            String currentNodeId = null;
            String currentConf = null;
            String currentPropertyId = null;
            String currentIndex = null;
            final HashMap<String, Integer> confIndex = new HashMap<String, Integer>();
            while (reader.hasNext()) {
                Attribute attr;
                StartElement start;
                XMLEvent event = (XMLEvent)reader.next();
                if (event.isStartElement()) {
                    start = event.asStartElement();
                    QName name = start.getName();
                    if ((path = String.valueOf(path) + "/" + name.getLocalPart()).equals("/delivery")) {
                        Attribute attr2 = start.getAttributeByName(new QName("externalized"));
                        Attribute conf = start.getAttributeByName(new QName("configurationCode"));
                        if (attr2 == null || attr2.getValue() != null && attr2.getValue().equals("false")) {
                            if (conf != null && conf.getValue() != null && this.confs.size() == 1 && this.confs.get(0) != null && !this.confs.get(0).equals(conf.getValue())) {
                                throw new RuntimeException(String.valueOf(Messages.getString("DeliveryBuilder.2")) + this.confs.get(0) + Messages.getString("DeliveryBuilder.3") + conf.getValue() + Messages.getString("DeliveryBuilder.4"));
                            }
                            writer.add(event);
                            this.writeAll(reader, writer);
                            break;
                        }
                        attr2 = start.getAttributeByName(new QName("regex"));
                        String string = this.regex = attr2 != null ? attr2.getValue() : null;
                        if (conf != null && conf.getValue() != null) {
                            int i = 0;
                            String[] stringArray = conf.getValue().split(" ");
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String str = stringArray[n2];
                                confIndex.put(str, i++);
                                ++n2;
                            }
                        }
                    }
                }
                if (path.equals("/delivery")) {
                    if (event.isStartElement()) {
                        event = new StartElementWrapper(this, event.asStartElement()){

                            @Override
                            protected Attribute wrappedAttribute(Attribute attr) {
                                DeliveryBuilder deliveryBuilder = this;
                                deliveryBuilder.getClass();
                                return new AttributeWrapper(deliveryBuilder, attr){

                                    @Override
                                    public String getValue() {
                                        String name = this.attr.getName().getLocalPart();
                                        if (name.equals("id") && (mode == BUILD_MODE.MONO || mode == BUILD_MODE.MULTI)) {
                                            return id;
                                        }
                                        if (name.equals("externalized")) {
                                            if (mode == BUILD_MODE.MONO || mode == BUILD_MODE.AUTO) {
                                                return "false";
                                            }
                                            if (mode == BUILD_MODE.MULTI) {
                                                return "true";
                                            }
                                        }
                                        if (name.equals("id") && mode == BUILD_MODE.AUTO) {
                                            Integer index = (Integer)confIndex.get(confs.get(0));
                                            if (index != null) {
                                                return String.valueOf(super.getValue()) + "_" + index;
                                            }
                                            return String.valueOf(super.getValue()) + "_" + (String)confs.get(0);
                                        }
                                        if (name.equals("configurationCode")) {
                                            if (mode == BUILD_MODE.AUTO) {
                                                String val = super.getValue();
                                                String[] strs = val.split(" ");
                                                if (confs.get(0) == null) {
                                                    throw new RuntimeException(String.valueOf(Messages.getString("DeliveryBuilder.5")) + val);
                                                }
                                                if (!Arrays.asList(strs).contains(confs.get(0))) {
                                                    throw new RuntimeException(String.valueOf(Messages.getString("DeliveryBuilder.6")) + (String)confs.get(0) + Messages.getString("DeliveryBuilder.7") + val + ")");
                                                }
                                                return (String)confs.get(0);
                                            }
                                            if (confs != null && confs.size() > 0) {
                                                String ret = (String)confs.get(0);
                                                int i = 1;
                                                while (i < confs.size()) {
                                                    ret = String.valueOf(ret) + " " + (String)confs.get(i);
                                                    ++i;
                                                }
                                                return ret;
                                            }
                                            return super.getValue();
                                        }
                                        return super.getValue();
                                    }
                                };
                            }
                        };
                        if (this.mode == BUILD_MODE.MONO || this.mode == BUILD_MODE.MULTI) {
                            Calendar cal = GregorianCalendar.getInstance();
                            cal.setTime(this.buildDate);
                            ((StartElementWrapper)event).addAttribute(new StaticAttribute(new QName("buildDate"), DatatypeConverter.printDateTime((Calendar)cal)));
                            if (this.author != null) {
                                ((StartElementWrapper)event).addAttribute(new StaticAttribute(new QName("buildUser"), this.author));
                            }
                            if (this.version != null) {
                                ((StartElementWrapper)event).addAttribute(new StaticAttribute(new QName("version"), this.version));
                            }
                            if (this.description != null) {
                                ((StartElementWrapper)event).addAttribute(new StaticAttribute(new QName("description"), this.description));
                            }
                        }
                        writer.add(event);
                    } else {
                        writer.add(event);
                    }
                } else if (path.equals("/delivery/externalize")) {
                    if (this.mode == BUILD_MODE.MULTI) {
                        writer.add(event);
                    }
                    if (event.isStartElement()) {
                        start = event.asStartElement();
                        attr = start.getAttributeByName(new QName("nodeId"));
                        currentNodeId = attr != null ? attr.getValue() : null;
                    }
                } else if (path.equals("/delivery/externalize/property")) {
                    Object index;
                    StartElement se;
                    if (event.isStartElement()) {
                        se = event.asStartElement();
                        Attribute xmlName = se.getAttributeByName(new QName("xmlName"));
                        if (xmlName != null && xmlName.getValue() != null) {
                            currentPropertyId = String.valueOf(currentNodeId) + "/@" + xmlName.getValue();
                        }
                        if ((index = se.getAttributeByName(new QName("index"))) != null) {
                            currentIndex = index.getValue();
                        }
                    } else if (event.isEndElement()) {
                        currentPropertyId = null;
                        currentIndex = null;
                    }
                    if (this.mode == BUILD_MODE.MULTI) {
                        writer.add(event);
                        if (event.isStartElement()) {
                            se = event.asStartElement();
                            if (currentPropertyId != null) {
                                index = this.values.keySet().iterator();
                                while (index.hasNext()) {
                                    String value;
                                    String conf = (String)index.next();
                                    Map<String, String> map = this.values.get(conf);
                                    if (map != null && (value = map.get(currentPropertyId)) != null) {
                                        StaticStartElement sse = new StaticStartElement(new QName("conf"), event.asStartElement());
                                        StaticAttribute attr3 = new StaticAttribute(new QName("code"), conf);
                                        sse.addAttribute(attr3);
                                        writer.add(sse);
                                        if (value != null) {
                                            StaticStartElement svalue = new StaticStartElement(new QName("value"), event.asStartElement());
                                            writer.add(svalue);
                                            writer.add(new StaticCharacters(value));
                                            writer.add(new StaticEndElement(new QName("value"), se));
                                        }
                                    }
                                    writer.add(new StaticEndElement(new QName("conf"), se));
                                }
                            }
                        }
                    } else if (this.mode == BUILD_MODE.MONO && currentNodeId != null && event.isStartElement() && currentPropertyId != null && currentIndex != null) {
                        this.indexes.put(currentPropertyId, Integer.valueOf(currentIndex));
                        this.propNames.put(Integer.valueOf(currentIndex), currentPropertyId);
                    }
                } else if (path.equals("/delivery/externalize/property/conf")) {
                    if (this.mode == BUILD_MODE.AUTO) {
                        if (event.isStartElement()) {
                            currentConf = event.asStartElement().getAttributeByName(new QName("code")).getValue();
                        } else if (event.isEndElement()) {
                            currentConf = null;
                        }
                    } else {
                        writer.add(event);
                    }
                } else if (path.equals("/delivery/externalize/property/conf/value")) {
                    if (this.mode == BUILD_MODE.AUTO && currentConf != null && this.confs.size() == 1 && this.confs.get(0).equals(currentConf) && event.isCharacters()) {
                        this.indexesValues.put(Integer.valueOf(currentIndex), event.asCharacters().getData());
                    }
                } else if (path.startsWith("/delivery/connection") || path.startsWith("/delivery/process") || path.startsWith("/delivery/parameter") || path.startsWith("/delivery/metaData")) {
                    if (this.mode != BUILD_MODE.MULTI) {
                        if ((this.mode == BUILD_MODE.MONO || this.mode == BUILD_MODE.AUTO) && this.indexes.size() > 0 && this.indexesValues.size() == 0) {
                            for (String key : this.indexes.keySet()) {
                                String str = this.values.get(this.confs.get(0)).get(key);
                                if (str == null) continue;
                                this.indexesValues.put(this.indexes.get(key), str);
                            }
                        }
                        if (event.isStartElement()) {
                            boolean checkSum = false;
                            if (path.equals("/delivery/process/step/parameter") && (attr = event.asStartElement().getAttributeByName(new QName("vName"))) != null && attr.getValue().equals("CERTIFICATION_CHECKSUM")) {
                                checkSum = true;
                                StaticStartElement sse = new StaticStartElement(new QName("parameter"), event.asStartElement());
                                Iterator<Attribute> it = event.asStartElement().getAttributes();
                                while (it.hasNext()) {
                                    Attribute _attr = it.next();
                                    if (_attr.getName().equals(new QName("value"))) {
                                        String value = _attr.getValue();
                                        IDeliveryChecksumCertifier certifierChecksumHelper = DeliveryChecksumCertifier.getChecksumHelper(PasswordManagerI.b);
                                        if (this.currentDataTransform != null && this.currentData != null && !this.currentData.equals(this.currentDataTransform)) {
                                            String currentCheckSum = certifierChecksumHelper.generateCertifiedCheckSum(this.currentData.replace("\r", "").replace("\n", ""), true);
                                            if (currentCheckSum.equals(value)) {
                                                value = certifierChecksumHelper.generateCertifiedCheckSum(this.currentDataTransform.replace("\r", "").replace("\n", ""), true);
                                            }
                                        } else {
                                            value = this.transform(value);
                                        }
                                        StaticAttribute __attr = new StaticAttribute(new QName("value"), value);
                                        sse.addAttribute(__attr);
                                        continue;
                                    }
                                    sse.addAttribute(_attr);
                                }
                                event = sse;
                            }
                            if (!checkSum) {
                                event = new StartElementWrapper(this, event.asStartElement()){

                                    @Override
                                    protected Attribute wrappedAttribute(Attribute attr) {
                                        DeliveryBuilder deliveryBuilder = this;
                                        deliveryBuilder.getClass();
                                        return new AttributeWrapper(deliveryBuilder, attr){

                                            @Override
                                            public String getValue() {
                                                return this.transform(super.getValue());
                                            }
                                        };
                                    }
                                };
                            }
                        }
                        if (event.isCharacters()) {
                            event = new CharactersWrapper(this, event.asCharacters()){

                                @Override
                                public String getData() {
                                    currentData = this.characters.getData();
                                    currentDataTransform = this.transform(currentData);
                                    return currentDataTransform;
                                }

                                @Override
                                public boolean isCData() {
                                    return true;
                                }
                            };
                        }
                    }
                    writer.add(event);
                } else {
                    writer.add(event);
                }
                if (!event.isEndElement()) continue;
                if (path.equals("/delivery/process/step")) {
                    this.currentDataTransform = null;
                    this.currentData = null;
                }
                path = path.substring(0, path.lastIndexOf("/"));
            }
        }
        if (writer != null) {
            writer.close();
        }
        ByteArrayInputStream _is = new ByteArrayInputStream(os.toByteArray());
        this.checksum = DeliveryBuilderUtil.computeChecksum(_is);
        if (_os != null) {
            _is.reset();
            this.injectCheckSum(_is, _os, this.checksum);
        }
    }

    void injectCheckSum(InputStream is, OutputStream os, String checkSum) throws XMLStreamException {
        XMLEventWriter writer = null;
        try (XMLEventReader reader = null;){
            WstxInputFactory xif = new WstxInputFactory();
            reader = xif.createXMLEventReader(is, "UTF-8");
            writer = new WstxOutputFactory().createXMLEventWriter(os, "UTF-8");
            StartElementWrapper first = null;
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (first == null && event.isStartElement()) {
                    first = new StartElementWrapper(this, event.asStartElement()){

                        @Override
                        protected Attribute wrappedAttribute(Attribute attr) {
                            if (attr.getName().getLocalPart().equals("checksum") || attr.getName().getLocalPart().equals("checksumVersion")) {
                                return null;
                            }
                            return attr;
                        }
                    };
                    ((StartElementWrapper)first).addAttribute(new StaticAttribute(new QName("checksum"), checkSum));
                    ((StartElementWrapper)first).addAttribute(new StaticAttribute(new QName("checksumVersion"), "1"));
                    writer.add(first);
                    continue;
                }
                writer.add(event);
            }
        }
        if (writer != null) {
            writer.close();
        }
    }

    public static void main(String[] args) throws FactoryConfigurationError, Exception {
        HashMap<String, Map<String, String>> values = new HashMap<String, Map<String, String>>();
        HashMap<String, String> parent = new HashMap<String, String>();
        values.put("parent", parent);
        parent.put("_Zu7uwOKpEeC2dMkxNFx88Q/@TABLE_SCHEM", "MOTEL");
        parent.put("yfDywOKkEeCpvv5InD1jdg/@path", "C:\\Stambia\\stambiaRuntime\\samples\\files");
        HashMap<String, String> child = new HashMap<String, String>();
        child.put("_86ngwOKmEeCpvv5InD1jdg/@user", "sa2");
        child.put("86ngwOKmEeCpvv5InD1jdg/@password", "3951C0D79B227B95C1DC348DD0BCE8F1");
        child.put("M5UegOK6EeC2dMkxNFx88Q/@TABLE_NAME", "DIM_TIME");
        child.put("86ngwOKmEeCpvv5InD1jdg/@url", "jdbc:hsqldb:hsql://localhost:62210");
        child.put("tUh3gOK4EeC2dMkxNFx88Q/@password", "3951C0D79B227B95C1DC348DD0BCE8F1");
        child.put("tUh3gOK4EeC2dMkxNFx88Q/@user", "sa");
        child.put("tUh3gOK4EeC2dMkxNFx88Q/@url", "jdbc:hsqldb:hsql://localhost:62211");
        child.put("tXoO0OK4EeC2dMkxNFx88Q/@TABLE_SCHEM", "DATAMART");
        values.put("child", child);
        ArrayList<String> confs = new ArrayList<String>();
        confs.add("child");
        DeliveryBuilder db = new DeliveryBuilder("_7o3xYWsiEeiJfcWW4wUSIg", "", "Version", "desc", values, confs, new Date());
        db.build(new FileInputStream("D:\\work\\stambiaRuntime\\build\\packages\\Alim\\Alim all DataMart.deliv"), new FileOutputStream("D:\\work\\stambiaRuntime\\build\\packages\\Alim\\Alim all DataMart2.deliv"));
        String str = "D:\\work\\stambiaRuntime\\build\\deliveries\\Load All Datamart.deliv";
        String str2 = "D:\\work\\stambiaRuntime\\build\\deliveries\\Load All Datamart_result.deliv";
        FileInputStream fis = new FileInputStream(str);
        DeliveryBuilderUtil.TextualDelivery td = DeliveryBuilderUtil.getTextualDelivery(fis);
        System.out.println(td.getText());
        FileOutputStream fos = new FileOutputStream(str2);
        DeliveryBuilder db2 = new DeliveryBuilder(null);
        db2.build(fis, fos);
    }

    String transform(String str) {
        if (this.mode == BUILD_MODE.MONO || this.mode == BUILD_MODE.AUTO) {
            Pattern p = Pattern.compile(this.regex);
            Matcher m = p.matcher(str);
            StringBuffer sb = new StringBuffer();
            int last = 0;
            while (m.find()) {
                int start = m.start();
                String _start = str.substring(last, start);
                sb.append(_start);
                String grp1 = m.group(1);
                String grp2 = m.group(2);
                if (grp2 != null) {
                    int i = Integer.valueOf(grp2);
                    String replace = this.indexesValues.get(i);
                    if (replace == null) {
                        String propName = this.propNames.get(i);
                        if (propName == null) {
                            throw new RuntimeException(String.format(Messages.getString("DeliveryBuilder.8"), this.regex.replace("([0-9]+)", String.valueOf(i)).replace("(", "").replace(")", "")));
                        }
                        throw new RuntimeException(String.valueOf(Messages.getString("DeliveryBuilder.9")) + this.propNames.get(i).replace("/@", "/"));
                    }
                    sb.append(replace);
                }
                last = m.end();
                grp1 = null;
            }
            if (last < str.length()) {
                sb.append(str.substring(last));
            }
            return sb.toString();
        }
        return str;
    }

    class AbstractXMLEvent
    implements XMLEvent {
        AbstractXMLEvent() {
        }

        @Override
        public StartElement asStartElement() {
            return null;
        }

        @Override
        public EndElement asEndElement() {
            return null;
        }

        @Override
        public Characters asCharacters() {
            return null;
        }

        @Override
        public boolean isAttribute() {
            return false;
        }

        @Override
        public boolean isCharacters() {
            return false;
        }

        @Override
        public boolean isEndDocument() {
            return false;
        }

        @Override
        public boolean isEndElement() {
            return false;
        }

        @Override
        public boolean isEntityReference() {
            return false;
        }

        @Override
        public boolean isNamespace() {
            return false;
        }

        @Override
        public boolean isProcessingInstruction() {
            return false;
        }

        @Override
        public boolean isStartDocument() {
            return false;
        }

        @Override
        public boolean isStartElement() {
            return false;
        }

        @Override
        public int getEventType() {
            if (this.isStartDocument()) {
                return 7;
            }
            if (this.isStartElement()) {
                return 1;
            }
            if (this.isAttribute()) {
                return 10;
            }
            if (this.isCharacters()) {
                return 4;
            }
            if (this.isEndElement()) {
                return 2;
            }
            if (this.isEndDocument()) {
                return 8;
            }
            if (this.isEntityReference()) {
                return 9;
            }
            if (this.isNamespace()) {
                return 13;
            }
            if (this.isProcessingInstruction()) {
                return 3;
            }
            return 0;
        }

        @Override
        public Location getLocation() {
            return null;
        }

        @Override
        public QName getSchemaType() {
            return null;
        }

        @Override
        public void writeAsEncodedUnicode(Writer paramWriter) throws XMLStreamException {
        }
    }

    class AttributeWrapper
    implements Attribute {
        Attribute attr;

        public AttributeWrapper(Attribute attr) {
            this.attr = attr;
        }

        @Override
        public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
            this.attr.writeAsEncodedUnicode(writer);
        }

        @Override
        public boolean isStartElement() {
            return this.attr.isStartElement();
        }

        @Override
        public boolean isStartDocument() {
            return this.attr.isStartDocument();
        }

        @Override
        public boolean isProcessingInstruction() {
            return this.attr.isProcessingInstruction();
        }

        @Override
        public boolean isNamespace() {
            return this.attr.isNamespace();
        }

        @Override
        public boolean isEntityReference() {
            return this.attr.isEntityReference();
        }

        @Override
        public boolean isEndElement() {
            return this.attr.isEndElement();
        }

        @Override
        public boolean isEndDocument() {
            return this.attr.isEndDocument();
        }

        @Override
        public boolean isCharacters() {
            return this.attr.isCharacters();
        }

        @Override
        public boolean isAttribute() {
            return this.attr.isAttribute();
        }

        @Override
        public QName getSchemaType() {
            return this.attr.getSchemaType();
        }

        @Override
        public Location getLocation() {
            return this.attr.getLocation();
        }

        @Override
        public int getEventType() {
            return this.attr.getEventType();
        }

        @Override
        public StartElement asStartElement() {
            return this.attr.asStartElement();
        }

        @Override
        public EndElement asEndElement() {
            return this.attr.asEndElement();
        }

        @Override
        public Characters asCharacters() {
            return this.attr.asCharacters();
        }

        @Override
        public boolean isSpecified() {
            return this.attr.isSpecified();
        }

        @Override
        public String getValue() {
            return this.attr.getValue();
        }

        @Override
        public QName getName() {
            return this.attr.getName();
        }

        @Override
        public String getDTDType() {
            return this.attr.getDTDType();
        }
    }

    public static enum BUILD_MODE {
        MONO,
        MULTI,
        AUTO;

    }

    class CharactersWrapper
    implements Characters {
        Characters characters;

        public CharactersWrapper(Characters asCharacters) {
            this.characters = asCharacters;
        }

        @Override
        public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
            this.characters.writeAsEncodedUnicode(writer);
        }

        @Override
        public boolean isStartElement() {
            return this.characters.isStartElement();
        }

        @Override
        public boolean isStartDocument() {
            return this.characters.isStartDocument();
        }

        @Override
        public boolean isProcessingInstruction() {
            return this.characters.isProcessingInstruction();
        }

        @Override
        public boolean isNamespace() {
            return this.characters.isNamespace();
        }

        @Override
        public boolean isEntityReference() {
            return this.characters.isEntityReference();
        }

        @Override
        public boolean isEndElement() {
            return this.characters.isEndElement();
        }

        @Override
        public boolean isEndDocument() {
            return this.characters.isEndDocument();
        }

        @Override
        public boolean isCharacters() {
            return this.characters.isCharacters();
        }

        @Override
        public boolean isAttribute() {
            return this.characters.isAttribute();
        }

        @Override
        public QName getSchemaType() {
            return this.characters.getSchemaType();
        }

        @Override
        public Location getLocation() {
            return this.characters.getLocation();
        }

        @Override
        public int getEventType() {
            return this.characters.getEventType();
        }

        @Override
        public StartElement asStartElement() {
            return this.characters.asStartElement();
        }

        @Override
        public EndElement asEndElement() {
            return this.characters.asEndElement();
        }

        @Override
        public Characters asCharacters() {
            return this;
        }

        @Override
        public String getData() {
            return this.characters.getData();
        }

        @Override
        public boolean isCData() {
            return this.characters.isCData();
        }

        @Override
        public boolean isIgnorableWhiteSpace() {
            return this.characters.isIgnorableWhiteSpace();
        }

        @Override
        public boolean isWhiteSpace() {
            return this.characters.isWhiteSpace();
        }
    }

    abstract class StartElementWrapper
    implements StartElement {
        StartElement start;
        List<Attribute> list = new ArrayList<Attribute>();

        public StartElementWrapper(StartElement start) {
            this.start = start;
            Iterator<Attribute> it = start.getAttributes();
            while (it.hasNext()) {
                Attribute attr = it.next();
                if ((attr = this.wrappedAttribute(attr)) == null) continue;
                this.list.add(attr);
            }
        }

        public void addAttribute(Attribute attr) {
            this.list.add(attr);
        }

        protected abstract Attribute wrappedAttribute(Attribute var1);

        @Override
        public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
            this.start.writeAsEncodedUnicode(writer);
        }

        @Override
        public boolean isStartElement() {
            return this.start.isStartElement();
        }

        @Override
        public boolean isStartDocument() {
            return this.start.isStartDocument();
        }

        @Override
        public boolean isProcessingInstruction() {
            return this.start.isProcessingInstruction();
        }

        @Override
        public boolean isNamespace() {
            return this.start.isNamespace();
        }

        @Override
        public boolean isEntityReference() {
            return this.start.isEntityReference();
        }

        @Override
        public boolean isEndElement() {
            return this.start.isEndElement();
        }

        @Override
        public boolean isEndDocument() {
            return this.start.isEndDocument();
        }

        @Override
        public boolean isCharacters() {
            return this.start.isCharacters();
        }

        @Override
        public boolean isAttribute() {
            return this.start.isAttribute();
        }

        @Override
        public QName getSchemaType() {
            return this.start.getSchemaType();
        }

        @Override
        public Location getLocation() {
            return this.start.getLocation();
        }

        @Override
        public int getEventType() {
            return this.start.getEventType();
        }

        @Override
        public StartElement asStartElement() {
            return this;
        }

        @Override
        public EndElement asEndElement() {
            return this.start.asEndElement();
        }

        @Override
        public Characters asCharacters() {
            return this.start.asCharacters();
        }

        public Iterator getNamespaces() {
            return this.start.getNamespaces();
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.start.getNamespaceURI(prefix);
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return this.start.getNamespaceContext();
        }

        @Override
        public QName getName() {
            return this.start.getName();
        }

        public Iterator getAttributes() {
            return this.list.iterator();
        }

        @Override
        public Attribute getAttributeByName(QName name) {
            return this.start.getAttributeByName(name);
        }
    }

    class StaticAttribute
    implements Attribute {
        private QName name;
        private String value;

        @Override
        public Characters asCharacters() {
            return null;
        }

        @Override
        public EndElement asEndElement() {
            return null;
        }

        @Override
        public StartElement asStartElement() {
            return null;
        }

        @Override
        public int getEventType() {
            return 10;
        }

        @Override
        public Location getLocation() {
            return null;
        }

        @Override
        public QName getSchemaType() {
            return null;
        }

        @Override
        public boolean isAttribute() {
            return true;
        }

        @Override
        public boolean isCharacters() {
            return false;
        }

        @Override
        public boolean isEndDocument() {
            return false;
        }

        @Override
        public boolean isEndElement() {
            return false;
        }

        @Override
        public boolean isEntityReference() {
            return false;
        }

        @Override
        public boolean isNamespace() {
            return false;
        }

        @Override
        public boolean isProcessingInstruction() {
            return false;
        }

        @Override
        public boolean isStartDocument() {
            return false;
        }

        @Override
        public boolean isStartElement() {
            return false;
        }

        @Override
        public void writeAsEncodedUnicode(Writer arg0) throws XMLStreamException {
        }

        @Override
        public String getDTDType() {
            return null;
        }

        @Override
        public QName getName() {
            return this.name;
        }

        public StaticAttribute(QName name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isSpecified() {
            return false;
        }
    }

    class StaticCharacters
    extends AbstractXMLEvent
    implements Characters {
        private String data;

        @Override
        public Characters asCharacters() {
            return this;
        }

        @Override
        public boolean isCharacters() {
            return true;
        }

        public StaticCharacters(String data) {
            this.data = data;
        }

        @Override
        public String getData() {
            return this.data;
        }

        @Override
        public boolean isWhiteSpace() {
            return true;
        }

        @Override
        public boolean isCData() {
            return false;
        }

        @Override
        public boolean isIgnorableWhiteSpace() {
            return false;
        }
    }

    class StaticEndElement
    extends AbstractXMLEvent
    implements EndElement {
        QName name;
        StartElement base;

        public StaticEndElement(QName name, StartElement base) {
            this.name = name;
            this.base = base;
        }

        @Override
        public EndElement asEndElement() {
            return this;
        }

        @Override
        public boolean isEndElement() {
            return true;
        }

        @Override
        public QName getName() {
            return this.name;
        }

        public Iterator getNamespaces() {
            return this.base.getNamespaces();
        }
    }

    class StaticStartElement
    extends AbstractXMLEvent
    implements StartElement {
        QName name;
        Map<QName, Attribute> attrs;
        StartElement base;

        public void addAttribute(Attribute attr) {
            if (this.attrs == null) {
                this.attrs = new HashMap<QName, Attribute>();
            }
            this.attrs.put(attr.getName(), attr);
        }

        public StaticStartElement(QName name, StartElement base) {
            this.name = name;
            this.base = base;
        }

        @Override
        public QName getName() {
            return this.name;
        }

        @Override
        public StartElement asStartElement() {
            return this;
        }

        @Override
        public boolean isStartElement() {
            return true;
        }

        public Iterator getAttributes() {
            if (this.attrs != null) {
                return this.attrs.values().iterator();
            }
            return Collections.EMPTY_LIST.iterator();
        }

        public Iterator getNamespaces() {
            return this.base.getNamespaces();
        }

        @Override
        public Attribute getAttributeByName(QName paramQName) {
            return this.attrs.get(paramQName);
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return this.base.getNamespaceContext();
        }

        @Override
        public String getNamespaceURI(String paramString) {
            return this.base.getNamespaceURI(paramString);
        }
    }
}

