/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.keystore;

import com.indy.engine.common.keystore.Messages;
import com.semarchy.xdi.engine.common.CommonUtils;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class KeyStoreConfiguration {
    private static Logger logger = LogManager.getLogger(KeyStoreConfiguration.class);
    @XmlElement(name="keyStore")
    public static HashMap<String, KeyStoreDefinition> ksd = new HashMap();

    public static KeyStoreDefinition getKeyStoreDefinition(File file) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        try (FileInputStream is = null;){
            is = new FileInputStream(file);
            KeyStoreDefinition keyStoreDefinition = KeyStoreConfiguration.getKeyStoreDefinition(is);
            return keyStoreDefinition;
        }
    }

    public static KeyStoreDefinition getKeyStoreDefinition(InputStream is) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        return (KeyStoreDefinition)JAXB.unmarshal((InputStream)is, KeyStoreDefinition.class);
    }

    public static KeyStoreDefinition getKeyStoreDefinition(Node node) throws TransformerFactoryConfigurationError, TransformerException, IOException {
        Transformer transformer = CommonUtils.getSafeTransformer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, Charset.defaultCharset());
        transformer.transform(new DOMSource(node), new StreamResult(osw));
        osw.close();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        InputStreamReader isr = new InputStreamReader((InputStream)bais, Charset.defaultCharset());
        return (KeyStoreDefinition)JAXB.unmarshal((Reader)isr, KeyStoreDefinition.class);
    }

    public static KeyStoreDefinition getKeyStore(String string) {
        return ksd.get(string);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class KeyStoreDefinition {
        @XmlAttribute(name="path", required=true)
        private String path;
        @XmlAttribute(name="type", required=false)
        private String type;
        Map<String, Key> keyMap = null;
        boolean init = false;
        @XmlAttribute(name="password", required=false)
        private String password;
        @XmlElement(name="key")
        private List<Key> keys;

        public String getPath() {
            return this.path;
        }

        public String getPassword() {
            return this.password;
        }

        public String getType() {
            return this.type;
        }

        public Key getKey(String name) {
            return this.keyMap.get(name);
        }

        public void init() throws EngineExceptionI {
            if (!this.init) {
                this.keyMap = new HashMap<String, Key>();
                if (this.keys != null) {
                    for (Key conn : this.keys) {
                        if (conn.getName() == null) {
                            throw new EngineExceptionI(Messages.getString("KeyStoreConfiguration.0"));
                        }
                        if (conn.getAlias() == null) {
                            throw new EngineExceptionI(Messages.getString("KeyStoreConfiguration.1"));
                        }
                        if (conn.getPassword() == null) {
                            throw new EngineExceptionI(Messages.getString("KeyStoreConfiguration.2"));
                        }
                        if (ksd.containsKey(conn.getName())) {
                            throw new EngineExceptionI(String.valueOf(Messages.getString("KeyStoreConfiguration.3")) + conn.getName() + Messages.getString("KeyStoreConfiguration.4"));
                        }
                        this.keyMap.put(conn.getName(), conn);
                        ksd.put(conn.getName(), this);
                        try {
                            conn.validate();
                        }
                        catch (Exception e) {
                            throw new EngineExceptionI((Throwable)e);
                        }
                    }
                }
                this.init = true;
            }
        }

        public List<Key> getKeys() {
            return this.keys;
        }

        public KeyStore initKeyStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, EngineExceptionI {
            if (this.getPath() == null) {
                throw new EngineExceptionI(Messages.getString("KeyStoreConfiguration.5"));
            }
            if (this.getPassword() == null) {
                throw new EngineExceptionI(Messages.getString("KeyStoreConfiguration.6"));
            }
            KeyStore ks = KeyStore.getInstance(this.getType() == null ? KeyStore.getDefaultType() : this.getType());
            FileInputStream fis = new FileInputStream(this.getPath());
            ks.load(fis, this.getPassword().toCharArray());
            ((InputStream)fis).close();
            return ks;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        public static class Key {
            @XmlAttribute(name="default", required=false)
            private boolean isDefault;
            @XmlAttribute(name="name", required=true)
            private String name;
            @XmlAttribute(name="alias", required=true)
            private String alias;
            @XmlAttribute(name="password", required=false)
            private String password;
            @XmlAttribute(name="blockCipherModeOperation", required=false)
            private String blockCipherModeOperation;

            public boolean isDefault() {
                return this.isDefault;
            }

            public String getBlockCipherModeOperation() {
                return this.blockCipherModeOperation;
            }

            public void setBlockCipherModeOperation(String blockCipherModeOperation) {
                this.blockCipherModeOperation = blockCipherModeOperation;
            }

            public String getName() {
                return this.name;
            }

            void validate() throws Exception {
                KeyStore ks = KeyStoreConfiguration.getKeyStore(this.name).initKeyStore();
                if (!ks.isKeyEntry(this.alias)) {
                    throw new Exception(Messages.getString("KeyStoreConfiguration.7"));
                }
                try {
                    java.security.Key key = ks.getKey(this.alias, this.password.toCharArray());
                    Cipher.getInstance(String.valueOf(key.getAlgorithm()) + (this.blockCipherModeOperation != null && !this.blockCipherModeOperation.equals("") ? "/" + this.blockCipherModeOperation : ""));
                }
                catch (UnrecoverableKeyException e) {
                    throw new UnrecoverableKeyException(Messages.getString("KeyStoreConfiguration.8"));
                }
            }

            public String getPassword() {
                return this.password;
            }

            public String getAlias() {
                return this.alias;
            }

            public void init() {
            }
        }
    }
}

