/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.scripting;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class StbScriptEngineManager
extends ScriptEngineManager {
    static ScriptEngineFactory sunFactory;

    static {
        try {
            Class<?> clazz = Class.forName("com.sun.script.javascript.RhinoScriptEngineFactory");
            sunFactory = (ScriptEngineFactory)clazz.newInstance();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public StbScriptEngineManager(ClassLoader loader) {
        super(loader);
    }

    private StbScriptEngineManager() {
    }

    private ScriptEngine sunEmbended() {
        return sunFactory.getScriptEngine();
    }

    private ScriptEngine rhinoNonJdk() {
        ScriptEngine engine = super.getEngineByName("rhino-nonjdk");
        Bindings bindings = engine.getBindings(100);
        bindings.clear();
        try {
            engine.eval("function  println( str){print(str);};");
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        return engine;
    }

    private ScriptEngine nashornRhinoCompat() {
        ScriptEngine engine = super.getEngineByName("nashorn");
        Bindings bindings = engine.getBindings(100);
        bindings.clear();
        try {
            engine.eval("function  println( str){print(str);};load('nashorn:mozilla_compat.js')");
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        return engine;
    }

    private ScriptEngine other(String engineName) {
        ScriptEngine engine = super.getEngineByName(engineName);
        Bindings bindings = engine.getBindings(100);
        bindings.clear();
        return engine;
    }

    @Override
    public ScriptEngine getEngineByName(String engineName) {
        return this.getEngineByName(engineName, null);
    }

    public ScriptEngine getEngineByName(String engineName, ClassLoader cl) {
        ClassLoader cl2 = null;
        try {
            if (cl != null) {
                cl2 = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
            }
            if (engineName.equals("rhino")) {
                if (sunFactory != null) {
                    ScriptEngine scriptEngine = this.sunEmbended();
                    return scriptEngine;
                }
                ScriptEngine scriptEngine = this.rhinoNonJdk();
                return scriptEngine;
            }
            if (engineName.equals("rhino-nonjdk")) {
                ScriptEngine scriptEngine = this.rhinoNonJdk();
                return scriptEngine;
            }
            if (engineName.equals("nashorn-rhino")) {
                ScriptEngine scriptEngine = this.nashornRhinoCompat();
                return scriptEngine;
            }
            ScriptEngine scriptEngine = this.other(engineName);
            return scriptEngine;
        }
        finally {
            if (cl2 != null) {
                Thread.currentThread().setContextClassLoader(cl2);
            }
        }
    }
}

