/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.engine.common;

import com.semarchy.xdi.engine.common.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CommonUtils {
    static CommonUtils INSTANCE = new CommonUtils();
    static FileMaskApi fileMaskApi = new FileMaskApi();

    public static Group splitGroupExpression(String str) {
        if (str != null) {
            Group mainGroup;
            Group currentGroup = mainGroup = INSTANCE.new Group();
            Pattern pDeb2 = Pattern.compile("((')|(\\()|(\\))|(,)|([A-Za-z0-9]\\())");
            Matcher mDeb2 = pDeb2.matcher(str);
            int deb = 0;
            int mode = 0;
            int p = 0;
            while (mDeb2.find()) {
                int strD = mDeb2.start(2);
                int parenthD = mDeb2.start(3);
                int parenthE = mDeb2.start(4);
                int comma = mDeb2.start(5);
                int funcD = mDeb2.start(6);
                if (mode == 0) {
                    String str2;
                    if (strD > -1) {
                        mode = -1;
                        continue;
                    }
                    if (funcD > -1) {
                        mode = 1;
                        continue;
                    }
                    if (parenthD > -1) {
                        ++p;
                        System.out.println(Messages.getString("CommonUtils.0"));
                        str2 = str.substring(deb, parenthD);
                        deb = parenthD + 1;
                        continue;
                    }
                    if (parenthE > -1) {
                        --p;
                        System.out.println(Messages.getString("CommonUtils.1"));
                        str2 = str.substring(deb, parenthE);
                        if (!str2.isEmpty()) {
                            currentGroup.addGroup().current = str2;
                        }
                        deb = parenthE + 1;
                        continue;
                    }
                    if (comma <= -1) continue;
                    str2 = str.substring(deb, comma);
                    if (!str2.isEmpty()) {
                        currentGroup.addGroup().current = str2;
                    }
                    System.out.println(Messages.getString("CommonUtils.2"));
                    deb = comma + 1;
                    continue;
                }
                if (mode == -1 && strD > -1) {
                    mode = 0;
                    continue;
                }
                if (mode > 0 && parenthE > -1) {
                    --mode;
                    continue;
                }
                if (mode <= 0 || parenthD <= -1) continue;
                ++mode;
            }
            if (deb > 0) {
                currentGroup.addGroup().current = str.substring(deb);
            } else {
                currentGroup.current = str;
            }
            return mainGroup;
        }
        return null;
    }

    public static List<String> splitCommaExpression(String str) {
        return CommonUtils.splitCommaExpression(str, 0);
    }

    public static List<String> splitCommaExpression(String str, int _mode) {
        if (str != null) {
            Pattern pDeb2 = Pattern.compile("((')|(\\()|(\\))|(,))");
            String _str = null;
            _str = _mode == 1 ? ((_str = str.trim()).startsWith("(") && _str.endsWith(")") ? _str.substring(1, _str.length() - 1) : str) : str;
            Matcher mDeb2 = pDeb2.matcher(_str);
            ArrayList<String> list = new ArrayList<String>();
            int deb = 0;
            int mode = 0;
            while (mDeb2.find()) {
                int strD = mDeb2.start(2);
                int parenthD = mDeb2.start(3);
                int parenthE = mDeb2.start(4);
                int comma = mDeb2.start(5);
                if (mode == 0) {
                    if (strD > -1) {
                        mode = -1;
                        continue;
                    }
                    if (parenthD > -1) {
                        mode = 1;
                        continue;
                    }
                    if (comma <= -1) continue;
                    list.add(_str.substring(deb, comma));
                    deb = comma + 1;
                    continue;
                }
                if (mode == -1 && strD > -1) {
                    mode = 0;
                    continue;
                }
                if (mode > 0 && parenthE > -1) {
                    --mode;
                    continue;
                }
                if (mode <= 0 || parenthD <= -1) continue;
                ++mode;
            }
            if (deb > 0) {
                list.add(_str.substring(deb));
            } else {
                list.add(_str);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public static boolean existsTable(Connection jdbcConnection, String sTableName, String sqlSchemaName) throws EngineExceptionI {
        return CommonUtils.existsTable(jdbcConnection, String.valueOf(sqlSchemaName) + sTableName);
    }

    public static boolean existsField(Connection jdbcConnection, String sqlSchemaName, String tableName, String field) {
        return CommonUtils.existsField(jdbcConnection, String.valueOf(sqlSchemaName) + tableName, field);
    }

    public static boolean existsField(Connection jdbcConnection, String fullName, String field) {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = jdbcConnection.createStatement();
            rs = st.executeQuery("SELECT " + field + " FROM " + fullName);
            return true;
        }
        catch (Exception exception) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static boolean existsTable(Connection jdbcConnection, String fullName) throws EngineExceptionI {
        Statement st = null;
        ResultSet rs = null;
        try {
            try {
                st = jdbcConnection.createStatement();
                rs = st.executeQuery("SELECT 1 FROM " + fullName);
            }
            catch (Exception e) {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public static byte[] compressByteArray(byte[] b, int level) throws IOException {
        Deflater compressor = new Deflater(level);
        compressor.setInput(b);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(b.length);
        byte[] buffer = new byte[1024];
        while (!compressor.finished()) {
            int bytesCompressed = compressor.deflate(buffer);
            bos.write(buffer, 0, bytesCompressed);
            try {
                bos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bos.toByteArray();
    }

    public static Document stringToDOMDocument(String xmlDef, String defaultDocumentBuilderFactoryClass) throws EngineExceptionI {
        try {
            DocumentBuilderFactory docBuilderFactory = null;
            try {
                docBuilderFactory = defaultDocumentBuilderFactoryClass != null ? DocumentBuilderFactory.newInstance(defaultDocumentBuilderFactoryClass, null) : DocumentBuilderFactory.newInstance();
            }
            catch (FactoryConfigurationError e) {
                docBuilderFactory = DocumentBuilderFactory.newInstance();
            }
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            return docBuilder.parse(new ByteArrayInputStream(xmlDef.getBytes()));
        }
        catch (SAXException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (IOException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    public static byte[] inputStreamToByteArray(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public static String inputStreamToString(InputStream stream, String charsetName) throws IOException {
        BufferedReader br = charsetName != null ? new BufferedReader(new InputStreamReader(stream, charsetName)) : new BufferedReader(new InputStreamReader(stream));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(line);
        }
        br.close();
        return sb.toString();
    }

    public static String inputStreamToString(InputStream stream) throws IOException {
        return CommonUtils.inputStreamToString(stream, null);
    }

    public static byte[] unCompressByteArray(byte[] b) throws IOException, DataFormatException {
        Inflater unCompressor = new Inflater();
        unCompressor.setInput(b);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        while (!unCompressor.finished()) {
            int bytesCompressed = unCompressor.inflate(buffer);
            bos.write(buffer, 0, bytesCompressed);
            try {
                bos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        unCompressor.end();
        return bos.toByteArray();
    }

    public static Map transformPurgeMap(Map<String, Object> rules) throws Exception {
        String size = (String)rules.get("size");
        String unit = (String)rules.get("unit");
        Map mapSession = (Map)rules.get("purgeSessionName");
        List statusList = (List)rules.get("purgeStatusList");
        String tmp = "purge param: size[%s] unit[%s] host[%s] port[%s] param[%s]";
        String currentRuntime = (String)rules.get("currentRuntime");
        long l = 0L;
        int nbSessions = -1;
        if (unit.equals("day")) {
            l = Long.valueOf(size) * 24L * 60L * 60L * 1000L;
        } else if (unit.equals("hour")) {
            l = Long.valueOf(size) * 60L * 60L * 1000L;
        } else if (unit.equals("minute")) {
            l = Long.valueOf(size) * 60L * 1000L;
        } else if (unit.equals("session")) {
            nbSessions = Integer.valueOf(size);
        } else {
            throw new Exception("invalid unit: " + unit);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (nbSessions == -1) {
            Date date = new Date(System.currentTimeMillis() - l);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss z");
            map.put("untilDate", date);
        } else {
            map.put("nbSessions", nbSessions);
        }
        if (mapSession != null) {
            map.put("sessionName", mapSession);
        }
        if (statusList != null && statusList.size() > 0) {
            map.put("statusList", statusList);
        }
        if (currentRuntime != null) {
            map.put("currentRuntime", true);
        }
        return map;
    }

    public static String detectXmlCharsetEncoding(InputStream in) throws IOException {
        if (in != null && in.markSupported()) {
            in.mark(512);
            byte[] buffer = new byte[512];
            int read = in.read(buffer, 0, buffer.length);
            Charset cs = Charset.forName(System.getProperty("file.encoding"));
            String s = new String(buffer, 0, read, cs);
            int pos = s.indexOf("encoding");
            String ret = null;
            if (pos > -1) {
                int delim = 39;
                int start = s.indexOf(39, pos);
                if (start == -1) {
                    delim = 34;
                    start = s.indexOf(34, pos);
                }
                if (start == -1) {
                    throw new IOException(Messages.getString("CommonUtils.3"));
                }
                int end = s.indexOf(delim, start + 1);
                if (end == -1) {
                    throw new IOException(Messages.getString("CommonUtils.4"));
                }
                ret = s.substring(start + 1, end);
            }
            in.reset();
            return ret;
        }
        return null;
    }

    public static List<File> getFile(String masks, String separator) {
        return fileMaskApi.getFile(masks.split(separator));
    }

    public static Transformer getSafeTransformer() throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return factory.newTransformer();
    }

    private static class FileMaskApi {
        private FileMaskApi() {
        }

        void fillStack(File file, List<File> stack) {
            if (file != null && (file.getPath().contains("*") || file.getPath().contains("?") || file.exists())) {
                this.fillStack(file.getParentFile(), stack);
                stack.add(file);
            }
        }

        public String replaceWildCharsWithGroups(String wild) {
            StringBuffer buffer = new StringBuffer();
            char[] chars = wild.toCharArray();
            int i = 0;
            while (i < chars.length) {
                if (chars[i] == '*') {
                    buffer.append("(.*)");
                } else if (chars[i] == '?') {
                    buffer.append("(.)");
                } else if ("+()^$.{}[]|\\".indexOf(chars[i]) != -1) {
                    buffer.append('\\').append(chars[i]);
                } else {
                    buffer.append(chars[i]);
                }
                ++i;
            }
            return buffer.toString();
        }

        void getAllRecursDir(File dir, List<File> list, List<File> excludes) {
            if (dir.isDirectory() && (excludes == null || !excludes.contains(dir))) {
                list.add(dir);
                if (dir.listFiles() != null) {
                    File[] fileArray = dir.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        this.getAllRecursDir(child, list, excludes);
                        ++n2;
                    }
                } else {
                    System.out.println();
                }
            }
        }

        void fillList2(File parentRealFile, Level parentLevel, List<File> list, int index, boolean recursive, List<File> excludes) {
            if (parentRealFile == null) {
                ++index;
                for (Level child : parentLevel.level.values()) {
                    this.fillList2(child.file, child, list, index, recursive, excludes);
                }
                return;
            }
            if (excludes != null && excludes.contains(parentRealFile)) {
                return;
            }
            if (!parentRealFile.exists()) {
                return;
            }
            if (parentLevel.isLeaf) {
                list.add(parentRealFile);
                return;
            }
            if (!parentLevel.isLeaf && parentRealFile.isDirectory()) {
                for (Level childLevel : parentLevel.level.values()) {
                    File childRealFile = new File(parentRealFile, childLevel.file.getName());
                    String name = childRealFile.getName();
                    if (name != null) {
                        if (name.equals("**")) {
                            ArrayList<File> allDirs = new ArrayList<File>();
                            this.getAllRecursDir(parentRealFile, allDirs, excludes);
                            for (File dir : allDirs) {
                                this.fillList2(dir, childLevel, list, index, true, excludes);
                            }
                            continue;
                        }
                        if (name.indexOf(42) > -1 || name.indexOf(63) > -1) {
                            String pattern = this.replaceWildCharsWithGroups(name);
                            if (parentRealFile.listFiles() != null) {
                                File[] fileArray = parentRealFile.listFiles();
                                int n = fileArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    File _file = fileArray[n2];
                                    if (_file.getName().matches(pattern)) {
                                        this.fillList2(_file, childLevel, list, index, recursive, excludes);
                                    }
                                    ++n2;
                                }
                                continue;
                            }
                            System.out.println();
                            continue;
                        }
                        this.fillList2(childRealFile, childLevel, list, index, recursive, excludes);
                        continue;
                    }
                    System.out.println();
                }
            }
        }

        void fillRoot(Level root, List<List<File>> stacks) {
            for (List<File> stack : stacks) {
                Level current = root;
                int i = -1;
                for (File fi : stack) {
                    ++i;
                    Level l = current.level.get(fi.getName());
                    if (l == null) {
                        l = new Level();
                        l.file = fi;
                        if (i + 1 == stack.size()) {
                            l.isLeaf = true;
                        }
                        current.level.put(fi.getName(), l);
                    }
                    current = l;
                }
            }
        }

        List<File> getFile(String ... mask) {
            ArrayList<List<File>> stacks = new ArrayList<List<File>>();
            ArrayList<List<File>> excludes = new ArrayList<List<File>>();
            String[] stringArray = mask;
            int n = mask.length;
            int n2 = 0;
            while (n2 < n) {
                String _mask = stringArray[n2];
                boolean exclude = (_mask = _mask.trim()).startsWith("exclude::");
                if (exclude) {
                    _mask = _mask.substring(9);
                }
                ArrayList<File> stack = new ArrayList<File>();
                File f = new File(_mask);
                this.fillStack(f, stack);
                if (exclude) {
                    excludes.add(stack);
                } else {
                    stacks.add(stack);
                }
                ++n2;
            }
            Level root = new Level();
            this.fillRoot(root, stacks);
            Level rootExclude = new Level();
            this.fillRoot(rootExclude, excludes);
            ArrayList<File> _excludes = new ArrayList<File>();
            this.fillList2(null, rootExclude, _excludes, -1, false, null);
            ArrayList<File> list = new ArrayList<File>();
            this.fillList2(null, root, list, -1, false, _excludes);
            return list;
        }
    }

    class Group {
        Group parent;
        List<Group> children = new ArrayList<Group>();
        String current;
        String code;

        Group() {
        }

        Group addGroup() {
            Group group = new Group();
            group.parent = this;
            this.children.add(group);
            return group;
        }

        public String toString() {
            if (this.current != null && !this.current.isEmpty()) {
                return this.current;
            }
            String str = "(";
            int i = 0;
            while (i < this.children.size()) {
                Group grp = this.children.get(i);
                if (i > 0) {
                    str = String.valueOf(str) + ",";
                }
                str = String.valueOf(str) + grp.toString();
                ++i;
            }
            str = String.valueOf(str) + ")";
            return str;
        }
    }

    static class Level {
        Map<String, Level> level = new HashMap<String, Level>();
        File file;
        boolean isLeaf;

        Level() {
        }
    }
}

