/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.connection.jdbc;

import com.indy.engine.core.externalvalueresolver.ExternalValueResolverManager;
import com.indy.engine.core.externalvalueresolver.IExternalValueResolverPlugin;
import com.indy.engine.core.module.classloader.ClassLoaderServiceProvider;
import com.semarchy.xdi.runtime.connection.jdbc.JdbcParameters;
import com.semarchy.xdi.runtime.connection.jdbc.Messages;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;

public abstract class AbstractDataSourceImpl
implements DataSource {
    protected final JdbcParameters jdbcParameters;
    protected final boolean resolveExternalValues;
    private boolean withSecrets = false;
    private static org.apache.logging.log4j.Logger log = LogManager.getLogger((String)"com.indy.engine.rdbmsLog");
    private static org.apache.logging.log4j.Logger jdbcLog = LogManager.getLogger((String)"com.indy.engine.jdbc");

    public AbstractDataSourceImpl(JdbcParameters jdbcParameters, boolean resolveExternalValues) {
        this.jdbcParameters = jdbcParameters;
        this.resolveExternalValues = resolveExternalValues;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger("com.indy.engine.console");
    }

    protected String evaluateSecuredExternalValues(String value) {
        int index;
        if (this.resolveExternalValues && (index = ExternalValueResolverManager.INSTANCE.indexOf(value)) > -1) {
            try {
                value = ExternalValueResolverManager.INSTANCE.replace(value, index);
                this.withSecrets = true;
            }
            catch (IExternalValueResolverPlugin.ExternalValueResolverException e) {
                throw new RuntimeException(e);
            }
        }
        return value;
    }

    protected boolean hasSecrets() {
        return this.withSecrets;
    }

    protected ClassLoader getJDBCClassLoader() throws Exception {
        ClassLoader cl;
        String driverClassName;
        String moduleName;
        block10: {
            moduleName = this.jdbcParameters.getModuleName();
            driverClassName = this.jdbcParameters.getDriver();
            cl = null;
            if (moduleName != null) {
                String logMessage = String.format(Messages.getString("JdbcDataSource.4"), moduleName);
                if ("internal".equals(moduleName)) {
                    log.debug(logMessage);
                } else {
                    jdbcLog.debug(logMessage);
                }
                cl = ClassLoaderServiceProvider.INSTANCE.getClassLoader(moduleName);
                if (cl == null) {
                    throw new Exception(String.format(Messages.getString("JdbcDataSource.5"), moduleName));
                }
            } else {
                moduleName = "default";
                Logger.getLogger(this.getClass().getName()).info(String.format(Messages.getString("JdbcDataSource.6"), moduleName));
                cl = ClassLoaderServiceProvider.INSTANCE.getClassLoader(moduleName);
                if (cl == null) {
                    throw new Exception(String.format(Messages.getString("JdbcDataSource.7"), moduleName));
                }
                try {
                    Class<?> clazz = Class.forName(driverClassName, true, cl);
                    return cl;
                }
                catch (Exception ex) {
                    moduleName = "internal";
                    Logger.getLogger(this.getClass().getName()).info(String.format(Messages.getString("JdbcDataSource.8"), moduleName));
                    cl = ClassLoaderServiceProvider.INSTANCE.getClassLoader(moduleName);
                    if (cl != null) break block10;
                    throw new Exception(String.format(Messages.getString("JdbcDataSource.9"), moduleName), ex);
                }
            }
        }
        try {
            Class.forName(driverClassName, true, cl);
        }
        catch (Exception ex) {
            throw new Exception(String.format(Messages.getString("JdbcDataSource.10"), driverClassName, moduleName), ex);
        }
        return cl;
    }
}

