/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.connection.jdbc;

import com.semarchy.xdi.engine.common.exceptions.SecretStatementException;
import com.semarchy.xdi.runtime.connection.jdbc.AbstractDataSourceImpl;
import com.semarchy.xdi.runtime.connection.jdbc.JdbcParameters;
import com.semarchy.xdi.runtime.connection.jdbc.Messages;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public class DriverManagerDataSourceImpl
extends AbstractDataSourceImpl {
    private PrintWriter printWriter;

    public DriverManagerDataSourceImpl(JdbcParameters jdbcParameters, boolean resolveExternalValues) {
        super(jdbcParameters, resolveExternalValues);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        if (this.printWriter == null) {
            throw new UnsupportedOperationException(Messages.getString("jdbc.notPrintWriter"));
        }
        return this.printWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.printWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new UnsupportedOperationException(Messages.getString("jdbc.notImplemented"));
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLException("DataSource of type [" + this.getClass().getName() + "] cannot be unwrapped as [" + iface.getName() + "]");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public final Connection getConnection() throws SQLException {
        return this.getConnection(this.jdbcParameters.getUsername(), this.jdbcParameters.getPassword());
    }

    @Override
    public final Connection getConnection(String username, String password) throws SQLException {
        Driver driver = null;
        try {
            ClassLoader cl = this.getJDBCClassLoader();
            String driverName = this.evaluateSecuredExternalValues(this.jdbcParameters.getDriver());
            try {
                Class<?> clazz = Class.forName(driverName, true, cl);
                driver = (Driver)clazz.newInstance();
            }
            catch (ClassNotFoundException ex) {
                throw new Exception(String.format(Messages.getString("JdbcDataSource.2"), cl, driverName), ex);
            }
        }
        catch (Exception e) {
            throw new SQLException((Throwable)(this.hasSecrets() ? new SecretStatementException() : e));
        }
        try {
            Properties mergedProps = new Properties();
            if (this.resolveExternalValues) {
                this.jdbcParameters.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> mergedProps.setProperty(k.toString(), v != null ? this.evaluateSecuredExternalValues(v.toString()) : null)));
            } else {
                mergedProps.putAll((Map<?, ?>)this.jdbcParameters.getProperties());
            }
            if (username != null) {
                mergedProps.setProperty("user", this.evaluateSecuredExternalValues(username));
            }
            if (password != null) {
                mergedProps.setProperty("password", this.evaluateSecuredExternalValues(password));
            }
            Connection conn = driver.connect(this.evaluateSecuredExternalValues(this.jdbcParameters.getUrl()), mergedProps);
            conn.setAutoCommit(this.jdbcParameters.isAutocommit());
            List<String> initSqls = this.jdbcParameters.getConnectionInitSqls();
            if (!initSqls.isEmpty()) {
                try (Statement stmt = null;){
                    stmt = conn.createStatement();
                    for (String sql : initSqls) {
                        stmt.execute(sql);
                    }
                }
            }
            return conn;
        }
        catch (SQLException e) {
            throw this.hasSecrets() ? new SQLException((Throwable)new SecretStatementException()) : e;
        }
    }
}

