/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.connection.jdbc;

import com.semarchy.xdi.runtime.connection.jdbc.AbstractDataSourceWrapperImpl;
import com.semarchy.xdi.runtime.connection.jdbc.JdbcParameters;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.List;
import java.util.function.BiConsumer;
import javax.sql.DataSource;

public class HikariDataSourceImpl
extends AbstractDataSourceWrapperImpl {
    private HikariDataSource dataSource = null;

    public HikariDataSourceImpl(JdbcParameters jdbcParameters, boolean resolveExternalValues) {
        super(jdbcParameters, resolveExternalValues);
    }

    private HikariConfig getHikariConfig() {
        HikariConfig config = new HikariConfig();
        config.setAutoCommit(this.jdbcParameters.isAutocommit());
        config.setDriverClassName(this.evaluateSecuredExternalValues(this.jdbcParameters.getDriver()));
        config.setMaximumPoolSize(this.jdbcParameters.getMaximumPoolSize());
        config.setMinimumIdle(this.jdbcParameters.getMinimumIdle());
        config.setJdbcUrl(this.evaluateSecuredExternalValues(this.jdbcParameters.getUrl()));
        config.setUsername(this.evaluateSecuredExternalValues(this.jdbcParameters.getUsername()));
        config.setPassword(this.evaluateSecuredExternalValues(this.jdbcParameters.getPassword()));
        config.setConnectionTimeout((long)this.jdbcParameters.getConnectionTimeout());
        List<String> connectionInitSqlsList = this.jdbcParameters.getConnectionInitSqls();
        if (!connectionInitSqlsList.isEmpty()) {
            config.setConnectionInitSql(String.join((CharSequence)";", connectionInitSqlsList));
        }
        config.setValidationTimeout((long)this.jdbcParameters.getConnectionTimeout());
        config.setIdleTimeout((long)this.jdbcParameters.getIdleTimeout());
        config.setMaxLifetime((long)this.jdbcParameters.getMaxLifetime());
        if (this.jdbcParameters.getValidationQuery() != null) {
            config.setConnectionTestQuery(this.jdbcParameters.getValidationQuery());
        }
        this.jdbcParameters.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> config.addDataSourceProperty(k.toString(), v == null ? null : this.evaluateSecuredExternalValues(v.toString()))));
        return config;
    }

    @Override
    protected DataSource doGetDataSource() throws SQLException {
        if (this.dataSource == null) {
            try {
                ClassLoader current = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getJDBCClassLoader());
                try {
                    this.dataSource = new HikariDataSource(this.getHikariConfig());
                }
                finally {
                    Thread.currentThread().setContextClassLoader(current);
                }
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        return this.dataSource;
    }

    @Override
    public void close() throws SQLException {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }
}

