/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.externalvalueresolver.impl;

import com.indy.engine.core.externalvalueresolver.IExternalValueResolverPlugin;
import com.indy.engine.shared.configuration.externalvalueresolver.ExternalValueResolverConfiguration;
import com.indy.engine.shared.plugin.IPluginFactory;
import com.stambia.externalvalueresolver.impl.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SimpleExternalValueResolverInternalPlugin
implements IExternalValueResolverPlugin {
    Map<String, KeyValue> kvs = new HashMap<String, KeyValue>();
    RefreshMode refreshMode = RefreshMode.dynamic;
    long lastModified = -1L;
    File file;
    private static final String P_REFRESH_MODE = "refreshMode";
    private static final String P_FILE_PATH = "filePath";

    private synchronized void refreshKeys() throws IOException {
        if (this.lastModified == -1L || this.refreshMode == RefreshMode.dynamic && this.lastModified < this.file.lastModified()) {
            try (InputStream is = null;){
                this.lastModified = this.file.lastModified();
                is = new FileInputStream(this.file);
                Properties props = new Properties();
                props.load(is);
                this.kvs.clear();
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    KeyValue kv = new KeyValue();
                    kv.value = ((String)entry.getValue()).getBytes("UTF8");
                    kv.type = IExternalValueResolverPlugin.SecurityLevel.level2;
                    this.kvs.put((String)entry.getKey(), kv);
                }
            }
        }
    }

    public void init(ExternalValueResolverConfiguration.Resolver conf, IPluginFactory.IRelativePathResolver resolver) throws Exception {
        String filePath;
        String _refreshMode = conf.getProperty(P_REFRESH_MODE);
        if (_refreshMode != null) {
            this.refreshMode = RefreshMode.valueOf(_refreshMode);
        }
        if ((filePath = conf.getProperty(P_FILE_PATH)) == null) {
            throw new Exception(Messages.getString("SimpleExternalValueResolverInternalPlugin.0"));
        }
        if (resolver != null) {
            filePath = resolver.resolve(filePath);
        }
        this.file = new File(filePath);
        if (!this.file.exists()) {
            throw new Exception(String.format(Messages.getString("SimpleExternalValueResolverInternalPlugin.1"), this.file.getAbsolutePath()));
        }
        this.refreshKeys();
    }

    public synchronized IExternalValueResolverPlugin.Value getvalue(String key, IExternalValueResolverPlugin.SecurityLevel type) {
        IExternalValueResolverPlugin.Value value;
        try {
            this.refreshKeys();
        }
        catch (IOException e) {
            value = new IExternalValueResolverPlugin.Value();
            value.errorMessage = String.format(Messages.getString("SimpleExternalValueResolverInternalPlugin.2"), key);
        }
        KeyValue kv = this.kvs.get(key);
        value = new IExternalValueResolverPlugin.Value();
        if (kv != null) {
            if (kv.type == IExternalValueResolverPlugin.SecurityLevel.level1) {
                value.data = kv.value;
                return value;
            }
            if (type == IExternalValueResolverPlugin.SecurityLevel.level2 && kv.type == IExternalValueResolverPlugin.SecurityLevel.level2) {
                value.data = kv.value;
                return value;
            }
            value.errorMessage = String.format(Messages.getString("SimpleExternalValueResolverInternalPlugin.3"), key, type);
        } else {
            value.errorMessage = String.format(Messages.getString("SimpleExternalValueResolverInternalPlugin.4"), key);
        }
        return value;
    }

    class KeyValue {
        IExternalValueResolverPlugin.SecurityLevel type;
        public byte[] value;

        KeyValue() {
        }
    }

    static enum RefreshMode {
        dynamic,
        onStartup;

    }
}

