/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.externalvalueresolver.vault.incubation;

import com.indy.engine.core.externalvalueresolver.IExternalValueResolverPlugin;
import com.indy.engine.shared.plugin.IPluginFactory;
import com.stambia.externalvalueresolver.vault.incubation.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.TokenAuthentication;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.core.VaultKeyValueOperationsSupport;
import org.springframework.vault.core.VaultTemplate;
import org.springframework.vault.support.VaultResponse;

public class VaultExternalValueResolverFile
implements IExternalValueResolverPlugin {
    static Map<String, VaultPathAndKey> vaultKvs = new HashMap<String, VaultPathAndKey>();
    @Autowired
    private VaultTemplate vaultTemplate;
    private String vaultAddr;
    private String token;
    private String scheme;
    private static final String VALUE_NOT_FOUND_ERROR = Messages.VaultExternalValueResolverFile_0;
    private static final String PATH_INCORRECT = Messages.VaultExternalValueResolverFile_1;
    private static final String KEY_NOT_FOUND = Messages.VaultExternalValueResolverFile_2;

    public void init(IPluginFactory.IPluginConfiguration cnf) throws Exception {
        String filePath;
        this.vaultAddr = cnf.getProperty("vaultAddr");
        this.token = cnf.getProperty("token");
        this.scheme = null;
        if (!cnf.getProperty("scheme").isEmpty()) {
            this.scheme = cnf.getProperty("scheme");
        }
        if ((filePath = cnf.getProperty("filePath")) == null) {
            throw new Exception(Messages.VaultExternalValueResolverFile_3);
        }
        if (!new File(filePath).exists()) {
            throw new Exception(String.valueOf(Messages.VaultExternalValueResolverFile_4) + filePath + Messages.VaultExternalValueResolverFile_5);
        }
        try (FileInputStream is = null;){
            is = new FileInputStream(filePath);
            Properties file = new Properties();
            file.load(is);
            for (Map.Entry<Object, Object> entry : file.entrySet()) {
                String infos = (String)entry.getKey();
                String infos2 = (String)entry.getValue();
                int i = infos.indexOf(".");
                if (i < -1) {
                    throw new Exception(String.valueOf(Messages.VaultExternalValueResolverFile_6) + infos + Messages.VaultExternalValueResolverFile_7);
                }
                int j = infos2.indexOf("/");
                int k = infos2.indexOf("/", j + 1);
                String _type = infos.substring(0, i);
                String alias = infos.substring(i + 1);
                String _enginePath = infos2.substring(0, j);
                String _path = infos2.substring(j + 1, k);
                String _key = infos2.substring(k + 1);
                IExternalValueResolverPlugin.SecurityLevel type = IExternalValueResolverPlugin.SecurityLevel.valueOf((String)_type);
                if (type != IExternalValueResolverPlugin.SecurityLevel.level2) {
                    throw new Exception(Messages.VaultExternalValueResolverFile_8);
                }
                VaultPathAndKey vaultKv = new VaultPathAndKey();
                vaultKv.enginePath = _enginePath;
                vaultKv.path = _path;
                vaultKv.type = type;
                vaultKv.vaultKey = _key;
                vaultKvs.put(alias, vaultKv);
            }
        }
    }

    public IExternalValueResolverPlugin.Value getvalue(String key, IExternalValueResolverPlugin.SecurityLevel type) {
        int separator = this.vaultAddr.indexOf(":");
        String host = "";
        int port = 0;
        if (separator == -1) {
            host = this.vaultAddr;
        } else {
            port = Integer.parseInt(this.vaultAddr.substring(separator + 1));
            host = this.vaultAddr.substring(0, separator);
        }
        if (port == 0) {
            port = this.scheme.equals("http") ? 80 : 443;
        }
        VaultEndpoint ep = VaultEndpoint.create((String)host, (int)port);
        if (this.scheme != null) {
            ep.setScheme(this.scheme);
            this.vaultTemplate = new VaultTemplate(ep, (ClientAuthentication)new TokenAuthentication(this.token));
        }
        IExternalValueResolverPlugin.Value value = new IExternalValueResolverPlugin.Value();
        VaultPathAndKey vaultKv = vaultKvs.get(key);
        if (vaultKv == null) {
            value.errorMessage = VALUE_NOT_FOUND_ERROR;
            return value;
        }
        if (type == vaultKv.type || vaultKv.type == IExternalValueResolverPlugin.SecurityLevel.level1) {
            VaultResponse response = this.vaultTemplate.opsForKeyValue(vaultKv.enginePath, VaultKeyValueOperationsSupport.KeyValueBackend.KV_2).get(vaultKv.path);
            String temp = (String)((Map)response.getData()).get(vaultKv.vaultKey);
            value.data = temp.getBytes(Charset.forName("UTF-8"));
            if (!(value.data instanceof byte[])) {
                value.errorMessage = VALUE_NOT_FOUND_ERROR;
                return value;
            }
            return value;
        }
        if (type == IExternalValueResolverPlugin.SecurityLevel.level1 && vaultKv.type == IExternalValueResolverPlugin.SecurityLevel.level2) {
            value.errorMessage = VALUE_NOT_FOUND_ERROR;
            return value;
        }
        return null;
    }

    class VaultPathAndKey {
        IExternalValueResolverPlugin.SecurityLevel type;
        String enginePath;
        String path;
        String vaultKey;

        VaultPathAndKey() {
        }
    }
}

