/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.net.proxy;

import com.stambia.net.proxy.Messages;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import javax.xml.bind.DatatypeConverter;

public class URLUtil {
    private static Field handlerField;
    private static Method openConnectionMethod;
    private static Method openConnectionWithProxyMethod;

    static {
        try {
            handlerField = URL.class.getDeclaredField("handler");
            openConnectionMethod = URLStreamHandler.class.getDeclaredMethod("openConnection", URL.class);
            openConnectionWithProxyMethod = URLStreamHandler.class.getDeclaredMethod("openConnection", URL.class, Proxy.class);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        handlerField.setAccessible(true);
        openConnectionMethod.setAccessible(true);
        openConnectionWithProxyMethod.setAccessible(true);
    }

    public static URL createURL(String str, AuthenticationType authenticationType, final String user, final String password, Proxy proxy, final String proxyUser, final String proxyPassword) throws MalformedURLException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (authenticationType.equals((Object)AuthenticationType.BASIC)) {
            return URLUtil.createURL(str, new URLOpenConnectionHandler(){

                @Override
                public void handle(URLConnection conn) {
                    URLUtil.setUserHeader(conn, user, password, proxyUser, proxyPassword);
                }
            }, proxy);
        }
        return URLUtil.createURL(str, new URLOpenConnectionHandler(){

            @Override
            public void handle(URLConnection conn) throws IOException {
                try {
                    Method setAuthMethod = conn.getClass().getMethod("setAuthenticator", Authenticator.class);
                    setAuthMethod.invoke((Object)conn, new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(user, password.toCharArray());
                        }
                    });
                }
                catch (NoSuchMethodException e) {
                    throw new IOException(Messages.getString("URLUtil.0"));
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                URLUtil.setUserHeader(conn, null, null, proxyUser, proxyPassword);
            }
        }, proxy);
    }

    public static void setUserHeader(URLConnection conn, String user, String password, String proxyUser, String proxyPassword) {
        String encoded;
        if (proxyUser != null && proxyPassword != null) {
            encoded = DatatypeConverter.printBase64Binary((byte[])new String(String.valueOf(proxyUser) + ":" + proxyPassword).getBytes());
            conn.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
        }
        if (user != null && password != null) {
            encoded = DatatypeConverter.printBase64Binary((byte[])new String(String.valueOf(user) + ":" + password).getBytes());
            conn.setRequestProperty("Authorization", "Basic " + encoded);
        }
    }

    public static URL createURL(String str, final URLOpenConnectionHandler handler, final Proxy proxy) throws MalformedURLException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        URL url = new URL(str);
        final URLStreamHandler urlStreamHandler = (URLStreamHandler)handlerField.get(url);
        url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile(), new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                try {
                    URLConnection urlConnection = proxy == null ? (URLConnection)openConnectionMethod.invoke((Object)urlStreamHandler, u) : (URLConnection)openConnectionWithProxyMethod.invoke((Object)urlStreamHandler, u, proxy);
                    if (handler != null) {
                        handler.handle(urlConnection);
                    }
                    return urlConnection;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                return u.openConnection();
            }
        });
        return url;
    }

    public static enum AuthenticationType {
        BASIC,
        NTLM;

    }

    public static interface URLOpenConnectionHandler {
        public void handle(URLConnection var1) throws IOException;
    }
}

