/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ftp.commands;

import com.stambia.ftp.FtpSession;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpStatisticListener;
import java.io.IOException;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;

public abstract class FtpCommand<T> {
    private String command;
    private String[] parameters;

    public FtpCommand(String command, String[] parameters) {
        this.setCommand(command);
        this.setParameters(parameters);
    }

    public FtpCommand(FtpCommand<T> ftpCmd) {
        this.setCommand(ftpCmd.getCommand());
        this.setParameters(ftpCmd.getParameters());
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String _command) {
        this.command = _command;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public void setParameters(String[] _parameters) {
        this.parameters = _parameters;
    }

    public void showCommand() {
        System.out.println("Command: " + this.command);
    }

    public void showParameters() {
        System.out.println("Parameters:");
        int i = 0;
        while (i < this.parameters.length) {
            System.out.println(this.parameters[i]);
            ++i;
        }
    }

    protected boolean isResponseFine(FTPClient ftpCli) {
        return ftpCli.getReplyCode() < 400;
    }

    protected void defaultResponseManager(FTPClient ftpCli, boolean verbose, FtpCommandHandler handler) throws FtpCommandException {
        boolean fineResponse = this.isResponseFine(ftpCli);
        int replyCode = ftpCli.getReplyCode();
        String replyString = ftpCli.getReplyString();
        if (fineResponse && (verbose || !verbose && replyCode >= 200 && replyCode <= 299)) {
            handler.handleResponse(replyString);
        } else if (!fineResponse) {
            FtpCommandException exception = new FtpCommandException(replyString);
            handler.handleError(replyString, exception);
        }
    }

    @Deprecated
    private String removeReplyCode(int replyCode, String replyString, String extraChar) {
        String replyCodeStart = String.valueOf(replyCode) + extraChar;
        if (replyString.startsWith(replyCodeStart)) {
            replyString = replyString.replaceFirst(replyCodeStart, "");
        }
        return replyString;
    }

    protected void fireStatiscitEvent(List<FtpStatisticListener> statisticsListeners, FtpStatisticListener.Statistic name, long value) {
        for (FtpStatisticListener statisticListener : statisticsListeners) {
            if (statisticListener == null) continue;
            statisticListener.statisticEvent(name, value);
        }
    }

    public void executeCommand(T ftpCli, boolean verbose, FtpCommandHandler commandHandler) throws IOException, FtpCommandException {
        this.executeCommand(ftpCli, FtpSession.defaultLocalPath, verbose, commandHandler, null);
    }

    public abstract void executeCommand(T var1, String var2, boolean var3, FtpCommandHandler var4, List<FtpStatisticListener> var5) throws IOException, FtpCommandException;
}

