/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ftp.commands;

import com.stambia.ftp.commands.FtpCommand;
import com.stambia.ftp.exceptions.BadSyntaxException;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpCommandResponses;
import com.stambia.ftp.utils.FtpStatisticListener;
import com.stambia.ftp.utils.FtpUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;

public class FtpCommand_APPEND
extends FtpCommand<FTPClient> {
    public FtpCommand_APPEND(String command, String[] parameters) {
        super(command, parameters);
    }

    public FtpCommand_APPEND(FtpCommand<FTPClient> ftpCmd) {
        super(ftpCmd);
    }

    @Override
    public void executeCommand(FTPClient ftpCli, String localPath, boolean verbose, FtpCommandHandler commandHandler, List<FtpStatisticListener> statisticsListeners) throws IOException, FtpCommandException {
        if (this.getParameters()[0] != null) {
            FileInputStream ism;
            File file = new File(FtpUtils.buildFilePath(this.getParameters()[0], localPath));
            this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.APPEND_ADDED_FILE_SIZE, file.length());
            if (this.getParameters()[1] == null || this.getParameters()[1] == "") {
                ism = new FileInputStream(file);
                ftpCli.appendFile("./" + file.getName(), (InputStream)ism);
            } else {
                ism = new FileInputStream(file);
                ftpCli.appendFile(FtpUtils.removeFirstAndLastQuotes(this.getParameters()[1]), (InputStream)ism);
            }
            ((InputStream)ism).close();
            this.defaultResponseManager(ftpCli, verbose, commandHandler);
        } else {
            BadSyntaxException exception = new BadSyntaxException(FtpCommandResponses.MISSING_PARAMETER);
            commandHandler.handleError("", exception);
        }
    }
}

