/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ftp.commands;

import com.stambia.ftp.commands.FtpCommand;
import com.stambia.ftp.exceptions.ConnectionFailedException;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpStatisticListener;
import com.stambia.ftp.utils.FtpUtils;
import java.io.IOException;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public class FtpCommand_LIST
extends FtpCommand<FTPClient> {
    public FtpCommand_LIST(String command, String[] parameters) {
        super(command, parameters);
    }

    public FtpCommand_LIST(FtpCommand<FTPClient> ftpCmd) {
        super(ftpCmd);
    }

    @Override
    public void executeCommand(FTPClient ftpCli, String localPath, boolean verbose, FtpCommandHandler commandHandler, List<FtpStatisticListener> statisticsListeners) throws IOException, FtpCommandException {
        StringBuilder response = new StringBuilder();
        FTPFile[] fileList = this.getParameters()[0] == null ? ftpCli.listFiles() : ftpCli.listFiles(FtpUtils.removeFirstAndLastQuotes(this.getParameters()[0]));
        if (this.isResponseFine(ftpCli)) {
            this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.LISTED_FILES_NUMBER, fileList.length);
            response.append(ftpCli.getReplyString());
            FTPFile[] fTPFileArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile file = fTPFileArray[n2];
                this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.LISTED_FILES_SIZE, file.getSize());
                response.append(String.valueOf(file.getName()) + System.lineSeparator());
                ++n2;
            }
            commandHandler.handleResponse(response.toString());
        } else {
            ConnectionFailedException exception = new ConnectionFailedException(ftpCli.getReplyString());
            commandHandler.handleError(ftpCli.getReplyString(), exception);
        }
    }
}

