/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ftp.commands;

import com.stambia.ftp.commands.FtpCommand;
import com.stambia.ftp.exceptions.BadSyntaxException;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpCommandResponses;
import com.stambia.ftp.utils.FtpStatisticListener;
import com.stambia.ftp.utils.FtpUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;

public class FtpCommand_RETR_NEWER
extends FtpCommand<FTPClient> {
    public FtpCommand_RETR_NEWER(String command, String[] parameters) {
        super(command, parameters);
    }

    public FtpCommand_RETR_NEWER(FtpCommand<FTPClient> ftpCmd) {
        super(ftpCmd);
    }

    @Override
    public void executeCommand(FTPClient ftpCli, String localPath, boolean verbose, FtpCommandHandler commandHandler, List<FtpStatisticListener> statisticsListeners) throws IOException, FtpCommandException {
        if (this.getParameters()[0] != null) {
            File localFile;
            String newLocalPath;
            String localTimeZone = this.getTimeZone(this.getParameters()[3]);
            String remoteTimeZone = this.getTimeZone(this.getParameters()[2]);
            if (this.getParameters()[1] == null) {
                newLocalPath = String.valueOf(localPath) + FtpUtils.getFileName(this.getParameters()[0]);
                localFile = new File(newLocalPath);
            } else {
                newLocalPath = String.valueOf(FtpUtils.buildPath(this.getParameters()[1], localPath)) + FtpUtils.getFileName(this.getParameters()[1]);
                localFile = new File(newLocalPath);
            }
            ftpCli.sendCommand("MDTM", this.getParameters()[0]);
            if (this.isResponseFine(ftpCli)) {
                String remoteDateRaw = ftpCli.getReplyString().substring(4).trim();
                Date date = new Date(localFile.lastModified());
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
                Long localDate = Long.parseLong(formatter.format(date), 10);
                localDate = this.setTimeZone(localDate, localTimeZone);
                Long remoteDate = this.setTimeZone(Long.parseLong(remoteDateRaw), remoteTimeZone);
                if (remoteDate > localDate) {
                    FileOutputStream local = new FileOutputStream(newLocalPath);
                    ftpCli.retrieveFile(FtpUtils.removeFirstAndLastQuotes(this.getParameters()[0]), (OutputStream)local);
                    ((OutputStream)local).close();
                    this.defaultResponseManager(ftpCli, verbose, commandHandler);
                    this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.RETRIEVED_FILES_SIZE, localFile.length());
                } else {
                    BadSyntaxException exception = new BadSyntaxException(FtpCommandResponses.NEWER_RESPONSE_NOT_MORE_RECENT);
                    commandHandler.handleError("", exception);
                }
            } else {
                String errorMessage = ftpCli.getReplyString();
                commandHandler.handleError(errorMessage, new BadSyntaxException(errorMessage));
            }
        } else {
            BadSyntaxException exception = new BadSyntaxException(FtpCommandResponses.MISSING_PARAMETER);
            commandHandler.handleError("", exception);
        }
    }

    private Long setTimeZone(Long localDate, String timeZone) {
        if (timeZone.contains("+")) {
            return localDate - 10000L * Long.parseLong(timeZone.substring(timeZone.indexOf("+") + 1).replace("\n", "").replace("\r", ""));
        }
        if (timeZone.contains("-")) {
            return localDate + 10000L * Long.parseLong(timeZone.substring(timeZone.indexOf("-") + 1).replace("\n", "").replace("\r", ""));
        }
        return (long)localDate;
    }

    public String getTimeZone(String s) {
        if (s == null) {
            return "default";
        }
        return s;
    }
}

