/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.sftp.commands;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import com.stambia.ftp.commands.FtpCommand;
import com.stambia.ftp.exceptions.BadSyntaxException;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpCommandResponses;
import com.stambia.ftp.utils.FtpStatisticListener;
import com.stambia.ftp.utils.FtpUtils;
import com.stambia.sftp.commands.Messages;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class SFtpCommand_RENAME
extends FtpCommand<ChannelSftp> {
    public SFtpCommand_RENAME(String command, String[] parameters) {
        super(command, parameters);
    }

    public SFtpCommand_RENAME(FtpCommand<ChannelSftp> ftpCmd) {
        super(ftpCmd);
    }

    @Override
    public void executeCommand(ChannelSftp ftpCli, String localPath, boolean verbose, FtpCommandHandler commandHandler, List<FtpStatisticListener> statisticsListeners) throws IOException, FtpCommandException {
        String oldName = FtpUtils.removeFirstAndLastQuotes(this.getParameters()[0]);
        String newName = FtpUtils.removeFirstAndLastQuotes(this.getParameters()[1]);
        String replyString = String.valueOf(oldName) + Messages.getString("SFtpCommand_RENAME.0") + newName;
        if (newName != null) {
            if (oldName.contains("?") || oldName.contains("*") || oldName.contains("[")) {
                StringBuilder stringPattern = new StringBuilder();
                int i = 0;
                int cursor = 0;
                int tabs = 0;
                boolean isInGroup = true;
                while (i < oldName.length()) {
                    if (oldName.charAt(i) == '?' || oldName.charAt(i) == '*') {
                        ++i;
                        isInGroup = true;
                        ++tabs;
                        continue;
                    }
                    if (isInGroup) {
                        ++tabs;
                        isInGroup = false;
                    }
                    ++i;
                }
                String[] tab = new String[tabs];
                i = 0;
                int j = 0;
                while (i < oldName.length()) {
                    switch (oldName.charAt(i)) {
                        case '?': {
                            if (i != 0) {
                                tab[j++] = oldName.substring(cursor, i);
                            }
                            tab[j++] = "?";
                            stringPattern.append(oldName.substring(cursor, i));
                            stringPattern.append("?");
                            cursor = i + 1;
                            ++i;
                            break;
                        }
                        case '*': {
                            if (i != 0) {
                                tab[j++] = oldName.substring(cursor, i);
                            }
                            tab[j++] = "*";
                            stringPattern.append(oldName.substring(cursor, i));
                            stringPattern.append("*");
                            cursor = i + 1;
                            ++i;
                            break;
                        }
                        default: {
                            ++i;
                        }
                    }
                }
                if (cursor != i) {
                    stringPattern.append(oldName.substring(cursor, i));
                    tab[j] = oldName.substring(cursor, i);
                }
                try {
                    Vector fileList = ftpCli.ls(oldName);
                    if (fileList.isEmpty()) {
                        System.out.println(Messages.getString("SFtpCommand_RENAME.1"));
                    } else {
                        System.out.println(Messages.getString("SFtpCommand_RENAME.2"));
                        for (ChannelSftp.LsEntry file : fileList) {
                            String[] tab2 = new String[tabs];
                            String replacement = newName;
                            String fileName = file.getFilename();
                            int k = 0;
                            while (k < tabs) {
                                tab2[k] = tab[k] == "*" || tab[k] == "?" ? (k == 0 ? (tabs == 1 ? fileName : fileName.substring(0, fileName.indexOf(tab[1]))) : (k == tabs - 1 ? fileName.substring(fileName.indexOf(tab[k - 1]) + tab[k - 1].length()) : fileName.substring(fileName.indexOf(tab[k - 1]) + tab[k - 1].length(), fileName.indexOf(tab[k + 1])))) : "";
                                ++k;
                            }
                            int l = 0;
                            int k2 = 0;
                            while (k2 < tabs) {
                                if (newName.contains("\\" + l) && tab2[k2] != "") {
                                    replacement = replacement.replace("\\" + l, tab2[k2]);
                                    ++l;
                                }
                                ++k2;
                            }
                            System.out.println(String.valueOf(Messages.getString("SFtpCommand_RENAME.3")) + fileName + Messages.getString("SFtpCommand_RENAME.4") + replacement);
                            ftpCli.rename(fileName, replacement);
                        }
                    }
                }
                catch (SftpException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    ftpCli.rename(oldName, newName);
                    if (verbose) {
                        commandHandler.handleResponse(replyString);
                    }
                }
                catch (SftpException e) {
                    FtpCommandException ftpCommandException = new FtpCommandException(e.getMessage());
                    commandHandler.handleError("", ftpCommandException);
                }
            }
        } else {
            BadSyntaxException exception = new BadSyntaxException(FtpCommandResponses.MISSING_PARAMETER);
            commandHandler.handleError("", exception);
        }
    }
}

