/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.build;

import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.services.cache.CacheEventResource;
import com.semarchy.xdi.designer.core.services.cache.CacheEventURI;
import com.semarchy.xdi.designer.core.services.cache.ICacheListener;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;

public class BuilderVersionManager
implements ICacheListener {
    private Set<String> builtResourcesIds = Collections.synchronizedSet(new HashSet());
    private static final String dataFileName = "accurateVersionBuiltResourceIds";
    private boolean inited = false;
    private XDIModelURIResolver modelProvider;
    public Job saveJob = new Job(Messages.BuilderVersionManager_9){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                BuilderVersionManager.this.saveData();
            }
            catch (Throwable e) {
                e.printStackTrace();
                MapDiagramEditorPlugin.getInstance().logError(Messages.BuilderVersionManager_10, e);
            }
            return Status.OK_STATUS;
        }
    };

    public BuilderVersionManager() {
        this.modelProvider = (XDIModelURIResolver)E4InjectorHelper.getService(XDIModelURIResolver.class);
    }

    private void loadData() throws IOException {
        IPath bundleLocation = Platform.getStateLocation((Bundle)Platform.getBundle((String)"com.indy.gmf.map.diagram"));
        IPath p = bundleLocation.append(dataFileName);
        File f = p.toFile();
        if (f.exists()) {
            try (BufferedReader reader = null;){
                reader = new BufferedReader(new FileReader(f));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    String[] s;
                    String _id = line.trim();
                    if (_id.isEmpty() || (s = _id.split("=")).length != 2) continue;
                    String id = s[0];
                    String version = s[1];
                    if (!"1".equals(version)) continue;
                    try {
                        URI u = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getResourceURIByFileId(id);
                        if (u == null) continue;
                        this.builtResourcesIds.add(id);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveData() throws IOException {
        IPath bundleLocation = Platform.getStateLocation((Bundle)Platform.getBundle((String)"com.indy.gmf.map.diagram"));
        IPath p = bundleLocation.append(dataFileName);
        File f = p.toFile();
        String separator = System.getProperty("line.separator");
        try (PrintWriter writer = null;){
            writer = new PrintWriter(f);
            Set<String> set = this.builtResourcesIds;
            synchronized (set) {
                for (String id : this.builtResourcesIds) {
                    writer.write(id);
                    writer.write("=");
                    writer.write("1");
                    writer.write(separator);
                }
            }
            writer.flush();
        }
    }

    public void resourceBuildStateChanged(CacheEventResource event) {
        if (event.getEventType() == CacheEventResource.EventType.UNBUILT) {
            if (event.getType() == 1) {
                this.handleResourceUnBuilt(event.getResourceInfo());
            } else if (event.getType() == 2) {
                this.handleResourceBuilt(event.getResourceInfo());
            }
        }
    }

    private void handleResourceBuilt(URI uri) {
        String sourceId = this.getCacheSourceId(uri);
        if (sourceId != null) {
            this.builtResourcesIds.add(sourceId);
            this.handleEventsTriggered();
        } else {
            MapDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(2, "com.indy.gmf.map.diagram", String.valueOf(Messages.BuilderVersionManager_0) + uri));
        }
    }

    private void handleResourceUnBuilt(URI r) {
        String sourceId = this.getCacheSourceId(r);
        if (sourceId != null) {
            this.builtResourcesIds.remove(sourceId);
            this.handleEventsTriggered();
        } else {
            MapDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(2, "com.indy.gmf.map.diagram", String.valueOf(Messages.BuilderVersionManager_8) + r));
        }
    }

    public void resourceErrorStateChanged(CacheEventResource event) {
    }

    public boolean handleEvent(CacheEventResource event) {
        return this.inited && event.getEventType() == CacheEventResource.EventType.UNBUILT && this.modelProvider.exists(event.getResourceInfo());
    }

    public void handleEventsTriggered() {
        if (!this.inited) {
            this.init();
        } else {
            this.doSave();
        }
    }

    private void doSave() {
        this.saveJob.schedule(3000L);
    }

    /*
     * Unable to fully structure code
     */
    private void init() {
        block18: {
            block17: {
                v = new _WorkspaceVisitor();
                try {
                    ResourcesPlugin.getWorkspace().getRoot().accept((IResourceVisitor)v);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                toDestroy = new ArrayList<IResource>();
                try {
                    try {
                        this.loadData();
                        break block17;
                    }
                    catch (Exception var3_4) {
                        ** for (r : v.mappings)
                    }
                }
                catch (Throwable var4_23) {
                    ** for (r : v.mappings)
                }
lbl-1000:
                // 1 sources

                {
                    id = this.getCacheSourceId(URIUtils.convertIPathToEMFURI2((IPath)r.getFullPath()));
                    if (id == null || this.builtResourcesIds.contains(id)) continue;
                    relativeBasePath = r.getProjectRelativePath();
                    relativeBasePath = relativeBasePath.removeFileExtension();
                    basePath = new Path("indy.build");
                    i = 0;
                    while (i < relativeBasePath.segmentCount()) {
                        basePath = basePath.append("/" + URI.decode((String)relativeBasePath.segment(i)));
                        ++i;
                    }
                    md = r.getProject().findMember(basePath.addFileExtension("md"));
                    if (md != null && md.exists()) {
                        toDestroy.add(md);
                    }
                    if ((proc = r.getProject().findMember(basePath.addFileExtension("proc"))) == null || !proc.exists()) continue;
                    toDestroy.add(proc);
                    continue;
lbl32:
                    // 1 sources

                    break block18;
                }
lbl-1000:
                // 1 sources

                {
                    id = this.getCacheSourceId(URIUtils.convertIPathToEMFURI2((IPath)r.getFullPath()));
                    if (id == null || this.builtResourcesIds.contains(id)) continue;
                    relativeBasePath = r.getProjectRelativePath();
                    relativeBasePath = relativeBasePath.removeFileExtension();
                    basePath = new Path("indy.build");
                    i = 0;
                    while (i < relativeBasePath.segmentCount()) {
                        basePath = basePath.append("/" + URI.decode((String)relativeBasePath.segment(i)));
                        ++i;
                    }
                    md = r.getProject().findMember(basePath.addFileExtension("md"));
                    if (md != null && md.exists()) {
                        toDestroy.add(md);
                    }
                    if ((proc = r.getProject().findMember(basePath.addFileExtension("proc"))) == null || !proc.exists()) continue;
                    toDestroy.add(proc);
                    continue;
                }
lbl53:
                // 1 sources

                throw var4_23;
            }
            for (IResource r : v.mappings) {
                id = this.getCacheSourceId(URIUtils.convertIPathToEMFURI2((IPath)r.getFullPath()));
                if (id == null || this.builtResourcesIds.contains(id)) continue;
                relativeBasePath = r.getProjectRelativePath();
                relativeBasePath = relativeBasePath.removeFileExtension();
                basePath = new Path("indy.build");
                i = 0;
                while (i < relativeBasePath.segmentCount()) {
                    basePath = basePath.append("/" + URI.decode((String)relativeBasePath.segment(i)));
                    ++i;
                }
                md = r.getProject().findMember(basePath.addFileExtension("md"));
                if (md != null && md.exists()) {
                    toDestroy.add(md);
                }
                if ((proc = r.getProject().findMember(basePath.addFileExtension("proc"))) == null || !proc.exists()) continue;
                toDestroy.add(proc);
            }
        }
        if (!toDestroy.isEmpty()) {
            Logger.getLogger(BuilderVersionManager.class.getName()).fine("Deleting deprecated built files scheduled ...");
            destroyJob = new WorkspaceJob(Messages.BuilderVersionManager_17){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    MultiStatus ms = new MultiStatus("com.indy.gmf.map.diagram", 4, Messages.BuilderVersionManager_18, null);
                    Logger.getLogger(BuilderVersionManager.class.getName()).fine("Deleting deprecated built files ");
                    for (IResource r : toDestroy) {
                        try {
                            r.delete(true, monitor);
                        }
                        catch (Exception ex) {
                            ms.add((IStatus)new Status(4, "com.indy.gmf.map.diagram", String.valueOf(Messages.BuilderVersionManager_20) + r, (Throwable)ex));
                        }
                    }
                    if (ms.getChildren().length > 0) {
                        return ms;
                    }
                    return Status.OK_STATUS;
                }
            };
            combinedRule = null;
            ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            for (IResource r : toDestroy) {
                combinedRule = MultiRule.combine((ISchedulingRule)ruleFactory.deleteRule(r), combinedRule);
            }
            destroyJob.setRule(combinedRule);
            destroyJob.schedule();
        }
        this.inited = true;
    }

    private String getCacheSourceId(URI uri) {
        try {
            return ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getSourceId(uri);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void handleCacheSourceChanged(CacheEventURI event) {
    }

    public boolean handleEvent(CacheEventURI event) {
        return false;
    }

    private class _WorkspaceVisitor
    implements IResourceVisitor {
        List<IResource> mappings = new ArrayList<IResource>();

        private _WorkspaceVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 4 && !((IProject)resource).isOpen()) {
                return false;
            }
            if (resource.getType() == 2 && ("indy.build".equals(resource.getName()) || "indy.diagram".equals(resource.getName()))) {
                return false;
            }
            if (resource.getType() == 1 && "map".equals(resource.getFileExtension())) {
                this.mappings.add(resource);
            }
            return true;
        }
    }
}

