/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.build;

import com.indy.gmf.map.diagram.build.FullBuildVisitor;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;

public class ProjectConfigurationResourceListener
extends FullBuildVisitor
implements IResourceChangeListener,
IResourceDeltaVisitor,
IResourceVisitor {
    private List<IProject> project = Collections.synchronizedList(new ArrayList());

    public ProjectConfigurationResourceListener() {
        try {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                if (p.isOpen()) {
                    this.addStambiaConfiguration(p);
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (event.getType() == 2) {
            this.toBuild.clear();
            try {
                event.getResource().accept((IResourceVisitor)this);
            }
            catch (Exception ex) {
                MapDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "com.indy.gmf.map.diagram", Messages.ProjectConfigurationResourceListener_2, (Throwable)ex));
            }
            List<IProject> ex = this.project;
            synchronized (ex) {
                for (IFile f : this.toBuild) {
                    if (this.project.contains(f.getProject())) continue;
                    this.project.add(f.getProject());
                }
                if (!this.project.isEmpty() && !this.project.isEmpty()) {
                    JobBuildProject job = new JobBuildProject(new ArrayList<IProject>(this.project), true);
                    job.setSystem(true);
                    job.schedule();
                    this.project.clear();
                }
            }
        }
        try {
            delta.accept((IResourceDeltaVisitor)this);
        }
        catch (Exception ex) {
            MapDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "com.indy.gmf.map.diagram", Messages.ProjectConfigurationResourceListener_3, (Throwable)ex));
        }
        List<IProject> list = this.project;
        synchronized (list) {
            if (!this.project.isEmpty()) {
                JobBuildProject job = new JobBuildProject(new ArrayList<IProject>(this.project), true);
                job.setSystem(true);
                job.schedule();
                this.project.clear();
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta.getResource().getType() == 4 && (delta.getKind() == 1 || delta.getKind() == 4 && (delta.getFlags() & 0x4000) != 0)) {
            this.project.add((IProject)delta.getResource());
            return false;
        }
        return true;
    }

    private void addStambiaConfiguration(final IProject p) throws Exception {
        final IProjectDescription desc = p.getDescription();
        final ICommand[] commands = desc.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("com.indy.gmf.map.diagram.id1")) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            Logger.getLogger(this.getClass().getName()).fine(MessageFormat.format(Messages.ProjectConfigurationResourceListener_4, p));
            WorkspaceJob addStambiaBuilder = new WorkspaceJob(Messages.ProjectConfigurationResourceListener_5){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    ICommand command = desc.newCommand();
                    command.setBuilderName("com.indy.gmf.map.diagram.id1");
                    ICommand[] newCommands = new ICommand[commands.length + 1];
                    System.arraycopy(commands, 0, newCommands, 1, commands.length);
                    newCommands[0] = command;
                    desc.setBuildSpec(newCommands);
                    p.setDescription(desc, null);
                    return Status.OK_STATUS;
                }
            };
            addStambiaBuilder.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            addStambiaBuilder.schedule();
        }
    }

    private class JobBuildProject
    extends Job {
        private boolean addBuilder;
        private List<IProject> projects;

        public JobBuildProject(List<IProject> projects, boolean addBuilder) {
            super(Messages.ProjectConfigurationResourceListener_0);
            this.projects = projects;
            this.addBuilder = addBuilder;
            ISchedulingRule combinedRule = null;
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            for (IProject p : projects) {
                combinedRule = MultiRule.combine((ISchedulingRule)ruleFactory.createRule((IResource)p), combinedRule);
            }
            this.setRule(combinedRule);
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)this.projects.size());
            for (IProject p : this.projects) {
                try {
                    if (!p.isOpen() || !this.addBuilder) continue;
                    ProjectConfigurationResourceListener.this.addStambiaConfiguration(p);
                }
                catch (Exception e) {
                    MapDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "com.indy.gmf.map.diagram", String.valueOf(Messages.ProjectConfigurationResourceListener_1) + p.getName(), (Throwable)e));
                }
            }
            return Status.OK_STATUS;
        }
    }
}

