/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom;

import com.indy.gmf.map.edit.provider.custom.MapEditUtil;
import com.indy.gmf.map.edit.provider.custom.MapIconAPI;
import com.indy.map.Clause;
import com.indy.map.ComputedField;
import com.indy.map.Expression;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IMetaData;
import com.indy.map.IReferencable;
import com.indy.map.Map;
import com.indy.map.MapModelItem;
import com.indy.map.MapPackage;
import com.indy.map.QueryField;
import com.indy.map.Variable;
import com.indy.map.diagram.providers.MapElementTypes;
import com.indy.map.ref.RContainer;
import com.indy.map.ref.RLoadSet;
import com.indy.map.ref.RLogicalField;
import com.indy.ui.custom.out.services.IDropValidationService;
import com.indy.ui.sql.ISQLDictionary;
import com.indy.ui.sql.SQLDictionary;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class CompletionAdapterFactory
implements IAdapterFactory {
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == ISQLDictionary.class && (adaptableObject instanceof Expression || adaptableObject instanceof Clause || adaptableObject instanceof ComputedField)) {
            return this.adaptToSQLDictionary((EObject)adaptableObject);
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{ISQLDictionary.class};
    }

    private ISQLDictionary adaptToSQLDictionary(EObject adaptableObject) {
        Map map = null;
        if (adaptableObject instanceof EObject) {
            EObject cur = adaptableObject;
            while (cur != null && !(cur instanceof Map)) {
                cur = cur.eContainer();
            }
            if (cur instanceof Map) {
                map = (Map)cur;
            }
        }
        if (map == null) {
            return null;
        }
        ArrayList<IContainer> availables = new ArrayList<IContainer>();
        if (map != null && adaptableObject instanceof ComputedField) {
            IContainer c = (IContainer)((ComputedField)adaptableObject).eContainer();
            RLoadSet ls = ((RContainer)((IReferencable)c).getMapReference()).getLoadSet();
            if (ls != null) {
                availables.addAll((Collection<IContainer>)ls.getContainer());
            }
        } else if (map != null) {
            block6: for (IContainer c : map.getContainer()) {
                IDropValidationService dropService = (IDropValidationService)PlatformUI.getWorkbench().getService(IDropValidationService.class);
                if (c.getLogicalField().size() <= 0) continue;
                IDropValidationService.DropResult res = dropService.validate((EObject)c.getLogicalField().get(0), adaptableObject, false);
                switch (res) {
                    case JOIN_ALLOWED: {
                        if (!(adaptableObject instanceof Clause)) break;
                        availables.add(c);
                        break;
                    }
                    case MAP_ALLOWED: {
                        if (!(adaptableObject instanceof Expression)) break;
                        availables.add(c);
                        break;
                    }
                    case MAP_JOIN_ALLOWED: {
                        if (!(adaptableObject instanceof Expression) && !(adaptableObject instanceof Clause)) continue block6;
                        availables.add(c);
                    }
                }
            }
        }
        SQLDictionary dictionary = new SQLDictionary();
        for (IContainer source : availables) {
            dictionary.addItem((ISQLDictionary.Item)new MappingNode(source, false));
            if (source.getComputedAlias() == null) continue;
            dictionary.addItem((ISQLDictionary.Item)new MappingNode(source, true));
        }
        for (Variable variable : map.getVariable()) {
            dictionary.addItem((ISQLDictionary.Item)new MappingNode(variable));
        }
        return dictionary;
    }

    class MappingNode
    implements ISQLDictionary.Item {
        private WeakReference<MapModelItem> modelRef;
        private Image image = null;
        private boolean isComputedContainer;
        private boolean _childrenLoaded = false;
        private List<ISQLDictionary.Item> _children = new ArrayList<ISQLDictionary.Item>();

        public MappingNode(IContainer container, boolean isComputedContainer) {
            this.modelRef = new WeakReference<IContainer>(container);
            this.isComputedContainer = isComputedContainer;
        }

        public MappingNode(ILogicalField field) {
            this.modelRef = new WeakReference<MapModelItem>((MapModelItem)field);
        }

        public MappingNode(Variable variable) {
            this.modelRef = new WeakReference<Variable>(variable);
        }

        public Image getImage() {
            if (this.image == null) {
                MapModelItem modelItem = (MapModelItem)this.modelRef.get();
                if (modelItem instanceof IMetaData) {
                    this.image = modelItem instanceof QueryField ? MapElementTypes.getImage((ENamedElement)MapPackage.eINSTANCE.getQueryField()) : MapEditUtil.getImage((Object)((IMetaData)modelItem).getRef());
                } else if (modelItem instanceof Variable) {
                    this.image = MapIconAPI.getImage((String)"full/obj16/Variables16x16.png");
                } else if (modelItem instanceof ComputedField) {
                    this.image = MapIconAPI.getImage((String)"full/obj16/rdbms.computedField5.png");
                }
            }
            return this.image;
        }

        private void loadChildren() {
            if (!this._childrenLoaded) {
                MapModelItem modelItem = (MapModelItem)this.modelRef.get();
                if (modelItem instanceof IContainer) {
                    if (this.isComputedContainer) {
                        for (ComputedField f : ((IContainer)modelItem).getComputedField()) {
                            MappingNode n = null;
                            n = new MappingNode((ILogicalField)f);
                            this._children.add(n);
                        }
                    } else {
                        for (ILogicalField f : ((IContainer)modelItem).getLogicalField()) {
                            MappingNode n = null;
                            n = new MappingNode(f);
                            this._children.add(n);
                        }
                    }
                }
                this._childrenLoaded = true;
            }
        }

        public String getLabel() {
            Object data = this.getData();
            if (data instanceof IContainer) {
                return ((IContainer)data).getAlias().toString();
            }
            if (data instanceof ILogicalField) {
                return ((RLogicalField)((IReferencable)data).getMapReference()).getFullName();
            }
            if (data instanceof Variable) {
                return "%{" + ((Variable)data).getAlias().toString() + "}%";
            }
            return null;
        }

        public List<ISQLDictionary.Item> getChildren() {
            if (!this._childrenLoaded) {
                this.loadChildren();
            }
            return this._children;
        }

        public Object getData() {
            return this.modelRef.get();
        }
    }
}

