/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom;

import com.indy.gmf.map.diagram.custom.MapQuickInitDiagramFileAction;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.ILogicalField;
import com.indy.map.IMetaData;
import com.indy.map.IReferencable;
import com.indy.map.MapModelItem;
import com.indy.map.Query;
import com.indy.map.QueryField;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.map.diagram.part.MapDiagramEditorUtil;
import com.indy.map.diagram.part.MapVisualIDRegistry;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RItem;
import com.indy.map.ref.RProblem;
import com.indy.map.util.IMapResource;
import com.indy.ui.custom.out.EditorInputManager;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.gmf.StambiaGMFEditingDomainFactory;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.internal.mapmode.IdentityMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class MapDiagramUtil {
    public static Image errorIcon;
    public static Image warningIcon;
    public static Image infoIcon;
    static final Font FONT;
    private static IdentityMapMode mapMode;

    static {
        try {
            errorIcon = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.edit/icons/full/obj32x16/Error32x16.png")).createImage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            warningIcon = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.edit/icons/full/obj32x16/Warning32x16.png")).createImage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            infoIcon = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.edit/icons/full/obj32x16/Info32x16.png")).createImage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        FONT = new Font((Device)Display.getCurrent(), "Arial", 9, 0);
        mapMode = new IdentityMapMode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static URI createNewDiagram(URI domainModelURI, Shell _shell, boolean force) {
        Object res = null;
        Shell shell = _shell;
        if (shell == null) {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        TransactionalEditingDomain editingDomain = StambiaGMFEditingDomainFactory.instanceGMF.createEditingDomain();
        ResourceSet resourceSet = editingDomain.getResourceSet();
        resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        EObject diagramRoot = null;
        try {
            try {
                Resource resource = resourceSet.getResource(domainModelURI, true);
                diagramRoot = (EObject)resource.getContents().get(0);
            }
            catch (WrappedException ex) {
                MapDiagramEditorPlugin.getInstance().logError("Unable to load resource: " + domainModelURI, ex);
            }
            if (diagramRoot == null) {
                MessageDialog.openError((Shell)shell, (String)Messages.MapDiagramUtil_0, (String)Messages.MapDiagramUtil_1);
            }
            LinkedList affectedFiles = new LinkedList();
            IFile diagramFile = Util.convertEMFURIToFile((URI)EditorInputManager.getDiagramURI((URI)domainModelURI, (String)"map"));
            URI diagramModelURI = URI.createPlatformResourceURI((String)URI.decode((String)diagramFile.getFullPath().toString()), (boolean)true);
            if (!diagramFile.exists() || force) {
                Resource diagramResource;
                block34: {
                    String str = "";
                    diagramResource = resourceSet.createResource(diagramModelURI);
                    final EObject firstEement = (EObject)diagramRoot.eContents().get(0);
                    RecordingCommand command = new RecordingCommand(editingDomain, ""){

                        protected void doExecute() {
                            int diagramVID = MapVisualIDRegistry.getDiagramVisualID(firstEement);
                            if (diagramVID != 1000) {
                                throw new RuntimeException(Messages.MapDiagramUtil_6);
                            }
                            Diagram diagram = ViewService.createDiagram((EObject)firstEement, (String)"Map", (PreferencesHint)MapDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                            diagramResource.getContents().add((Object)diagram);
                        }
                    };
                    try {
                        try {
                            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                            options.put("no_undo", Boolean.TRUE);
                            ((TransactionalCommandStack)editingDomain.getCommandStack()).execute((Command)command, options);
                            diagramResource.save(MapDiagramEditorUtil.getSaveOptions());
                            editingDomain.getCommandStack().flush();
                        }
                        catch (Exception ex) {
                            MapDiagramEditorPlugin.getInstance().logError("Save operation failed for: " + diagramModelURI, ex);
                            command.dispose();
                            break block34;
                        }
                    }
                    catch (Throwable throwable) {
                        command.dispose();
                        throw throwable;
                    }
                    command.dispose();
                }
                URI uRI = diagramResource.getURI();
                return uRI;
            }
            URI uRI = resourceSet.getResource(diagramModelURI, true).getURI();
            return uRI;
        }
        finally {
            try {
                try {
                    for (Resource r : editingDomain.getResourceSet().getResources()) {
                        r.unload();
                    }
                    editingDomain.getResourceSet().getResources().clear();
                    return null;
                }
                catch (Exception r) {
                    editingDomain.dispose();
                }
                return null;
            }
            finally {
                editingDomain.dispose();
            }
        }
    }

    public static URI getDiagramURI(URI modelURI) {
        String diagramfileName = "." + modelURI.lastSegment().replaceAll(modelURI.fileExtension(), String.valueOf(modelURI.fileExtension()) + "_diagram");
        return modelURI.trimSegments(1).appendSegment(diagramfileName);
    }

    public static void createAndOpenDiagram(URI modelURI, Shell shell) {
        final URI domainModelURI = modelURI;
        URI _diagramURI = MapDiagramUtil.getDiagramURI(modelURI);
        try {
            final Shell shell2 = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            new ProgressMonitorDialog(shell).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    TransactionalEditingDomain editingDomain = StambiaGMFEditingDomainFactory.instanceGMF.createEditingDomain();
                    ResourceSet resourceSet = editingDomain.getResourceSet();
                    resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
                    EObject diagramRoot = null;
                    try {
                        Resource resource = resourceSet.getResource(domainModelURI, true);
                        diagramRoot = (EObject)resource.getContents().get(0);
                    }
                    catch (WrappedException ex) {
                        MapDiagramEditorPlugin.getInstance().logError("Unable to load resource: " + domainModelURI, ex);
                    }
                    LinkedList<IFile> affectedFiles = new LinkedList<IFile>();
                    IFile diagramFile = MapDiagramUtil.createDiagramFile(diagramRoot);
                    MapDiagramEditorUtil.setCharset(diagramFile);
                    affectedFiles.add(diagramFile);
                    URI diagramModelURI = Util.convertIPathToEMFURI2((IPath)diagramFile.getFullPath());
                    URI diagramResourceURI = MapDiagramEditorUtil.createDiagram(diagramModelURI, domainModelURI, monitor, shell2).getURI();
                    try {
                        try {
                            MapDiagramEditorUtil.openDiagram(diagramResourceURI);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            editingDomain.dispose();
                        }
                    }
                    finally {
                        editingDomain.dispose();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static IFile createDiagramFile2(EObject eo, Shell shell) {
        final Shell _shell = shell;
        String str = "";
        final IFile newFileHandle = MapDiagramUtil.createDiagramFile(eo);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                CreateFileOperation op = new CreateFileOperation(newFileHandle, null, null, "");
                try {
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)_shell));
                }
                catch (ExecutionException e) {
                    _shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (e.getCause() instanceof CoreException) {
                                ErrorDialog.openError((Shell)_shell, (String)"", null, (IStatus)((CoreException)e.getCause()).getStatus());
                            } else {
                                IDEWorkbenchPlugin.log(this.getClass(), (String)"createNewFile()", (Throwable)e.getCause());
                                MessageDialog.openError((Shell)_shell, (String)"", (String)NLS.bind((String)"", (Object)e.getCause().getMessage()));
                            }
                        }
                    });
                }
            }
        };
        try {
            new ProgressMonitorDialog(shell).run(true, true, op);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log(MapQuickInitDiagramFileAction.class, (String)"createNewFile()", (Throwable)e.getTargetException());
            MessageDialog.openError((Shell)_shell, (String)"", (String)NLS.bind((String)"", (Object)e.getTargetException().getMessage()));
            return null;
        }
        return newFileHandle;
    }

    public static IFile createDiagramFile(EObject eo) {
        IMapResource r = (IMapResource)eo.eResource();
        String str = r.getProcDiagramURI().toPlatformString(true);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(str));
        return file;
    }

    public static Image getProblemTypeIcon(RProblem p) {
        if (p.getProblemType() == RProblem.Type.ERROR) {
            return errorIcon;
        }
        if (p.getProblemType() == RProblem.Type.WARNING) {
            return warningIcon;
        }
        if (p.getProblemType() == RProblem.Type.INFO) {
            return infoIcon;
        }
        return null;
    }

    public static IFigure updateExpressionToolTip(MapModelItem expression) {
        ArrayList<WrappingLabel> tooltipFigures = new ArrayList<WrappingLabel>();
        if (expression != null && expression instanceof IReferencable) {
            EObject obj;
            WrappingLabel l;
            RItem it = (RItem)((IReferencable)expression).getMapReference();
            if (it != null) {
                for (RProblem p : it.getProblem()) {
                    if (p.getProblemType().ordinal() <= RProblem.Type.NONE.ordinal()) continue;
                    l = new WrappingLabel(p.getErrorMessage(), MapDiagramUtil.getProblemTypeIcon(p));
                    l.setFont(FONT);
                    l.setTextWrap(true);
                    l.setIconAlignment(8);
                    tooltipFigures.add(l);
                }
            }
            if (expression instanceof ILogicalField) {
                for (Expression e : ((ILogicalField)expression).getExpression()) {
                    RExpression rExp = (RExpression)e.getMapReference();
                    if (rExp == null) continue;
                    for (RProblem p : ((RExpression)e.getMapReference()).getProblem()) {
                        if (p.getProblemType().ordinal() <= RProblem.Type.NONE.ordinal()) continue;
                        WrappingLabel l2 = new WrappingLabel(p.getErrorMessage(), MapDiagramUtil.getProblemTypeIcon(p));
                        l2.setTextWrap(true);
                        l2.setFont(FONT);
                        l2.setIconAlignment(8);
                        tooltipFigures.add(l2);
                    }
                }
            }
            if (it != null && expression instanceof IMetaData && !(expression instanceof Query) && it.getProblem(RProblem.ERROR_PROXY_FIELDS) == null && !(expression instanceof QueryField) && (((IMetaData)expression).getRef() == null || ((IMetaData)expression).getRef().eIsProxy())) {
                WrappingLabel l3 = new WrappingLabel(Messages.MapDiagramUtil_13, errorIcon);
                l3.setFont(FONT);
                tooltipFigures.add(l3);
            }
            if (expression instanceof Field && (obj = ((Field)expression).getRef()) instanceof MdNode && !obj.eIsProxy()) {
                MdNode mdNode = (MdNode)obj;
                if (!((Field)expression).getName().equals(mdNode.getName()) && mdNode.getName() != null) {
                    l = new WrappingLabel(Messages.MapDiagramUtil_14, warningIcon);
                    l.setFont(FONT);
                    tooltipFigures.add(l);
                } else if (!((Field)expression).getName().equals(mdNode.getName()) && !mdNode.getAttribute().isEmpty()) {
                    String value = ((Attribute)mdNode.getAttribute().get(0)).getValue();
                    if (!((Field)expression).getName().equals(value)) {
                        WrappingLabel l4 = new WrappingLabel(Messages.MapDiagramUtil_14, warningIcon);
                        l4.setFont(FONT);
                        tooltipFigures.add(l4);
                    }
                }
            }
        }
        if (tooltipFigures.isEmpty()) {
            return null;
        }
        TooltipFigure2 f = new TooltipFigure2();
        ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout(false);
        layout.setStretchMajorAxis(false);
        layout.setStretchMinorAxis(false);
        f.setLayoutManager((LayoutManager)layout);
        for (IFigure iFigure : tooltipFigures) {
            f.add(iFigure);
        }
        return f;
    }

    public static class TooltipFigure2
    extends Figure
    implements IMapMode {
        public int LPtoDP(int logicalUnit) {
            return mapMode.LPtoDP(logicalUnit);
        }

        public int DPtoLP(int deviceUnit) {
            return mapMode.DPtoLP(deviceUnit);
        }

        public Translatable LPtoDP(Translatable t) {
            return mapMode.LPtoDP(t);
        }

        public Translatable DPtoLP(Translatable t) {
            return mapMode.DPtoLP(t);
        }
    }
}

