/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.actions;

import com.indy.gmf.map.diagram.custom.edit.parts.LinkEditPart;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.gmf.map.edit.provider.custom.MapIconAPI;
import com.indy.map.DataSet;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.MapFactory;
import com.indy.map.MapPackage;
import com.indy.map.Outliner;
import com.indy.map.SetDescriptor;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateOrSelectElementCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class AutomaticMap
implements IObjectActionDelegate {
    private WeakReference<IGraphicalEditPart> selectedRef;

    public void run(IAction action) {
        EObject obj;
        LinkEditPart ep = (LinkEditPart)this.selectedRef.get();
        if (ep != null && (obj = ((View)ep.getModel()).getElement()) instanceof DataSet && ((DataSet)obj).getContainer().size() == 1) {
            IContainer src = (IContainer)((DataSet)obj).getContainer().get(0);
            IGraphicalEditPart trgEp = (IGraphicalEditPart)ep.getSource();
            IContainer trg = (IContainer)trgEp.resolveSemanticElement();
            AutomappingCommand cmd = new AutomappingCommand((List)((IContainer)trgEp.resolveSemanticElement()).getSetDescriptor(), ((IGraphicalEditPart)this.selectedRef.get()).getRoot().getViewer().getEditDomain(), src, trg, null);
            ((IGraphicalEditPart)this.selectedRef.get()).getRoot().getViewer().getEditDomain().getCommandStack().execute((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)cmd));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            this.selectedRef = null;
            if (action != null) {
                action.setEnabled(false);
            }
            return;
        }
        IGraphicalEditPart gep = (IGraphicalEditPart)((StructuredSelection)selection).getFirstElement();
        View view = gep.getNotationView();
        if (!"targetDataSetLink".equals(view.getType()) || view.getElement() instanceof DataSet && ((DataSet)view.getElement()).getContainer().size() > 1) {
            this.selectedRef = null;
            if (action != null) {
                action.setEnabled(false);
            }
            return;
        }
        this.selectedRef = new WeakReference<IGraphicalEditPart>(gep);
        if (action != null) {
            action.setEnabled(true);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public static class AutomappingCommand
    extends CreateOrSelectElementCommand {
        private AbstractTransactionalCommand mappingCommand;
        private Object firstItem;
        private IContainer src;
        private IContainer trg;
        private EditDomain domain;
        private ILogicalField ignoredSrcField;

        public AutomappingCommand(List list, EditDomain domain, IContainer src, IContainer trg, ILogicalField ignoredSrcField) {
            super(Messages.AutomaticMap_0, Display.getCurrent().getActiveShell(), list, 1);
            if (list.size() == 1) {
                this.firstItem = list.get(0);
            }
            this.domain = domain;
            this.src = src;
            this.trg = trg;
            this.ignoredSrcField = ignoredSrcField;
        }

        public void dispose() {
            this.ignoredSrcField = null;
            this.firstItem = null;
            if (this.mappingCommand != null) {
                this.mappingCommand.dispose();
            }
            this.mappingCommand = null;
            this.domain = null;
            super.dispose();
        }

        protected ILabelProvider getLabelProvider() {
            return new CreateOrSelectElementCommand.LabelProvider(){

                public String getText(Object object) {
                    if (object == null || ((SetDescriptor)object).getLabel() == null) {
                        return "";
                    }
                    return ((SetDescriptor)object).getLabel().toString();
                }

                public Image getImage(Object object) {
                    return MapIconAPI.getEnableSetDescriptor();
                }
            };
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            if (this.firstItem == null) {
                if (this.trg.getSetDescriptor().size() == 1) {
                    this.firstItem = this.trg.getSetDescriptor().get(0);
                } else if (!this.trg.getSetDescriptor().isEmpty()) {
                    this.setPopupMenu(new PopupMenu((List)this.trg.getSetDescriptor(), this.getLabelProvider()){

                        public boolean show(Control parent) {
                            Menu menu = new Menu(parent);
                            this.createMenuItems(menu, this, new ArrayList());
                            menu.setVisible(true);
                            Display display = menu.getDisplay();
                            while (display.readAndDispatch()) {
                            }
                            menu.dispose();
                            return this.getResult() != null;
                        }
                    });
                }
            }
            if (this.firstItem == null) {
                super.doExecuteWithResult(progressMonitor, info);
            }
            List<Object> sets = Collections.singletonList(this.firstItem != null ? this.firstItem : this.getResultAdapter().getAdapter(SetDescriptor.class));
            final CompoundCommand cc = new CompoundCommand();
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.trg);
            block0: for (ILogicalField field : this.src.getLogicalField()) {
                if (field == this.ignoredSrcField) continue;
                for (ILogicalField f : this.trg.getLogicalField()) {
                    if (f instanceof Field && this.trg instanceof Outliner || !field.getLabel().toUpperCase().equals(f.getLabel().toUpperCase())) continue;
                    for (SetDescriptor setDescriptor : sets) {
                        Expression expr = f.getExpression(setDescriptor);
                        if (expr == null) {
                            expr = MapFactory.eINSTANCE.createExpression();
                            expr.setSetDescriptorRef(setDescriptor);
                            cc.append((Command)new AddCommand((EditingDomain)domain, (EObject)field, (EStructuralFeature)(field instanceof Field ? MapPackage.eINSTANCE.getField_Expression() : MapPackage.eINSTANCE.getQueryField_Expression()), (Object)expr));
                            cc.append((Command)new SetCommand((EditingDomain)domain, (EObject)expr, (EStructuralFeature)MapPackage.eINSTANCE.getExpression_Expression(), (Object)field.getFullPath()));
                            continue;
                        }
                        if (expr.getExpression() != null && !expr.getExpression().trim().isEmpty()) continue block0;
                        cc.append((Command)new SetCommand((EditingDomain)domain, (EObject)expr, (EStructuralFeature)MapPackage.eINSTANCE.getExpression_Expression(), (Object)field.getFullPath()));
                    }
                    continue block0;
                }
            }
            this.mappingCommand = new AbstractTransactionalCommand(domain, "", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    this.getEditingDomain().getCommandStack().execute((Command)cc);
                    return CommandResult.newOKCommandResult();
                }
            };
            if (!cc.isEmpty()) {
                this.domain.getCommandStack().execute((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)this.mappingCommand));
            }
            return CommandResult.newOKCommandResult();
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            if (this.mappingCommand != null) {
                this.mappingCommand.undo(progressMonitor, info);
            }
            return super.doUndoWithResult(progressMonitor, info);
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            if (this.mappingCommand != null) {
                this.mappingCommand.redo(progressMonitor, info);
            }
            return super.doRedoWithResult(progressMonitor, info);
        }
    }
}

