/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.actions;

import com.indy.gmf.map.diagram.custom.actions.RemoveContainerFromDataSet;
import com.indy.gmf.map.diagram.custom.edit.parts.InheritanceLinkEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.LinkEditPart;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.Join;
import com.indy.map.diagram.edit.parts.JoinEditPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.ui.IWorkbenchPart;

public class RemoveJoinLeftFromDatasetAction
extends RemoveContainerFromDataSet {
    private boolean isLeft = true;
    public static final String LEFT_ID = "removeJoinLeftContainerFromDataSet";
    public static final String RIGHT_ID = "removeJoinRightContainerFromDataSet";
    private static final String baseText = Messages.RemoveJoinLeftFromDatasetAction_2;
    private static final String baseEndText = Messages.RemoveJoinLeftFromDatasetAction_3;

    public RemoveJoinLeftFromDatasetAction(IWorkbenchPart workbenchpart, boolean isLeft) {
        super(workbenchpart);
        this.isLeft = isLeft;
    }

    public int getStyle() {
        return 8;
    }

    @Override
    public void init() {
        super.init();
        if (this.isLeft) {
            this.setId(LEFT_ID);
        } else {
            this.setId(RIGHT_ID);
        }
        this.setText(baseText);
        super.setEnabled(true);
    }

    public void refresh() {
        super.refresh();
        List operationSet = this.getOperationSet();
        for (EditPart editPart : operationSet) {
            if (!(editPart instanceof JoinEditPart)) continue;
            Join j = (Join)((IGraphicalEditPart)editPart).resolveSemanticElement();
            if (!j.isInheritance()) {
                if (this.isLeft && j.getLeft() != null) {
                    this.setText(String.valueOf(baseText) + j.getLeft().getAlias() + baseEndText);
                } else if (j.getRight() != null) {
                    this.setText(String.valueOf(baseText) + j.getRight().getAlias() + baseEndText);
                }
                this.setChecked(false);
                break;
            }
            if (this.isLeft && j.getRight() != null) {
                this.setText(String.valueOf(baseText) + j.getRight().getAlias() + baseEndText);
                this.setChecked(j.getLeft() != null && j.getRight().getDataset().getParent().contains((Object)j.getLeft().getDataset()));
                break;
            }
            if (j.getLeft() == null) break;
            this.setText(String.valueOf(baseText) + j.getLeft().getAlias() + baseEndText);
            this.setChecked(j.getRight() != null && j.getLeft().getDataset().getParent().contains((Object)j.getRight().getDataset()));
            break;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    protected List getTargetEditParts(EditPart editPart) {
        ArrayList<EditPart> l = new ArrayList<EditPart>();
        if (editPart instanceof JoinEditPart) {
            l.add(editPart);
        }
        return l;
    }

    @Override
    protected Command getCommand(Request request) {
        List operationSet = this.getOperationSet();
        if (operationSet.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        Iterator editParts = operationSet.iterator();
        EditPart trgEp = null;
        while (editParts.hasNext()) {
            EObject container;
            EditPart editPart = (EditPart)editParts.next();
            if (!(editPart instanceof JoinEditPart)) continue;
            JoinEditPart jep = (JoinEditPart)editPart;
            Join j = (Join)jep.resolveSemanticElement();
            if (j.getInvolvedContainers().size() == 2 && !j.isInheritance()) {
                ConnectionEditPart lep = null;
                for (Object o : jep.getSourceConnections()) {
                    if (!(o instanceof LinkEditPart) || !"joinLink".equals(((LinkEditPart)o).getNotationView().getType()) || lep != null) continue;
                    lep = (ConnectionEditPart)o;
                    trgEp = lep.getTarget();
                    container = ((IGraphicalEditPart)trgEp).resolveSemanticElement();
                    if (this.isLeft) {
                        if (container == j.getLeft()) continue;
                        lep = null;
                        continue;
                    }
                    if (container == j.getRight()) continue;
                    lep = null;
                }
                if (trgEp == null) continue;
                RemoveContainerFromDataSet.RemoveFromDataSetRequest r = new RemoveContainerFromDataSet.RemoveFromDataSetRequest(this.isLeft);
                r.setSelectedObject(j, Collections.singletonList(trgEp));
                Command curCommand = trgEp.getCommand((Request)r);
                return curCommand;
            }
            if (!j.isInheritance()) continue;
            for (Object o : jep.getSourceConnections()) {
                if (!(o instanceof InheritanceLinkEditPart)) continue;
                ConnectionEditPart lep = (ConnectionEditPart)o;
                trgEp = lep.getTarget();
                container = ((IGraphicalEditPart)trgEp).resolveSemanticElement();
                if (this.isLeft ? container != j.getLeft() : container != j.getRight()) {
                    return UnexecutableCommand.INSTANCE;
                }
                Command curCommand = ((InheritanceLinkEditPart)((Object)o)).getCommand(new Request((Object)"com.indy.gmf.map.diagram.custom.edit.policies.InheritanceConnectionEditPolicy.flipLink"));
                return curCommand;
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    protected boolean isFromLeftToRight() {
        return this.isLeft;
    }
}

