/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.actions.handler;

import com.indy.gmf.proc.diagram.non_rcp.custom.cpypaste.DuplicateAnythingCommand;
import com.indy.map.Clause;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.custom.commands.UpdateContainerAliasCommand;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;

class MappigDuplicateAnythingCommand
extends DuplicateAnythingCommand {
    Map<QName, QName> aliasOldToNew = new HashMap<QName, QName>();
    Set<EObject> copiedObject = new HashSet<EObject>();

    public MappigDuplicateAnythingCommand(TransactionalEditingDomain editingDomain, Diagram diagram) {
        super(editingDomain, diagram);
    }

    public void dispose() {
        this.aliasOldToNew.clear();
        this.copiedObject.clear();
        super.dispose();
    }

    protected void doUpdate(EObject original, EObject duplicate) {
        if (duplicate instanceof IContainer) {
            QName oldContainerAlias = ((IContainer)duplicate).getAlias();
            boolean needAliasUpdate = ((com.indy.map.Map)duplicate.eContainer()).getContainer().stream().anyMatch(c -> c != duplicate && c.getAlias().toString().equals(oldContainerAlias.toString()));
            if (needAliasUpdate) {
                QName newContainerAlias = new QName(((com.indy.map.Map)duplicate.eContainer()).createNewContainerAlias(oldContainerAlias.toString(), 1));
                ((IContainer)duplicate).setAlias(newContainerAlias);
                this.aliasOldToNew.put(oldContainerAlias, newContainerAlias);
            }
        }
        this.copiedObject.add(duplicate);
    }

    protected void doPostCopy() {
        this.copiedObject.stream().filter(IContainer.class::isInstance).forEach(c -> this.updateContainerExpressions((IContainer)c));
        this.copiedObject.stream().filter(Clause.class::isInstance).map(c -> (Clause)c).forEach(c -> c.setExpression(this.updateExpression(c.getExpression())));
    }

    private void updateContainerExpressions(IContainer c) {
        for (ILogicalField l : c.getAllLogicalField()) {
            l.getExpression().stream().filter(e -> e.getExpression() != null && !e.getExpression().isEmpty()).forEach(e -> e.setExpression(this.updateExpression(e.getExpression())));
        }
        c.getTargetFilter().stream().filter(e -> e.getExpression() != null && !e.getExpression().isEmpty()).forEach(t -> t.setExpression(this.updateExpression(t.getExpression())));
    }

    private String updateExpression(String expression) {
        String res = expression;
        for (Map.Entry<QName, QName> e : this.aliasOldToNew.entrySet()) {
            res = UpdateContainerAliasCommand.replaceInExpression((QName)e.getKey(), (QName)e.getValue(), (String)res);
        }
        return res;
    }
}

