/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.commands;

import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.gmf.proc.diagram.non_rcp.custom.ProcDiagramUtil;
import com.indy.gmf.proc.diagram.non_rcp.part.ProcDiagramEditorUtil;
import com.indy.map.DocumentRoot;
import com.indy.map.Map;
import com.indy.map.custom.commands.RefreshAllRefCommand;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.ui.custom.out.BuildMenuOperationDispatcher;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.gmf.StambiaGMFEditingDomainFactory;
import com.indy.ui.custom.out.tools.ApplicationHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class ExecuteActionMapHandler
extends AbstractHandler {
    private static final String GENERIC_LOG_MESSAGE = "unexpected";
    private static final String PARAMETER_ID = "com.indy.ui.custom.out.commandParameter6";
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IFile f = ApplicationHelper.getSelectedFile((ExecutionEvent)event);
        if (f == null || !ApplicationHelper.saveDirtyEditorFor((IFile)f)) {
            return null;
        }
        URI mapResourceUri = Util.convertIFileToEMFURI((IFile)f);
        URI procResourceURI = URIUtils.getMappingBuiltProcFile((URI)mapResourceUri);
        URI mdResourceURI = URIUtils.getMappingBuiltMdFile((URI)mapResourceUri);
        IEditorPart ed = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)new URIEditorInput(procResourceURI));
        if (ed != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(ed, false);
        }
        this.synchronizeJobs(Util.convertEMFURIToFile((URI)mdResourceURI), Util.convertEMFURIToFile((URI)procResourceURI));
        URI processURI = URIUtils.getMappingBuiltProcFile((URI)mapResourceUri);
        String paramValue = event.getParameter(PARAMETER_ID);
        if (paramValue == null) {
            paramValue = "ExecuteProc";
        }
        BuildMenuOperationDispatcher.OperationKey operation = BuildMenuOperationDispatcher.OperationKey.of((String)paramValue);
        try {
            if (operation.applyOpenProcessPolicy() && !this.openProcessIfRequired(operation, mapResourceUri, processURI)) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)event.getCommand().getName(), (String)Messages.ExecuteActionMapHandler_9);
                return null;
            }
        }
        catch (Exception ex) {
            MapDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "com.indy.gmf.map.diagram", ex.getMessage(), (Throwable)ex));
        }
        if (!BuildMenuOperationDispatcher.performOperation((BuildMenuOperationDispatcher.OperationKey)operation, Collections.singletonList(processURI)) && operation == BuildMenuOperationDispatcher.OperationKey.REBUILD_REF) {
            this.rebuildMappingReferences(mapResourceUri);
        }
        return null;
    }

    private void synchronizeJobs(IFile mdFile, IFile procFile) {
        IProgressMonitor monitor = Job.getJobManager().createProgressGroup();
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        ISchedulingRule combinedRule = null;
        combinedRule = MultiRule.combine((ISchedulingRule)ruleFactory.createRule((IResource)mdFile), combinedRule);
        combinedRule = MultiRule.combine((ISchedulingRule)ruleFactory.createRule((IResource)procFile), (ISchedulingRule)combinedRule);
        try {
            monitor.beginTask(Messages.ExecuteActionMapHandler_waitTask, 3);
            monitor.subTask(Messages.ExecuteActionMapHandler_lockTask);
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    monitor.worked(1);
                }
            }, combinedRule, 1, monitor);
        }
        catch (Exception ex) {
            this.handle(ex);
        }
        try {
            monitor.subTask(Messages.ExecuteActionMapHandler_lcokAtutoBuild);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
            monitor.worked(1);
        }
        catch (Exception ex) {
            this.handle(ex);
        }
        try {
            monitor.subTask(Messages.ExecuteActionMapHandler_lockManual);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, monitor);
            monitor.worked(1);
        }
        catch (Exception ex) {
            this.handle(ex);
        }
        try {
            monitor.subTask(Messages.ExecuteActionMapHandler_lockManual);
            Job.getJobManager().join((Object)"MAPPING_BUILD_JOB_FAMILY", monitor);
        }
        catch (Exception ex) {
            this.handle(ex);
        }
        monitor.done();
    }

    private void handle(Exception ex) {
        if (ex instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.warn(GENERIC_LOG_MESSAGE, (Throwable)ex);
        }
    }

    private boolean shouldOpenProcess() {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        State s = service.getCommand("com.indy.ui.custom.out.command.openProcessPolicyCommand").getState("org.eclipse.ui.commands.toggleState");
        return s.getValue() != null && (Boolean)s.getValue() != false;
    }

    private boolean openProcessIfRequired(BuildMenuOperationDispatcher.OperationKey opration, URI mapResourceUri, URI processURI) throws Exception {
        block7: {
            if (!this.shouldOpenProcess() && opration != BuildMenuOperationDispatcher.OperationKey.OPEN) {
                return true;
            }
            IFile mapFile = Util.convertEMFURIToFile((URI)mapResourceUri);
            try {
                IMarker[] markers = mapFile.findMarkers("com.stambia.resource.marker.invalidbuild", true, 2);
                if (markers != null && markers.length > 0) {
                    return false;
                }
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) break block7;
                this.logger.warn(GENERIC_LOG_MESSAGE, (Throwable)ex);
            }
        }
        try {
            EObject eo;
            Resource diagramResource = ProcDiagramUtil.createNewDiagram((URI)processURI, (boolean)false);
            if (!diagramResource.getContents().isEmpty() && (eo = ((Diagram)diagramResource.getContents().get(0)).getElement()).eIsProxy() && MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ExecuteActionMapHandler_19, (String)Messages.ExecuteActionMapHandler_20)) {
                diagramResource.unload();
                diagramResource.getResourceSet().getResources().remove((Object)diagramResource);
                diagramResource = ProcDiagramUtil.createNewDiagram((URI)processURI, (boolean)true);
            }
            ProcDiagramEditorUtil.openDiagram((Resource)diagramResource);
        }
        catch (Exception e) {
            MapDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "com.indy.gmf.map.diagram", Messages.ExecuteActionMapHandler_21, (Throwable)e));
        }
        return true;
    }

    private void rebuildMappingReferences(URI mapResourceUri) {
        TransactionalEditingDomain editingDomain = StambiaGMFEditingDomainFactory.instanceGMF.createEditingDomain();
        editingDomain.getResourceSet().getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        try {
            Resource r = editingDomain.getResourceSet().getResource(mapResourceUri, false);
            if (r == null) {
                r = editingDomain.getResourceSet().getResource(mapResourceUri, true);
            }
            Map map = ((DocumentRoot)r.getContents().get(0)).getMap();
            RefreshAllRefCommand command = new RefreshAllRefCommand(editingDomain, map);
            editingDomain.getCommandStack().execute((Command)command);
        }
        finally {
            editingDomain.dispose();
        }
    }
}

