/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.parts;

import com.indy.gmf.map.diagram.custom.MapDiagramUtil;
import com.indy.gmf.map.diagram.custom.edit.parts.ContainerEditPart;
import com.indy.gmf.map.diagram.custom.edit.policies.ActiveHierarchyEditPolicy;
import com.indy.gmf.map.diagram.custom.edit.policies.SetEditPolicy;
import com.indy.gmf.map.diagram.custom.figures.LogicalFieldFigure;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.ILogicalField;
import com.indy.map.IReferencable;
import com.indy.map.ItemProperty;
import com.indy.map.MapModelItem;
import com.indy.map.MapPackage;
import com.indy.map.Outliner;
import com.indy.map.SetDescriptor;
import com.indy.map.ref.RItem;
import com.indy.map.ref.RefPackage;
import com.stambia.md.MdNode;
import com.stambia.tech.Level;
import com.stambia.tech.MappingType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.common.ui.util.StatusLineUtil;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.label.ILabelDelegate;
import org.eclipse.gmf.runtime.diagram.ui.label.WrappingLabelDelegate;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public abstract class LogicalFieldEditPart
extends CompartmentEditPart {
    private List<String> additionalSemanticListenerFilterIds = new ArrayList<String>();
    private ILabelDelegate labelDelegate;
    private Adapter refAdapter = new EContentAdapter(){

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            LogicalFieldEditPart.this.handleNotificationEvent(msg);
        }
    };
    private DragTracker dragTracker = null;

    public LogicalFieldEditPart(View view) {
        super((EObject)view);
    }

    protected IFigure createFigurePrim() {
        this.labelDelegate = null;
        return new LogicalFieldFigure();
    }

    protected abstract void refreshLabel();

    protected String getFieldLabel() {
        String text = null;
        EObject parserElement = this.getParserElement();
        if (parserElement != null && this.getParser() != null) {
            text = this.getParser().getPrintString((IAdaptable)new EObjectAdapter(parserElement), this.getParserOptions().intValue());
        }
        if (text == null || text.length() == 0) {
            text = "";
        }
        return text;
    }

    protected String getLabelText() {
        String text = this.getFieldLabel();
        String val = this.getCurrentExpressionValue();
        if (!val.trim().isEmpty()) {
            text = String.valueOf(text) + " : " + val;
        }
        return text;
    }

    public abstract ParserOptions getParserOptions();

    public abstract IParser getParser();

    protected abstract EObject getParserElement();

    protected String getCurrentExpressionValue() {
        Expression expr;
        SetDescriptor desc;
        SetEditPolicy policy;
        Expression expr2;
        SetDescriptor desc2;
        EObject o = this.getParserElement();
        if (!(o instanceof ILogicalField)) {
            return "";
        }
        ActiveHierarchyEditPolicy ep = (ActiveHierarchyEditPolicy)this.getEditPolicy(ActiveHierarchyEditPolicy.HIERA_SELECTOR_ROLE);
        if (ep != null && (desc2 = ep.getEffectiveSetDesc()) != null && (expr2 = ((ILogicalField)this.getParserElement()).getExpression(desc2)) != null) {
            if (expr2.getExpression() == null) {
                return "";
            }
            return expr2.getExpression();
        }
        EditPart dep = this.getParent();
        while (dep != null && !(dep instanceof ContainerEditPart)) {
            dep = dep.getParent();
        }
        if (dep != null && (policy = (SetEditPolicy)dep.getEditPolicy((Object)"targetRole")) != null && (desc = policy.getActiveSetDescriptor()) != null && (expr = ((ILogicalField)this.getParserElement()).getExpression(desc)) != null && expr.getExpression() != null) {
            return expr.getExpression();
        }
        return "";
    }

    public String getEditText() {
        return this.getFieldLabel();
    }

    protected boolean isEditable() {
        return false;
    }

    public boolean isSelectable() {
        return true;
    }

    protected void handleNotificationEvent(Notification event) {
        boolean refreshLabel = false;
        if (event.getFeature() == MapPackage.eINSTANCE.getField_Expression() || event.getFeature() == MapPackage.eINSTANCE.getQueryField_Expression() || event.getFeature() == MapPackage.eINSTANCE.getMapModelItem_Property()) {
            if (event.getEventType() == 3) {
                this.addSemanticListener((MapModelItem)event.getNewValue());
            } else if (event.getEventType() == 4) {
                this.removeSemanticListener((MapModelItem)event.getOldValue());
            }
            refreshLabel = true;
        }
        if (event.getFeature() == MapPackage.eINSTANCE.getField_Name() || event.getFeature() == MapPackage.eINSTANCE.getQuery_Alias() || event.getFeature() == MapPackage.eINSTANCE.getQuery_ComputedAlias()) {
            refreshLabel = true;
        }
        if (event.getFeature() == MapPackage.eINSTANCE.getExpression_Expression() || event.getFeature() == MapPackage.eINSTANCE.getExpression_Location() || event.getFeature() == MapPackage.eINSTANCE.getExpression_Aggregate() || event.getFeature() == MapPackage.eINSTANCE.getField_Expression() || event.getFeature() == MapPackage.eINSTANCE.getComputedField_Formula() || event.getFeature() == MapPackage.eINSTANCE.getComputedField_Alias() || event.getFeature() == MapPackage.eINSTANCE.getQueryField_Expression() || event.getFeature() == MapPackage.eINSTANCE.getExpression_Expression() || event.getFeature() == MapPackage.eINSTANCE.getField_Enable() || event.getFeature() == MapPackage.eINSTANCE.getQueryField_Enable() || event.getFeature() == MapPackage.eINSTANCE.getMapModelItem_Tag() || event.getFeature() == MapPackage.eINSTANCE.getItemProperty_Value()) {
            refreshLabel = true;
        }
        if ((event.getFeature() == RefPackage.eINSTANCE.getRExpressionStatus() || event.getFeature() == RefPackage.eINSTANCE.getRLogicalField_Type() || event.getFeature() == RefPackage.eINSTANCE.getRLogicalField_Status() || event.getFeature() == RefPackage.eINSTANCE.getRUsage_SourceRef() || event.getFeature() == RefPackage.eINSTANCE.getRSourceItem_Usage() || event.getFeature() == RefPackage.eINSTANCE.getRSourceItem_Usage() || event.getFeature() == RefPackage.eINSTANCE.getRUsage_InternalExpression() && (event.getOldValue() == null || event.getOldValue().equals("") || event.getNewValue() == null || event.getNewValue().equals("")) || event.getFeature() == RefPackage.eINSTANCE.getRItem_Problem()) && ((RItem)event.getNotifier()).getDataModel().eResource() != null) {
            refreshLabel = true;
        }
        super.handleNotificationEvent(event);
        if (refreshLabel && this.getParserElement() != null) {
            this.refreshLabel();
            this.refreshTooltips();
        }
    }

    protected void addSemanticListener(MapModelItem it) {
        StringBuffer b = new StringBuffer("Semantic");
        b.append(it.eClass().getName());
        b.append("_");
        b.append(it.getId());
        String id = b.toString();
        this.addListenerFilter(id, (NotificationListener)this, (EObject)it);
        this.additionalSemanticListenerFilterIds.add(id);
    }

    protected void removeSemanticListener(MapModelItem it) {
        StringBuffer b = new StringBuffer("Semantic");
        b.append(it.eClass().getName());
        b.append("_");
        b.append(it.getId());
        String id = b.toString();
        this.removeListenerFilter(id);
    }

    protected void addSemanticListeners() {
        super.addSemanticListeners();
        EObject o = this.getParserElement();
        if (o instanceof ILogicalField) {
            ILogicalField model = (ILogicalField)this.getParserElement();
            for (Expression ex : model.getExpression()) {
                this.addSemanticListener((MapModelItem)ex);
            }
            for (ItemProperty p : ((MapModelItem)model).getProperty()) {
                this.addSemanticListener((MapModelItem)p);
            }
        }
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (index != -1) {
            super.addChildVisual(childEditPart, index + 1);
        } else {
            super.addChildVisual(childEditPart, index);
        }
        GridData gd = new GridData();
        gd.horizontalIndent = 25;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessVerticalSpace = false;
        this.getFigure().setConstraint(((GraphicalEditPart)childEditPart).getFigure(), (Object)gd);
    }

    protected void removeSemanticListeners() {
        for (String s : this.additionalSemanticListenerFilterIds) {
            this.removeListenerFilter(s);
        }
        this.additionalSemanticListenerFilterIds.clear();
        super.removeSemanticListeners();
    }

    public void deactivate() {
        if (this.refAdapter.getTarget() != null) {
            this.refAdapter.getTarget().eAdapters().remove((Object)this.refAdapter);
        }
        for (String key : this.additionalSemanticListenerFilterIds) {
            this.removeListenerFilter(key);
        }
        this.additionalSemanticListenerFilterIds.clear();
        if (this.dragTracker != null) {
            this.dragTracker.deactivate();
            this.dragTracker = null;
        }
        super.deactivate();
    }

    public void activate() {
        RItem it;
        EObject obj = this.resolveSemanticElement();
        if (obj instanceof ILogicalField && (it = (RItem)((IReferencable)obj).getMapReference()) != null && !it.eAdapters().contains((Object)this.refAdapter)) {
            it.eAdapters().add((Object)this.refAdapter);
        }
        super.activate();
    }

    public DragTracker getDragTracker(Request request) {
        if (request instanceof SelectionRequest && ((SelectionRequest)request).getLastButtonPressed() == 3) {
            return null;
        }
        if (this.dragTracker != null) {
            return this.dragTracker;
        }
        this.dragTracker = new DragEditPartsTrackerEx((EditPart)this){

            public void mouseDrag(MouseEvent me, EditPartViewer viewer) {
                Level l;
                EObject ref;
                EObject o = LogicalFieldEditPart.this.resolveSemanticElement();
                if (o instanceof Field && (ref = ((Field)o).getRef()) instanceof MdNode && (l = ((MdNode)ref).getLevel()) != null && !((MdNode)ref).getMappingType().contains(MappingType.SOURCE_MAPPING) && !((MdNode)ref).getMappingType().contains(MappingType.MAPPING)) {
                    return;
                }
                if (o.eContainer() instanceof Outliner && ((Outliner)o.eContainer()).getInputField() == o) {
                    return;
                }
                super.mouseDrag(me, viewer);
            }

            protected void performDrag() {
                super.performDrag();
                StatusLineUtil.outputErrorMessage((IWorkbenchPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor(), (String)"");
            }

            protected void performSelection() {
                if (this.hasSelectionOccurred()) {
                    return;
                }
                this.setFlag(64, true);
                EditPartViewer viewer = this.getCurrentViewer();
                List selectedObjects = viewer.getSelectedEditParts();
                if (this.getCurrentInput().isModKeyDown(SWT.MOD1)) {
                    if (selectedObjects.contains(this.getSourceEditPart())) {
                        viewer.deselect(this.getSourceEditPart());
                    } else {
                        viewer.appendSelection(this.getSourceEditPart());
                    }
                } else if (this.getCurrentInput().isShiftKeyDown()) {
                    Object lastSelected = viewer.getSelectedEditParts().get(viewer.getSelectedEditParts().size() - 1);
                    EditPart ep = this.getSourceEditPart();
                    if (ep.getParent() == ((EditPart)lastSelected).getParent()) {
                        int i = ep.getParent().getChildren().indexOf(ep);
                        int j = ep.getParent().getChildren().indexOf(lastSelected);
                        int min = Math.min(i, j);
                        int max = Math.max(i, j);
                        int k = min;
                        while (k <= max && k < ep.getParent().getChildren().size()) {
                            Object o = ep.getParent().getChildren().get(k);
                            if (!viewer.getSelectedEditParts().contains(o)) {
                                viewer.appendSelection((EditPart)o);
                            }
                            ++k;
                        }
                    } else {
                        viewer.appendSelection(ep);
                    }
                } else {
                    viewer.select(this.getSourceEditPart());
                }
            }
        };
        return this.dragTracker;
    }

    protected void refreshTooltips() {
        IFigure f = this.getFigure();
        IFigure tooltip = MapDiagramUtil.updateExpressionToolTip((MapModelItem)this.resolveSemanticElement());
        if (f != null) {
            if (tooltip == null) {
                String val = this.getCurrentExpressionValue();
                if (val != null && !val.isEmpty()) {
                    f.setToolTip((IFigure)new Label(val));
                } else {
                    f.setToolTip(tooltip);
                }
            } else {
                f.setToolTip(tooltip);
            }
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshTooltips();
    }

    protected ILabelDelegate getLabelDelegate() {
        IFigure label;
        if (this.labelDelegate == null && (label = this.getFigure()) instanceof LogicalFieldFigure) {
            this.labelDelegate = new WrappingLabelDelegate(((LogicalFieldFigure)label).getFieldLabelFigure()){

                public void setSelected(boolean selected) {
                }
            };
        }
        return this.labelDelegate;
    }

    public Object getAdapter(Class key) {
        if (ILabelDelegate.class.equals((Object)key)) {
            return this.getLabelDelegate();
        }
        return super.getAdapter(key);
    }

    public void setLabel(IFigure figure) {
        this.unregisterVisuals();
        this.setFigure(figure);
        this.registerVisuals();
        this.refreshVisuals();
    }
}

