/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.parts;

import com.indy.gmf.map.diagram.custom.edit.parts.ClauseEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.ContainerEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.LinkEditPart;
import com.indy.gmf.map.diagram.custom.edit.policies.TargetFilterItemSemanticEditPolicy;
import com.indy.gmf.map.diagram.custom.figures.IBlendableFigure;
import com.indy.gmf.map.diagram.custom.preferences.MapPreferenceConstants;
import com.indy.gmf.map.diagram.custom.preferences.MapPreferenceInitializer;
import com.indy.gmf.map.diagram.custom.tooltip.TooltipHelper;
import com.indy.gmf.map.edit.provider.custom.MapIconAPI;
import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.JoinLocation;
import com.indy.map.MapPackage;
import com.indy.map.TargetFilter;
import com.indy.map.diagram.notation.mappingNotation.NodeView;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.map.util.InheritanceHelper;
import com.indy.ui.custom.out.Activator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transform;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.geometry.Vector;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class TargetFilterEditPart
extends ClauseEditPart {
    public static final int VISUAL_ID = 2006;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private Set<AnchorSupport> attachedTo = new HashSet<AnchorSupport>();
    static final Color THIS_FORE = new Color(null, 200, 200, 200);

    public void setParent(EditPart parent) {
        super.setParent(parent);
    }

    protected void relocateFigure(GraphicalEditPart anchorEditPart) {
        EObject eo = this.resolveSemanticElement();
        if (anchorEditPart == null) {
            this.refreshBounds();
            return;
        }
        if (eo instanceof TargetFilter && eo.eContainer() instanceof IContainer && this.getRoot() != null) {
            TargetFilter f = (TargetFilter)eo;
            Dimension sz = null;
            Point pt = null;
            if (f.getLocation() == JoinLocation.TRG) {
                IContainer container = (IContainer)f.eContainer();
                int index = container.getTargetFilter().indexOf((Object)f);
                Rectangle r = anchorEditPart.getFigure().getBounds();
                sz = this.getFigure().getPreferredSize(-1, -1).getCopy();
                pt = new Point(r.x + 1 + index * (sz.width + 1), r.y + r.height);
            } else if (anchorEditPart.getFigure().isVisible()) {
                PrecisionPoint b;
                List hiera = new ArrayList();
                if (f.getDataSet() != null) {
                    hiera = InheritanceHelper.getDataSetHierarchy((DataSet)f.getDataSet());
                }
                IContainer parent = (IContainer)f.eContainer();
                ArrayList<TargetFilter> filters = new ArrayList<TargetFilter>();
                for (TargetFilter tf : parent.getTargetFilter()) {
                    if (!hiera.contains(tf.getDataSet())) continue;
                    filters.add(tf);
                }
                int index = filters.indexOf(f);
                sz = this.getFigure().getPreferredSize();
                PrecisionPoint a = new PrecisionPoint(((PolylineConnection)anchorEditPart.getFigure()).getPoints().getLastPoint());
                Vector segment = new Vector(a, b = new PrecisionPoint(((PolylineConnection)anchorEditPart.getFigure()).getPoints().getFirstPoint()));
                if (segment.getLength() == 0.0) {
                    this.refreshBounds();
                    return;
                }
                Vector v = new Vector(new PrecisionPoint(0, 0), new PrecisionPoint(1, 0));
                double diagonale = Math.sqrt(Math.pow(sz.width, 2.0) + Math.pow(sz.height, 2.0));
                PrecisionRectangle totalBounds = new PrecisionRectangle((Point)a, (Dimension)new PrecisionDimension((double)filters.size() * diagonale, diagonale));
                Vector centerVect = new Vector(new PrecisionPoint(totalBounds.getCenter()), a);
                pt = new PrecisionPoint((Point)a);
                pt.x = (int)((double)pt.x + (double)index * diagonale);
                pt.x -= a.x;
                pt.y -= a.y;
                double mid = diagonale * (double)filters.size() / 2.0;
                Transform t = new Transform();
                int sign = 1;
                if (segment.y < 0.0) {
                    sign = -1;
                }
                double angle = v.getAngle(segment);
                t.setRotation((double)sign * Math.toRadians(angle));
                pt = t.getTransformed(pt);
                centerVect = new Vector(new PrecisionPoint(t.getTransformed((Point)centerVect.toPoint())));
                pt.x += a.x;
                pt.y += a.y;
                t.setRotation(0.0);
                t.setTranslation(centerVect.x, centerVect.y);
                pt.x -= sz.width / 2;
                pt.y -= sz.height / 2;
                if (MapPreferenceInitializer.TargetFilterLocation.Target.name().equalsIgnoreCase(MapPreferenceConstants.getString("targetFilterLocation"))) {
                    pt.x -= sz.width / 2;
                    pt.y -= sz.height / 2;
                    t = new Transform();
                    t.setTranslation(segment.x, segment.y);
                    pt = t.getTransformed(pt);
                    double theta = Math.PI;
                    double x = Math.cos(theta) * ((double)(pt.x - b.x) + diagonale) - Math.sin(theta) * ((double)(pt.y - b.y) + diagonale) + (double)b.x;
                    double y = Math.sin(theta) * ((double)(pt.x - b.x) + diagonale) + Math.cos(theta) * ((double)(pt.y - b.y) + diagonale) + (double)b.y;
                    pt = new Point(x, y);
                    Vector normalized = segment.getDivided(-segment.getLength());
                    normalized = normalized.getMultiplied(25.0);
                    t.setTranslation(normalized.x, normalized.y);
                    pt = t.getTransformed(pt);
                }
            }
            if (pt != null && sz != null) {
                this.getFigure().translateToAbsolute(pt);
                this.getFigure().translateToAbsolute(sz);
                IFigure layer = this.getLayer("Primary Layer");
                if (layer != null) {
                    layer.translateToRelative(pt);
                }
                if (sz.isEmpty()) {
                    sz = this.getFigure().getPreferredSize(-1, -1).getCopy();
                }
                if (layer != null) {
                    this.getLayer("Primary Layer").translateToRelative((Translatable)sz);
                }
                if (this.getParent() != null) {
                    ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new Rectangle(pt, sz));
                }
            }
        }
    }

    public TargetFilterEditPart(View view) {
        super(view);
    }

    @Override
    public void activate() {
        this.refreshAnchorEditPart();
        super.activate();
    }

    @Override
    public void deactivate() {
        this.attachedTo.forEach(ep -> ep.detachTargetEditPart(this));
        super.deactivate();
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new TargetFilterItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }

            public Command getCommand(Request request) {
                if (request instanceof ChangeBoundsRequest) {
                    if (MapPreferenceConstants.getBoolean("mapShowSourceSet")) {
                        return super.getCommand(request);
                    }
                    return UnexecutableCommand.INSTANCE;
                }
                return super.getCommand(request);
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new TargetFilterFigure();
        this.refreshIcon();
        return this.primaryShape;
    }

    public TargetFilterFigure getPrimaryShape() {
        return (TargetFilterFigure)this.primaryShape;
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(28, 28);
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setBackgroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setBackgroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    @Override
    protected void refreshIcon() {
        EObject parserElement = this.resolveSemanticElement();
        if (parserElement instanceof TargetFilter) {
            this.getPrimaryShape().setImage(MapIconAPI.getTrgFilterIcon((TargetFilter)((TargetFilter)parserElement)));
            Color color = null;
            if (((TargetFilter)parserElement).isEnable()) {
                RGB rgb = PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.targetColor");
                color = Activator.getDefault().getColor(rgb);
            } else {
                color = ColorConstants.gray;
            }
            this.getPrimaryShape().rectangle.setForegroundColor(color);
        }
    }

    private void refreshAnchorEditPart() {
        EObject o = this.resolveSemanticElement();
        if (o instanceof TargetFilter) {
            ContainerEditPart cep;
            TargetFilter f = (TargetFilter)o;
            if (f.getLocation() == JoinLocation.TRG) {
                this.attachedTo.forEach(l -> l.detachTargetEditPart(this));
                this.attachedTo.clear();
                IContainer container = (IContainer)f.eContainer();
                EditPart containerEditPart = this.findEditPart(this.getParent(), (EObject)container);
                if (containerEditPart instanceof AnchorSupport) {
                    ((AnchorSupport)containerEditPart).attachTargetEditPart(this);
                    this.attachedTo.add((AnchorSupport)containerEditPart);
                    this.relocateFigure((GraphicalEditPart)containerEditPart);
                }
            } else if (!f.getInvolvedContainers().isEmpty() && (cep = (ContainerEditPart)this.findEditPart((EditPart)this.getRoot(), f.eContainer())) != null) {
                for (Object c : cep.getTargetConnections()) {
                    if (!(c instanceof LinkEditPart) || this.attachedTo.contains(c) || !"targetDataSetLink".equals(((LinkEditPart)c).getNotationView().getType()) || ((LinkEditPart)c).getNotationView().getElement() != ((NodeView)this.getNotationView()).getSubElement()) continue;
                    ((LinkEditPart)c).attachTargetEditPart(this);
                    this.attachedTo.add((LinkEditPart)c);
                    ((LinkEditPart)c).refresh();
                }
            }
        }
    }

    @Override
    protected void handleNotificationEvent(Notification notification) {
        if (notification.getFeature() == MapPackage.eINSTANCE.getClause_Location()) {
            this.refreshAnchorEditPart();
        }
        super.handleNotificationEvent(notification);
        if (notification.getFeature() == MapPackage.eINSTANCE.getTargetFilter_Aggregate() || notification.getFeature() == MapPackage.eINSTANCE.getClause_Enable()) {
            this.refreshIcon();
        }
    }

    protected void refreshBounds() {
    }

    public void refresh() {
        super.refresh();
    }

    protected void refreshVisibility() {
        block12: {
            super.refreshVisibility();
            boolean showTargetLink = false;
            boolean showTargetSetLink = false;
            boolean showDataSetLink = false;
            if (MapPreferenceConstants.getBoolean("mapShowSourceSet")) {
                if (MapPreferenceConstants.getBoolean("mapShowDependencies")) {
                    showTargetLink = true;
                } else {
                    showTargetSetLink = true;
                }
            } else if (MapPreferenceConstants.getBoolean("mapShowDependencies")) {
                showTargetLink = true;
            } else {
                showDataSetLink = true;
            }
            if (!showDataSetLink && this.getSourceConnections().size() != 0) {
                if (this.getSourceConnections().get(0) instanceof LinkEditPart) {
                    try {
                        String type = ((LinkEditPart)this.getSourceConnections().get(0)).getNotationView().getType();
                        if (type.equals("joinLink")) {
                            this.setVisibility(true);
                            break block12;
                        }
                        this.setVisibility(false);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.setVisibility(true);
                    }
                } else {
                    this.setVisibility(true);
                }
            }
        }
    }

    public static interface AnchorSupport {
        public void detachTargetEditPart(TargetFilterEditPart var1);

        public void attachTargetEditPart(TargetFilterEditPart var1);
    }

    public class TargetFilterFigure
    extends Figure
    implements IBlendableFigure,
    TooltipHelper.ITooltipable {
        private ImageFigure image;
        private boolean alphaBlended = false;
        private RoundedRectangle rectangle;
        private IFigure improvedTooltip;

        public TargetFilterFigure() {
            GridLayout gl = new GridLayout();
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            this.setLayoutManager((LayoutManager)gl);
            this.rectangle = new RoundedRectangle();
            this.rectangle.setLayoutManager((LayoutManager)new StackLayout(){

                public void layout(IFigure figure) {
                    Rectangle r = figure.getClientArea();
                    ++r.x;
                    r.y += 2;
                    List children = figure.getChildren();
                    int i = 0;
                    while (i < children.size()) {
                        IFigure child = (IFigure)children.get(i);
                        child.setBounds(r);
                        ++i;
                    }
                }
            });
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.targetColor");
            this.rectangle.setForegroundColor(Activator.getDefault().getColor(rgb));
            this.rectangle.setLineWidth(2);
            int size = TargetFilterEditPart.this.getMapMode().DPtoLP(30);
            this.setPreferredSize(new Dimension(size, size));
            this.setMaximumSize(new Dimension(size, size));
            this.setMinimumSize(new Dimension(size, size));
            int w = TargetFilterEditPart.this.getMapMode().DPtoLP(25);
            int h = TargetFilterEditPart.this.getMapMode().DPtoLP(25);
            this.rectangle.setCornerDimensions(new Dimension(TargetFilterEditPart.this.getMapMode().DPtoLP(8), TargetFilterEditPart.this.getMapMode().DPtoLP(8)));
            this.rectangle.setPreferredSize(new Dimension(w, h));
            this.rectangle.setMaximumSize(new Dimension(w, h));
            this.rectangle.setMinimumSize(new Dimension(w, h));
            this.add((IFigure)this.rectangle, new GridData(2, 2, true, true));
        }

        protected void setImage(Image img) {
            if (this.image != null) {
                this.rectangle.remove((IFigure)this.image);
            }
            this.image = new ImageFigure(img);
            this.rectangle.add((IFigure)this.image);
        }

        @Override
        public void setAlphaBlended(boolean value) {
            if (value == this.alphaBlended) {
                return;
            }
            this.alphaBlended = value;
            this.rectangle.setAlpha(!this.alphaBlended ? 255 : 20);
            this.repaint();
        }

        @Override
        public boolean isAlphaBlended() {
            return this.alphaBlended;
        }

        public void paint(Graphics graphics) {
            graphics.pushState();
            graphics.setAlpha(!this.alphaBlended ? 255 : 20);
            super.paint(graphics);
            graphics.popState();
        }

        @Override
        public IFigure getImprovedTooltip() {
            return this.improvedTooltip;
        }

        @Override
        public void setImprovedTooltip(IFigure tooltip) {
            this.improvedTooltip = tooltip;
        }
    }
}

