/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.edit.policies.PromptFieldDropCommand;
import com.indy.gmf.map.diagram.custom.preferences.MapPreferenceConstants;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.gmf.map.edit.provider.custom.MapIconAPI;
import com.indy.map.DataSet;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IMetaData;
import com.indy.map.Join;
import com.indy.map.Outliner;
import com.indy.map.compute.validator.DataSetOperatorValidator;
import com.indy.map.diagram.part.MapDiagramActionBarContributor;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.services.IDropValidationService;
import com.indy.ui.custom.out.tools.FigureColoringHelper;
import com.stambia.md.MdNode;
import com.stambia.tech.Level;
import com.stambia.tech.MappingType;
import java.util.Arrays;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramDragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractFieldDndEditPolicy
extends DiagramDragDropEditPolicy {
    protected static final String AUTO_TEST = "com.indy.gmf.map.automatedTest";
    private static final Image enabledMapImg = MapDiagramEditorPlugin.getInstance().getBundledImage("/icons/obj64x64/targetLink64x64.png");
    private static final Image disabledMapImg = MapDiagramEditorPlugin.getInstance().getBundledImage("/icons/obj64x64/targetsetLink64x64.png");
    public static final String REQ_DROP_TYPE = "request.dropType";
    protected static final String DROP_REQUEST_PARAM_CMDKIND = "dropRequest.commandKind";
    private DecorationFigure joinDecorationFigure;
    private DecorationFigure mapDecorationFigure;

    protected boolean fieldCanBeTarget(Field f) {
        Level l;
        if (f.eContainer() instanceof Outliner) {
            return false;
        }
        EObject ref = f.getRef();
        if (ref instanceof MdNode && (l = ((MdNode)ref).getLevel()) != null && (((MdNode)ref).getMappingType().contains(MappingType.MAPPING) || ((MdNode)ref).getMappingType().contains(MappingType.TARGET_MAPPING)) && (ref = ((IMetaData)f.eContainer()).getRef()) instanceof MdNode && (l = ((MdNode)ref).getLevel()) != null) {
            return ((MdNode)ref).getMappingType().contains(MappingType.TARGET);
        }
        return true;
    }

    public static boolean isAutomatedTest() {
        String o;
        boolean AUTOMATED_TEST = false;
        EnvironmentInfo service = (EnvironmentInfo)PlatformUI.getWorkbench().getService(EnvironmentInfo.class);
        if (service != null && (o = service.getProperty(AUTO_TEST)) != null && Boolean.parseBoolean(o)) {
            AUTOMATED_TEST = true;
        }
        return AUTOMATED_TEST;
    }

    protected boolean fieldCanBeSource(Field f) {
        Level l;
        EObject ref = f.getRef();
        if (ref instanceof MdNode && (l = ((MdNode)ref).getLevel()) != null && (((MdNode)ref).getMappingType().contains(MappingType.MAPPING) || ((MdNode)ref).getMappingType().contains(MappingType.SOURCE_MAPPING)) && (ref = ((IMetaData)f.eContainer()).getRef()) instanceof MdNode && (l = ((MdNode)ref).getLevel()) != null) {
            return ((MdNode)ref).getMappingType().contains(MappingType.SOURCE);
        }
        return true;
    }

    protected Command createCommand(ILogicalField srcObject, ILogicalField trgObject, DropObjectsRequest request) {
        IDropValidationService service = (IDropValidationService)PlatformUI.getWorkbench().getService(IDropValidationService.class);
        IDropValidationService.DropResult drop = service.validate((EObject)srcObject, (EObject)trgObject, true);
        boolean isInheritance = Util.currentKeyPressed == 65536;
        request.getExtendedData().put(REQ_DROP_TYPE, drop);
        request.getExtendedData().put("inherit", isInheritance);
        switch (drop) {
            case JOIN_ALLOWED: {
                boolean canCreateOperation;
                this.eraseTargetFeedback((Request)request);
                this.showTargetFeedback((Request)request);
                DataSet filterDataSet = ((IContainer)trgObject.eContainer()).getDataset();
                DataSet filteredDataSet = ((IContainer)srcObject.eContainer()).getDataset();
                boolean bl = canCreateOperation = !DataSetOperatorValidator.INSTANCE.canCreateLink(filterDataSet, filteredDataSet).isError();
                if (canCreateOperation) {
                    return this.createJoinOrOperatorCommand(request);
                }
                return this.createJoinCommand((ILogicalField)request.getObjects().get(0));
            }
            case MAP_ALLOWED: {
                if (isInheritance) {
                    return UnexecutableCommand.INSTANCE;
                }
                this.eraseTargetFeedback((Request)request);
                this.showTargetFeedback((Request)request);
                return this.createMappingCommand(request);
            }
            case MAP_JOIN_ALLOWED: {
                boolean isMapped = ((IContainer)trgObject.eContainer()).getSrcContainers().contains(srcObject.eContainer());
                boolean isJoined = false;
                for (Join j : ((IContainer)trgObject.eContainer()).getDataset().getJoin()) {
                    if (!j.getInvolvedContainers().contains(srcObject.eContainer())) continue;
                    isJoined = true;
                    break;
                }
                if (isMapped) {
                    if (isInheritance) {
                        return UnexecutableCommand.INSTANCE;
                    }
                    this.eraseTargetFeedback((Request)request);
                    this.showTargetFeedback((Request)request);
                    return this.createMappingCommand(request);
                }
                if (isJoined) {
                    this.eraseTargetFeedback((Request)request);
                    this.showTargetFeedback((Request)request);
                    return this.createJoinCommand((ILogicalField)request.getObjects().get(0));
                }
                this.eraseTargetFeedback((Request)request);
                this.showTargetFeedback((Request)request);
                if (isInheritance) {
                    return this.createJoinCommand((ILogicalField)request.getObjects().get(0));
                }
                return this.createChooseMapOrJoinCommand(request);
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }

    protected Command getDragCommand(ChangeBoundsRequest request) {
        Level l;
        EObject ref;
        EObject o = this.getHostObject();
        if (o instanceof Field && (ref = ((Field)o).getRef()) instanceof MdNode && (l = ((MdNode)ref).getLevel()) != null && !((MdNode)ref).getMappingType().contains(MappingType.SOURCE_MAPPING) && !((MdNode)ref).getMappingType().contains(MappingType.MAPPING)) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getDragCommand(request);
    }

    public Command getDropObjectsCommand(DropObjectsRequest request) {
        if (request.getObjects() != null && request.getObjects().size() > 0 && request.getObjects().get(0) instanceof ILogicalField) {
            ILogicalField srcObject = (ILogicalField)request.getObjects().get(0);
            ILogicalField trgObject = (ILogicalField)((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
            return this.createCommand(srcObject, trgObject, request);
        }
        return null;
    }

    public void deactivate() {
        super.deactivate();
        this.clearFeedbackDecoration();
    }

    public void activate() {
        this.createDecorationFigures();
        super.activate();
    }

    protected abstract Command createMappingCommand(DropObjectsRequest var1);

    protected abstract Command createJoinCommand(ILogicalField var1);

    protected abstract Command createInheritanceCommand(DropObjectsRequest var1);

    protected abstract Command createOperatorCommand(DropObjectsRequest var1);

    protected abstract Command createJoinOrOperatorCommand(DropObjectsRequest var1);

    protected Command createChooseMapOrJoinCommand(DropObjectsRequest request) {
        IDropValidationService.DropResult rs = (IDropValidationService.DropResult)request.getExtendedData().get(REQ_DROP_TYPE);
        if (rs == null) {
            rs = IDropValidationService.DropResult.MAP_JOIN_ALLOWED;
        }
        if (rs instanceof IDropValidationService.DropResult) {
            switch (rs) {
                case JOIN_ALLOWED: {
                    boolean canCreateOperation;
                    ILogicalField trgObject = (ILogicalField)((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
                    ILogicalField srcObject = (ILogicalField)request.getObjects().get(0);
                    DataSet filterDataSet = ((IContainer)trgObject.eContainer()).getDataset();
                    DataSet filteredDataSet = ((IContainer)srcObject.eContainer()).getDataset();
                    boolean bl = canCreateOperation = !DataSetOperatorValidator.INSTANCE.canCreateLink(filterDataSet, filteredDataSet).isError();
                    if (canCreateOperation) {
                        return this.createJoinOrOperatorCommand(request);
                    }
                    return this.createJoinCommand((ILogicalField)request.getObjects().get(0));
                }
                case MAP_ALLOWED: {
                    return this.createMappingCommand(request);
                }
            }
        }
        return new ICommandProxy((ICommand)new PromptFieldDropCommand(true, this, request, Arrays.asList(CmdKind.JOIN, CmdKind.MAP, CmdKind.MAP_AUTO, CmdKind.OPERATOR)));
    }

    public void showTargetFeedback(Request request) {
        IDropValidationService.DropResult dropType = (IDropValidationService.DropResult)request.getExtendedData().get(REQ_DROP_TYPE);
        Boolean inehrit = (Boolean)request.getExtendedData().get("inherit");
        if (dropType != null) {
            this.revertColor = this.getHostFigure().getBackgroundColor();
            this.opacity = this.getHostFigure().isOpaque();
            if (inehrit != null && inehrit.booleanValue()) {
                this.getHostFigure().setBackgroundColor(MapDiagramEditorPlugin.getInstance().mixColors(ColorConstants.blue, this.revertColor));
            } else if (dropType == IDropValidationService.DropResult.MAP_JOIN_ALLOWED) {
                this.getHostFigure().setBackgroundColor(FigureColoringHelper.getActionParamRefSetColor());
                this.getHostFigure().setBackgroundColor(MapDiagramEditorPlugin.getInstance().mixColors(FigureColoringHelper.getActionParamRefSetColor(), this.revertColor));
                this.updateFeedbackDecoration((DropObjectsRequest)request);
            } else if (dropType == IDropValidationService.DropResult.JOIN_ALLOWED) {
                this.getHostFigure().setBackgroundColor(MapDiagramEditorPlugin.getInstance().mixColors(ColorConstants.blue, this.revertColor));
                this.clearFeedbackDecoration();
            } else if (dropType == IDropValidationService.DropResult.MAP_ALLOWED) {
                this.getHostFigure().setBackgroundColor(FigureColoringHelper.getActionColorStateKilled());
                this.clearFeedbackDecoration();
            }
            this.getHostFigure().setOpaque(true);
        }
    }

    public void eraseTargetFeedback(Request request) {
        if (this.revertColor != null) {
            this.getHostFigure().setBackgroundColor(this.revertColor);
            this.getHostFigure().setOpaque(this.opacity);
            this.revertColor = null;
            this.clearFeedbackDecoration();
        }
    }

    private void clearFeedbackDecoration() {
        if (this.joinDecorationFigure != null && this.joinDecorationFigure.getParent() != null) {
            this.joinDecorationFigure.getParent().remove((IFigure)this.joinDecorationFigure);
        }
        if (this.mapDecorationFigure != null && this.mapDecorationFigure.getParent() != null) {
            this.mapDecorationFigure.getParent().remove((IFigure)this.mapDecorationFigure);
        }
    }

    private void createDecorationFigures() {
        if (MapPreferenceConstants.getBoolean("mapOrJoinPrompt")) {
            return;
        }
        this.joinDecorationFigure = new DecorationFigure(MapIconAPI.getImage((String)"full/obj16x22/JoinFondNormal64x47.png"), MapIconAPI.getImage((String)"full/obj16x22/JoinFondGris64x47.png"));
        this.joinDecorationFigure.setSize(64, 47);
        this.mapDecorationFigure = new DecorationFigure(enabledMapImg, disabledMapImg);
        this.mapDecorationFigure.setSize(64, 47);
    }

    private void relocateDecorations() {
        if (MapPreferenceConstants.getBoolean("mapOrJoinPrompt")) {
            return;
        }
        if (this.joinDecorationFigure.getParent() == null) {
            this.getLayer("Decoration Unprintable Layer").add((IFigure)this.joinDecorationFigure);
        }
        if (this.mapDecorationFigure.getParent() == null) {
            this.getLayer("Decoration Unprintable Layer").add((IFigure)this.mapDecorationFigure);
        }
        Rectangle r = this.getHostFigure().getBounds().getCopy();
        this.getHostFigure().translateToAbsolute((Translatable)r);
        this.getLayer("Decoration Unprintable Layer").translateToRelative((Translatable)r);
        this.joinDecorationFigure.setLocation(new Point(r.x - 50, r.getCenter().y - this.joinDecorationFigure.getBounds().height / 2));
        this.mapDecorationFigure.setLocation(new Point(r.x + r.width, r.getCenter().y - this.mapDecorationFigure.getBounds().height / 2));
    }

    private void updateFeedbackDecoration(DropObjectsRequest req) {
        if (MapPreferenceConstants.getBoolean("mapOrJoinPrompt")) {
            return;
        }
        if (this.joinDecorationFigure == null || this.mapDecorationFigure == null) {
            this.createDecorationFigures();
        }
        this.relocateDecorations();
        Rectangle bounds = this.getHostFigure().getBounds().getCopy();
        this.getHostFigure().translateToAbsolute((Translatable)bounds);
        Point mouseLocation = req.getLocation();
        if (mouseLocation != null) {
            this.joinDecorationFigure.setVisible(true);
            this.mapDecorationFigure.setVisible(true);
            if (mouseLocation.x <= bounds.getCenter().x) {
                this.joinDecorationFigure.setEnablement(true);
                this.mapDecorationFigure.setEnablement(false);
                req.getExtendedData().put(REQ_DROP_TYPE, IDropValidationService.DropResult.JOIN_ALLOWED);
            } else {
                this.joinDecorationFigure.setEnablement(false);
                this.mapDecorationFigure.setEnablement(true);
                req.getExtendedData().put(REQ_DROP_TYPE, IDropValidationService.DropResult.MAP_ALLOWED);
            }
        } else {
            this.joinDecorationFigure.setVisible(false);
            this.mapDecorationFigure.setVisible(false);
        }
    }

    protected static enum CmdKind {
        MAP(Messages.AbstractFieldDndEditPolicy_5),
        MAP_AUTO(Messages.AbstractFieldDndEditPolicy_8),
        JOIN(Messages.AbstractFieldDndEditPolicy_4),
        OPERATOR(Messages.AbstractFieldDndEditPolicy_6);

        String label;

        private CmdKind(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        Image getImage() {
            switch (this) {
                case JOIN: {
                    return MapIconAPI.getImage((String)"full/obj16x22/JoinFondNormal16x22.gif");
                }
                case MAP: 
                case MAP_AUTO: {
                    return MapDiagramActionBarContributor.targetLink;
                }
                case OPERATOR: {
                    return MapIconAPI.getImage((String)"full/obj16x16/Filtre22x22Exists6.png");
                }
            }
            return null;
        }
    }

    private class DecorationFigure
    extends Figure {
        public DecorationFigure(Image enable, Image disable) {
            RectangleFigure f;
            this.setLayoutManager((LayoutManager)new StackLayout());
            this.setOpaque(true);
            this.setBorder((Border)new LineBorder(ColorConstants.lightGray));
            if (enable != null) {
                this.add((IFigure)new ImageFigure(enable));
            } else {
                f = new RectangleFigure();
                f.setSize(50, 50);
                f.setForegroundColor(ColorConstants.red);
                this.add((IFigure)f);
                f.setVisible(false);
            }
            if (disable != null) {
                this.add((IFigure)new ImageFigure(disable));
            } else {
                f = new RectangleFigure();
                f.setSize(50, 50);
                f.setForegroundColor(ColorConstants.lightGray);
                this.add((IFigure)f);
                f.setVisible(false);
            }
        }

        public void setEnablement(boolean isEnable) {
            if (isEnable) {
                ((IFigure)this.getChildren().get(0)).setVisible(true);
                ((IFigure)this.getChildren().get(1)).setVisible(false);
            } else {
                ((IFigure)this.getChildren().get(0)).setVisible(false);
                ((IFigure)this.getChildren().get(1)).setVisible(true);
            }
        }
    }
}

