/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.edit.policies.ContainerSelectionEditPolicy;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.diagram.edit.parts.DatastoreEditPart;
import com.indy.map.diagram.edit.parts.OutlinerEditPart;
import com.indy.map.diagram.edit.parts.QueryEditPart;
import com.indy.map.diagram.part.MapVisualIDRegistry;
import com.indy.ui.custom.out.Activator;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.swt.graphics.RGB;

public class ColorContainerHeaderEditPolicy
extends AbstractEditPolicy {
    public static final String ROLE_COLORING_HEADER = "role.colorContainer";
    public static final String REQ_COLOR_HEADER = "request.colorContainerHeader";

    public Command getCommand(Request request) {
        if (request instanceof ColorHeaderRequest) {
            return new ColorHeaderCommand((ColorHeaderRequest)request);
        }
        return super.getCommand(request);
    }

    private class ColorHeaderCommand
    extends Command {
        ColorHeaderRequest request;
        private RGB oldForeground;
        private RGB oldBackground;
        private boolean wasBold;
        private boolean wasOpaque;
        private boolean backedup;

        ColorHeaderCommand(ColorHeaderRequest request) {
            super(Messages.ColorContainerHeaderEditPolicy_2);
            this.backedup = false;
            this.request = request;
        }

        public void undo() {
            IGraphicalEditPart gep = (IGraphicalEditPart)ColorContainerHeaderEditPolicy.this.getHost();
            IGraphicalEditPart titleGep = null;
            if (gep instanceof DatastoreEditPart) {
                titleGep = gep.getChildBySemanticHint(MapVisualIDRegistry.getType(5005));
            } else if (gep instanceof QueryEditPart) {
                titleGep = gep.getChildBySemanticHint(MapVisualIDRegistry.getType(5001));
            } else if (gep instanceof OutlinerEditPart) {
                titleGep = gep.getChildBySemanticHint(MapVisualIDRegistry.getType(5090));
            }
            if (titleGep != null) {
                this.performChanges(titleGep, this.oldForeground, this.oldBackground, this.wasBold, this.wasOpaque);
            }
        }

        private void backup(IGraphicalEditPart titleGep) {
            this.oldBackground = titleGep.getFigure().getBackgroundColor() == null ? null : titleGep.getFigure().getBackgroundColor().getRGB();
            this.oldForeground = titleGep.getFigure().getBackgroundColor() == null ? null : titleGep.getFigure().getForegroundColor().getRGB();
            this.wasOpaque = titleGep.getFigure().isOpaque();
            this.wasBold = titleGep.getFigure().getFont() == ContainerSelectionEditPolicy.BOLD_FONT;
        }

        private void performChanges(IGraphicalEditPart titleGep, RGB foreGround, RGB background, boolean bold, boolean opaque) {
            titleGep.getFigure().setBackgroundColor(Activator.getDefault().getColor(background));
            titleGep.getFigure().setForegroundColor(Activator.getDefault().getColor(foreGround));
            titleGep.getFigure().setOpaque(opaque);
            if (bold) {
                titleGep.getFigure().setFont(ContainerSelectionEditPolicy.BOLD_FONT);
            } else {
                titleGep.getFigure().setFont(ContainerSelectionEditPolicy.REGULAR_FONT);
            }
        }

        public void execute() {
            IGraphicalEditPart gep = (IGraphicalEditPart)ColorContainerHeaderEditPolicy.this.getHost();
            IGraphicalEditPart titleGep = null;
            if (gep instanceof DatastoreEditPart) {
                titleGep = gep.getChildBySemanticHint(MapVisualIDRegistry.getType(5005));
            } else if (gep instanceof QueryEditPart) {
                titleGep = gep.getChildBySemanticHint(MapVisualIDRegistry.getType(5001));
            } else if (gep instanceof OutlinerEditPart) {
                titleGep = gep.getChildBySemanticHint(MapVisualIDRegistry.getType(5090));
            }
            if (titleGep != null) {
                if (!this.backedup) {
                    this.backup(titleGep);
                }
                this.performChanges(titleGep, this.request.foregroundColor, this.request.backgroundColor, this.request.useBoldFont, this.request.isOpaque);
            }
        }
    }

    public static class ColorHeaderRequest
    extends Request {
        private RGB backgroundColor;
        private RGB foregroundColor;
        private boolean useBoldFont;
        private boolean isOpaque;

        public ColorHeaderRequest(RGB backgroundColor, RGB foregroundColor, boolean useBoldFont, boolean isOpaque) {
            this.setType(ColorContainerHeaderEditPolicy.REQ_COLOR_HEADER);
            this.backgroundColor = backgroundColor;
            this.foregroundColor = foregroundColor;
            this.isOpaque = isOpaque;
            this.useBoldFont = useBoldFont;
        }
    }
}

